/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.interact.InteractionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H \u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\u0014J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H$J\u001e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/ComponentTransientState;", "", "viewBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "dataBounds", "getDataBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "isCoordFlip", "", "()Z", "<set-?>", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "offset", "getOffset", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "scale", "getScale", "getViewBounds", "applyDelta", "", "scaleDelta", "offsetDelta", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "repaint", "repaint$plot_builder", "reset", "syncDataBounds", "transformView", "plot-builder"})
public abstract class ComponentTransientState {
    @NotNull
    private final DoubleRectangle viewBounds;
    @NotNull
    private DoubleVector scale;
    @NotNull
    private DoubleVector offset;

    public ComponentTransientState(@NotNull DoubleRectangle viewBounds) {
        Intrinsics.checkNotNullParameter((Object)viewBounds, (String)"viewBounds");
        this.viewBounds = viewBounds;
        this.scale = new DoubleVector(1.0, 1.0);
        this.offset = DoubleVector.Companion.getZERO();
    }

    @NotNull
    public final DoubleRectangle getViewBounds() {
        return this.viewBounds;
    }

    @NotNull
    public final DoubleVector getScale() {
        return this.scale;
    }

    @NotNull
    public final DoubleVector getOffset() {
        return this.offset;
    }

    @NotNull
    public abstract DoubleRectangle getDataBounds();

    public abstract boolean isCoordFlip();

    public final void applyDelta(@NotNull DoubleVector scaleDelta, @NotNull DoubleVector offsetDelta, @NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)scaleDelta, (String)"scaleDelta");
        Intrinsics.checkNotNullParameter((Object)offsetDelta, (String)"offsetDelta");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        DoubleVector offset2 = new DoubleVector(this.offset.getX() + offsetDelta.getX() / this.scale.getX(), this.offset.getY() + offsetDelta.getY() / this.scale.getY());
        DoubleVector scale = new DoubleVector(this.scale.getX() * scaleDelta.getX(), this.scale.getY() * scaleDelta.getY());
        this.transformView(scale, offset2, ctx2);
    }

    public final void reset() {
    }

    public final void transformView(@NotNull DoubleVector scale, @NotNull DoubleVector offset2, @NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.scale = scale;
        this.offset = offset2;
        this.syncDataBounds(ctx2);
        this.repaint$plot_builder(ctx2);
    }

    protected abstract void syncDataBounds(@NotNull InteractionContext var1);

    public abstract void repaint$plot_builder(@NotNull InteractionContext var1);
}

