/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BarTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J \u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J0\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\tR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "()V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "whiskerWidth", "getWhiskerWidth", "setWhiskerWidth", "widthUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getWidthUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setWidthUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildLines", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "widthSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "resolution", "isDiscrete", "", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBoxplotGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class BoxplotGeom
extends GeomBase
implements WithWidth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidline = 2.0;
    private double whiskerWidth = 0.5;
    @NotNull
    private DimensionUnit widthUnit = DEF_WIDTH_UNIT;
    public static final double DEF_FATTEN_MIDLINE = 2.0;
    public static final double DEF_WHISKER_WIDTH = 0.5;
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(true);

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    public final double getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public final void setWhiskerWidth(double d) {
        this.whiskerWidth = d;
    }

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BoxplotGeom.Companion.clientRectByDataPoint(ctx2, geomHelper, this.widthUnit, false));
        this.buildLines(root, aesthetics2, geomHelper);
        Object[] objectArray = new Aes[]{Aes.Companion.getYMAX(), Aes.Companion.getUPPER(), Aes.Companion.getMIDDLE(), Aes.Companion.getLOWER(), Aes.Companion.getYMIN()};
        BarTooltipHelper.collectRectangleTargets$default(BarTooltipHelper.INSTANCE, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx2, BoxplotGeom.Companion.clientRectByDataPoint(ctx2, geomHelper, this.widthUnit, true), buildIntern.1.INSTANCE, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, 128, null);
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    private final void buildLines(SvgRoot root, Aesthetics aesthetics2, GeomHelper geomHelper) {
        BoxHelper.INSTANCE.buildMidlines(root, aesthetics2, Aes.Companion.getX(), Aes.Companion.getMIDDLE(), Aes.Companion.getWIDTH(), this.widthUnit, geomHelper, this.fattenMidline, false);
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            double fence;
            double hinge;
            Pair<Double, Double> pair2;
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getWIDTH());
            double w = d2 != null ? d2 : 0.0;
            double halfWidth = w * geomHelper.getUnitResolution(this.widthUnit, Aes.Companion.getX()) / (double)2;
            double halfFenceWidth = halfWidth * this.whiskerWidth;
            if (p.finiteOrNull(Aes.Companion.getLOWER(), Aes.Companion.getYMIN()) != null) {
                boolean bl = false;
                hinge = ((Number)pair2.component1()).doubleValue();
                fence = ((Number)pair2.component2()).doubleValue();
                Pair pair3 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p, null, 8, null);
                Intrinsics.checkNotNull((Object)pair3);
                root.add((SvgNode)pair3.getFirst());
                Pair pair4 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2 - halfFenceWidth, fence), new DoubleVector(x2 + halfFenceWidth, fence), p, null, 8, null);
                Intrinsics.checkNotNull((Object)pair4);
                root.add((SvgNode)pair4.getFirst());
            }
            if (p.finiteOrNull(Aes.Companion.getUPPER(), Aes.Companion.getYMAX()) == null) continue;
            boolean bl = false;
            hinge = ((Number)pair2.component1()).doubleValue();
            fence = ((Number)pair2.component2()).doubleValue();
            Pair pair5 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p, null, 8, null);
            Intrinsics.checkNotNull((Object)pair5);
            root.add((SvgNode)pair5.getFirst());
            Pair pair6 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2 - halfFenceWidth, fence), new DoubleVector(x2 + halfFenceWidth, fence), p, null, 8, null);
            Intrinsics.checkNotNull((Object)pair6);
            root.add((SvgNode)pair6.getFirst());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom$Companion;", "", "()V", "DEF_FATTEN_MIDLINE", "", "DEF_WHISKER_WIDTH", "DEF_WIDTH_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "widthUnit", "isHintRect", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper, DimensionUnit widthUnit, boolean isHintRect) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(geomHelper, widthUnit, isHintRect, ctx2){
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ DimensionUnit $widthUnit;
                final /* synthetic */ boolean $isHintRect;
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$geomHelper = $geomHelper;
                    this.$widthUnit = $widthUnit;
                    this.$isHintRect = $isHintRect;
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;ZLorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom$Companion.access$clientRectByDataPoint$factory(this.$geomHelper, this.$widthUnit, this.$isHintRect, this.$ctx, p0);
                }
            };
        }

        private static final DoubleRectangle clientRectByDataPoint$factory(GeomHelper $geomHelper, DimensionUnit $widthUnit, boolean $isHintRect, GeomContext $ctx, DataPointAesthetics p) {
            DoubleRectangle doubleRectangle;
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                return null;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getLOWER());
            if (d2 == null) {
                return null;
            }
            double lower2 = d2;
            Double d3 = p.finiteOrNull(Aes.Companion.getUPPER());
            if (d3 == null) {
                return null;
            }
            double upper2 = d3;
            Double d4 = p.finiteOrNull(Aes.Companion.getWIDTH());
            if (d4 == null) {
                return null;
            }
            double w = d4;
            double width2 = w * $geomHelper.getUnitResolution($widthUnit, Aes.Companion.getX());
            DoubleRectangle rect2 = DoubleRectangle.Companion.XYWH(x2 - width2 / (double)2, lower2, width2, upper2 - lower2);
            DoubleRectangle doubleRectangle2 = $geomHelper.toClient(rect2, p);
            if (doubleRectangle2 != null) {
                DoubleRectangle it = doubleRectangle2;
                boolean bl = false;
                doubleRectangle = $isHintRect && upper2 == lower2 ? GeomUtil.INSTANCE.extendHeight$plot_base(it, 2.0, $ctx.getFlipped()) : it;
            } else {
                doubleRectangle = null;
            }
            return doubleRectangle;
        }

        public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(GeomHelper $geomHelper, DimensionUnit $widthUnit, boolean $isHintRect, GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom$Companion.clientRectByDataPoint$factory($geomHelper, $widthUnit, $isHintRect, $ctx, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

