/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.pty4j.util.PtyUtil;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtractedNative {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractedNative.class);
    static final String[] LOCATIONS = new String[]{"darwin/libpty.dylib", "darwin/pty4j-unix-spawn-helper", "freebsd/x86/libpty.so", "freebsd/x86-64/libpty.so", "linux/x86/libpty.so", "linux/x86-64/libpty.so", "linux/aarch64/libpty.so", "linux/arm/libpty.so", "linux/ppc64le/libpty.so", "linux/mips64el/libpty.so", "linux/riscv64/libpty.so", "win/aarch64/conpty.dll", "win/aarch64/OpenConsole.exe", "win/aarch64/win-helper.dll", "win/aarch64/winpty-agent.exe", "win/aarch64/winpty.dll", "win/x86/winpty-agent.exe", "win/x86/winpty.dll", "win/x86-64/conpty.dll", "win/x86-64/OpenConsole.exe", "win/x86-64/cyglaunch.exe", "win/x86-64/win-helper.dll", "win/x86-64/winpty-agent.exe", "win/x86-64/winpty.dll"};
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "resources/com/pty4j/native/";
    private static final Set<String> EXECUTABLE_PERMISSION = Set.of("darwin/pty4j-unix-spawn-helper");
    private static final ExtractedNative INSTANCE = new ExtractedNative();
    private String myResourceOsArchSubPath;
    private String myResourceNamePrefix;
    private boolean myInitialized;
    private volatile File myDestDir;

    private ExtractedNative() {
        this(null, null);
    }

    ExtractedNative(@Nullable String resourceOsArchSubPath, @Nullable String resourceNamePrefix) {
        this.myResourceOsArchSubPath = resourceOsArchSubPath;
        this.myResourceNamePrefix = resourceNamePrefix;
    }

    @NotNull
    public static ExtractedNative getInstance() {
        return INSTANCE;
    }

    @NotNull
    File getDestDir() {
        if (!this.myInitialized) {
            this.init();
        }
        return this.myDestDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            this.myResourceOsArchSubPath = Objects.requireNonNullElse(this.myResourceOsArchSubPath, PtyUtil.getNativeLibraryOsArchSubPath());
            this.myResourceNamePrefix = Objects.requireNonNullElse(this.myResourceNamePrefix, DEFAULT_RESOURCE_NAME_PREFIX);
            ExtractedNative extractedNative = this;
            synchronized (extractedNative) {
                if (!this.myInitialized) {
                    this.doInit();
                }
                this.myInitialized = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot extract pty4j native " + this.myResourceOsArchSubPath, e);
        }
    }

    private void doInit() throws IOException {
        List children;
        long startTimeNano = System.nanoTime();
        Path destDir = this.getOrCreateDestDir();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + destDir + " in " + ExtractedNative.pastTime(startTimeNano));
        }
        try (Stream<Path> stream = Files.list(destDir);){
            children = stream.collect(Collectors.toList());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listed files in " + ExtractedNative.pastTime(startTimeNano));
        }
        HashMap<String, Path> resourceToFileMap = new HashMap<String, Path>();
        for (Path child : children) {
            String resourceName = this.getResourceName(child.getFileName().toString());
            resourceToFileMap.put(resourceName, child);
        }
        Set<String> bundledResourceNames = this.getBundledResourceNames();
        boolean upToDate = this.isUpToDate(bundledResourceNames, resourceToFileMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checked upToDate in " + ExtractedNative.pastTime(startTimeNano));
        }
        if (!upToDate) {
            for (Path child : children) {
                Files.delete(child);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleared directory in " + ExtractedNative.pastTime(startTimeNano));
            }
            for (String bundledResourceName : bundledResourceNames) {
                this.copy(bundledResourceName, destDir);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copied " + bundledResourceNames + " in " + ExtractedNative.pastTime(startTimeNano));
            }
        }
        this.myDestDir = destDir.toFile();
        LOG.info("Extracted pty4j native in " + ExtractedNative.pastTime(startTimeNano));
    }

    @NotNull
    private Path getOrCreateDestDir() throws IOException {
        Path staticParentDir;
        String staticParentDirPath = System.getProperty("pty4j.tmpdir");
        String prefix = "pty4j-" + this.myResourceOsArchSubPath.replace('/', '-');
        if (staticParentDirPath != null && !staticParentDirPath.trim().isEmpty() && (staticParentDir = Paths.get(staticParentDirPath, new String[0])).isAbsolute()) {
            Path staticDir = staticParentDir.resolve(prefix);
            if (Files.isDirectory(staticDir, new LinkOption[0])) {
                return staticDir;
            }
            if (Files.isDirectory(staticParentDir, new LinkOption[0])) {
                if (Files.exists(staticDir, new LinkOption[0])) {
                    Files.delete(staticDir);
                }
                return Files.createDirectory(staticDir, new FileAttribute[0]);
            }
        }
        Path tempDirectory = Files.createTempDirectory(prefix + "-", new FileAttribute[0]);
        tempDirectory.toFile().deleteOnExit();
        return tempDirectory;
    }

    private boolean isUpToDate(@NotNull Set<String> bundledResourceNames, @NotNull Map<String, Path> resourceToFileMap) {
        if (!bundledResourceNames.equals(resourceToFileMap.keySet())) {
            return false;
        }
        for (Map.Entry<String, Path> entry : resourceToFileMap.entrySet()) {
            try {
                byte[] fileContentChecksum;
                URL bundledUrl = this.getBundledResourceUrl(entry.getKey());
                byte[] bundledContentChecksum = ExtractedNative.md5(bundledUrl.openStream());
                if (Arrays.equals(bundledContentChecksum, fileContentChecksum = ExtractedNative.md5(Files.newInputStream(entry.getValue(), new OpenOption[0])))) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error("Cannot compare md5 checksums", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] md5(@NotNull InputStream in) throws IOException, NoSuchAlgorithmException {
        try {
            int bufferSize;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((bufferSize = in.read(buffer)) >= 0) {
                md5.update(buffer, 0, bufferSize);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error("Cannot close", (Throwable)e);
            }
        }
    }

    @NotNull
    private Set<String> getBundledResourceNames() {
        HashSet<String> resourceNames = new HashSet<String>();
        String prefix = this.myResourceOsArchSubPath + "/";
        for (String location : LOCATIONS) {
            if (!location.startsWith(prefix)) continue;
            resourceNames.add(this.myResourceNamePrefix + location);
        }
        return resourceNames;
    }

    @NotNull
    private String getResourceName(@NotNull String fileName) {
        return this.myResourceNamePrefix + this.myResourceOsArchSubPath + "/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(@NotNull String resourceName, @NotNull Path destDir) throws IOException {
        URL url = this.getBundledResourceUrl(resourceName);
        int lastNameInd = resourceName.lastIndexOf(47);
        String name = lastNameInd != -1 ? resourceName.substring(lastNameInd + 1) : resourceName;
        try (InputStream inputStream = url.openStream();){
            Path destFile = destDir.resolve(name);
            Files.copy(inputStream, destFile, new CopyOption[0]);
            if (this.shouldBePosixExecutable(resourceName)) {
                Files.setPosixFilePermissions(destFile, Set.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ));
            }
        }
    }

    private boolean shouldBePosixExecutable(@NotNull String resourceName) {
        boolean unix;
        boolean bl = unix = Platform.isMac() || Platform.isLinux();
        if (unix && resourceName.startsWith(this.myResourceNamePrefix)) {
            String location = resourceName.substring(this.myResourceNamePrefix.length());
            return EXECUTABLE_PERMISSION.contains(location);
        }
        return false;
    }

    @NotNull
    private URL getBundledResourceUrl(@NotNull String resourceName) throws IOException {
        ClassLoader classLoader = ExtractedNative.class.getClassLoader();
        URL url = classLoader.getResource(resourceName);
        if (url == null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                url = contextClassLoader.getResource(resourceName);
            }
            if (url == null) {
                throw new IOException("Unable to load " + resourceName);
            }
        }
        return url;
    }

    @NotNull
    private static String pastTime(long startTimeNano) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNano) + " ms";
    }
}

