/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.actions;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u00122\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002RF\u0010\u0004\u001a:\u0012\u0012\u0012\u0010\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u001b\u0012\u0012\u0012\u0010\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/liveEdit/actions/UpdateRunningApplicationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "blackListedDebugProcesses", "", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "project", "Lcom/intellij/openapi/project/Project;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "doUpdate", "debugProcess", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nUpdateRunningApplicationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateRunningApplicationAction.kt\ncom/jetbrains/liveEdit/actions/UpdateRunningApplicationAction\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,77:1\n127#2:78\n*S KotlinDebug\n*F\n+ 1 UpdateRunningApplicationAction.kt\ncom/jetbrains/liveEdit/actions/UpdateRunningApplicationAction\n*L\n73#1:78\n*E\n"})
public final class UpdateRunningApplicationAction
extends AnAction {
    @NotNull
    private final Set<JavaScriptDebugProcess<?>> blackListedDebugProcesses;

    public UpdateRunningApplicationAction() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.blackListedDebugProcesses = set;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final XDebugProcess getDebugProcess(Project project) {
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return xDebugSession != null ? xDebugSession.getDebugProcess() : null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            String suffix = PlatformUtils.isWebStorm() ? "" : " " + LiveEditBundle.message("update.application.ws.suffix", new Object[0]);
            Object[] objectArray = new Object[]{suffix};
            presentation2.setText(LiveEditBundle.message("update.application", objectArray));
            presentation2.setEnabledAndVisible(!XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class).isEmpty());
        } else {
            for (UpdateConfigurationProvider provider : (UpdateConfigurationProvider[])UpdateConfigurationProvider.EP_NAME.getExtensions()) {
                if (!provider.isSupported(runProfile)) continue;
                Object[] objectArray = new Object[]{runProfile.getName()};
                presentation2.setText(LiveEditBundle.message("update.profile", objectArray));
                presentation2.setVisible(true);
                presentation2.setEnabled(this.getDebugProcess(project2) != null);
                return;
            }
            presentation2.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class)) {
                Intrinsics.checkNotNull((Object)debugProcess);
                this.doUpdate(debugProcess);
            }
        } else {
            XDebugProcess debugProcess = this.getDebugProcess(project2);
            if (debugProcess instanceof JavaScriptDebugProcess) {
                this.doUpdate((JavaScriptDebugProcess)debugProcess);
            }
        }
    }

    private final void doUpdate(JavaScriptDebugProcess<?> debugProcess) {
        if (this.blackListedDebugProcesses.contains(debugProcess)) {
            return;
        }
        Promise<?> promise = ApplicationInspector.getInstance().updateApplication(debugProcess);
        Intrinsics.checkNotNullExpressionValue(promise, (String)"updateApplication(...)");
        Promise<?> callback = promise;
        if (callback.getState() == Promise.State.PENDING) {
            this.blackListedDebugProcesses.add(debugProcess);
            Promise<?> $this$processedRun$iv = callback;
            boolean $i$f$processedRun = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$processedRun$iv.onProcessed(new Consumer(this, debugProcess){
                final /* synthetic */ UpdateRunningApplicationAction this$0;
                final /* synthetic */ JavaScriptDebugProcess $debugProcess$inlined;
                {
                    this.this$0 = updateRunningApplicationAction;
                    this.$debugProcess$inlined = javaScriptDebugProcess;
                }

                public final void accept(Object it) {
                    boolean bl = false;
                    UpdateRunningApplicationAction.access$getBlackListedDebugProcesses$p(this.this$0).remove(this.$debugProcess$inlined);
                }
            }), (String)"onProcessed(...)");
        }
    }

    public static final /* synthetic */ Set access$getBlackListedDebugProcesses$p(UpdateRunningApplicationAction $this) {
        return $this.blackListedDebugProcesses;
    }
}

