/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.liveEdit.PsiSynchronizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedSynchronizer
extends PsiSynchronizer {
    protected static final Logger LOG = Logger.getInstance(FileBasedSynchronizer.class);
    private final Set<PsiElement> elements = CollectionFactory.createSmallMemoryFootprintSet();
    private final Set<PsiElement> incorrectElements = ContainerUtil.createWeakSet();
    private Condition<List<PsiFile>> isPsiFileModifiedOrContainsError;

    @NotNull
    static List<Project> filesToProjects(@NotNull List<? extends PsiFile> files) {
        if (files == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(0);
        }
        SmartList projects = new SmartList();
        for (PsiFile psiFile : files) {
            Project project = psiFile.isValid() ? psiFile.getProject() : null;
            if (project == null || project.isDisposed() || projects.contains(project)) continue;
            projects.add(project);
        }
        SmartList smartList = projects;
        if (smartList == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CharSequence getFileTextIfValidAndRemoveRelatedPendingElements(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.containsErrors(psiFile)) {
                return null;
            }
            if (!this.elements.isEmpty()) {
                Iterator<PsiElement> iterator = this.elements.iterator();
                while (iterator.hasNext()) {
                    PsiElement element = iterator.next();
                    if (element.isValid() && element.getContainingFile() != psiFile) continue;
                    iterator.remove();
                }
            }
        }
        return FileBasedSynchronizer.getChars(psiFile);
    }

    @NotNull
    public static CharSequence getChars(@NotNull PsiFile psiFile) {
        String lineSeparator;
        FileViewProvider viewProvider;
        Document document;
        if (psiFile == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((document = (viewProvider = psiFile.getViewProvider()).getDocument()) != null);
        try {
            lineSeparator = FileDocumentManagerImpl.getLineSeparator((Document)document, (VirtualFile)viewProvider.getVirtualFile());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            lineSeparator = "\n";
        }
        CharSequence value = viewProvider.getContents();
        if (lineSeparator.equals("\n")) {
            CharSequence charSequence = value instanceof ImmutableCharSequence ? value : value.toString();
            if (charSequence == null) {
                FileBasedSynchronizer.$$$reportNull$$$0(4);
            }
            return charSequence;
        }
        CharSequence result = StringUtilRt.convertLineSeparators((CharSequence)value, (String)lineSeparator);
        CharSequence charSequence = result == value && !(value instanceof ImmutableCharSequence) ? result.toString() : result;
        if (charSequence == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @NotNull
    Condition<List<PsiFile>> getIsPsiFileModifiedOrContainsErrorCondition() {
        if (this.isPsiFileModifiedOrContainsError == null) {
            this.isPsiFileModifiedOrContainsError = files -> {
                Set<PsiElement> set = this.elements;
                synchronized (set) {
                    for (PsiFile file : files) {
                        if (!this.containsErrors(file)) continue;
                        return false;
                    }
                    Iterator<PsiElement> iterator = this.elements.iterator();
                    while (iterator.hasNext()) {
                        PsiElement element = iterator.next();
                        if (element.isValid() && !files.contains(element.getContainingFile())) continue;
                        iterator.remove();
                    }
                }
                return true;
            };
        }
        Condition<List<PsiFile>> condition = this.isPsiFileModifiedOrContainsError;
        if (condition == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(6);
        }
        return condition;
    }

    private boolean containsErrors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(7);
        }
        if (this.incorrectElements.isEmpty()) {
            return false;
        }
        Iterator<PsiElement> iterator = this.incorrectElements.iterator();
        while (iterator.hasNext()) {
            PsiElement element = iterator.next();
            if (!element.isValid() || !PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                iterator.remove();
                continue;
            }
            if (element.getContainingFile() != psiFile) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<VirtualFile> getIncorrectFiles() {
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.incorrectElements.isEmpty()) {
                List<VirtualFile> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list == null) {
                    FileBasedSynchronizer.$$$reportNull$$$0(8);
                }
                return list;
            }
        }
        List list = (List)ReadAction.compute(() -> {
            List files = null;
            Set<PsiElement> set = this.elements;
            synchronized (set) {
                Iterator<PsiElement> iterator = this.incorrectElements.iterator();
                while (iterator.hasNext()) {
                    PsiElement element = iterator.next();
                    if (!element.isValid() || !PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                        iterator.remove();
                        continue;
                    }
                    VirtualFile file = element.getContainingFile().getVirtualFile();
                    if (files == null) {
                        files = new SmartList();
                    } else if (files.contains(file)) continue;
                    files.add(file);
                }
            }
            return files == null ? Collections.emptyList() : files;
        });
        if (list == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean scheduleFile(@NotNull PsiFile file) {
        if (file == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(10);
        }
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.containsErrors(file)) {
                return false;
            }
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)file)) {
            set = this.elements;
            synchronized (set) {
                this.incorrectElements.add((PsiElement)file);
            }
            return false;
        }
        set = this.elements;
        synchronized (set) {
            this.elements.add((PsiElement)file);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean schedule(int changeType, @NotNull PsiElement child, @NotNull PsiElement parent, @NotNull PsiFile file) {
        PsiElement affectedElement;
        if (child == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(12);
        }
        if (file == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = affectedElement = changeType == 3 ? child : parent;
        if (!(affectedElement instanceof PsiFile) && PsiTreeUtil.hasErrorElements((PsiElement)affectedElement)) {
            Set<PsiElement> set = this.elements;
            synchronized (set) {
                this.elements.remove(affectedElement);
                this.incorrectElements.add(affectedElement);
            }
            return false;
        }
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            this.incorrectElements.remove(affectedElement);
            this.elements.add(affectedElement);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Supplier<Set<PsiElement>> flushSyncTask() {
        PsiElement[] psiElements;
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.elements.isEmpty()) {
                return null;
            }
            psiElements = this.elements.toArray(PsiElement.EMPTY_ARRAY);
            this.elements.clear();
        }
        return () -> {
            List files = (List)ReadAction.compute(() -> FileBasedSynchronizer.getPsiFiles(psiElements));
            if (files != null) {
                this.sync(files);
            }
            return files != null ? new HashSet(files) : Collections.emptySet();
        };
    }

    protected abstract void sync(@NotNull List<PsiFile> var1);

    @Nullable
    private static List<PsiFile> getPsiFiles(PsiElement @NotNull [] elements) {
        if (elements == null) {
            FileBasedSynchronizer.$$$reportNull$$$0(14);
        }
        List files = null;
        List blackListedFiles = null;
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            PsiFile psiFile = element.getContainingFile();
            if (PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                if (files != null) {
                    files.remove(psiFile);
                }
                if (blackListedFiles == null) {
                    blackListedFiles = new SmartList();
                }
                blackListedFiles.add(psiFile);
                continue;
            }
            if (blackListedFiles != null && blackListedFiles.contains(psiFile)) continue;
            if (files == null) {
                files = new SmartList((Object)psiFile);
                continue;
            }
            if (files.contains(psiFile)) continue;
            files.add(psiFile);
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/FileBasedSynchronizer";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/FileBasedSynchronizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToProjects";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsPsiFileModifiedOrContainsErrorCondition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncorrectFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filesToProjects";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTextIfValidAndRemoveRelatedPendingElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsErrors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

