/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.ExternalCompilerBean;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.PageReloader;
import com.jetbrains.liveEdit.UpdatePolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExternalCompilerBackedFileBasedSynchronizer
extends FileBasedSynchronizer {
    private static final ExtensionPointName<Processor<List<VirtualFile>>> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.compilerInvoker");
    private Alarm refreshAlarm;

    @Override
    public boolean canHandle(@NotNull FileType fileType, @NotNull Project project) {
        if (fileType == null) {
            ExternalCompilerBackedFileBasedSynchronizer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalCompilerBackedFileBasedSynchronizer.$$$reportNull$$$0(1);
        }
        return ExternalCompilerBackedFileBasedSynchronizer.doCanHandle(fileType, project);
    }

    private static boolean doCanHandle(@NotNull FileType fileType, @NotNull Project project) {
        if (fileType == null) {
            ExternalCompilerBackedFileBasedSynchronizer.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ExternalCompilerBackedFileBasedSynchronizer.$$$reportNull$$$0(3);
        }
        if (!LiveEditOptions.getInstance().isUpdateFilesToCompile()) {
            return false;
        }
        ExternalCompilerBean bean = ExternalCompilerBean.get(fileType);
        if (bean == null) {
            return false;
        }
        return LiveEditManager.getActiveConfigurations(project).anyMatch(updateConfiguration -> updateConfiguration.getPolicy() == UpdatePolicy.AUTO && (bean.generatesJS ? updateConfiguration.includeJSInAutoUpdate() : updateConfiguration.includeHtmlInAutoUpdate()));
    }

    @Override
    protected void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            ExternalCompilerBackedFileBasedSynchronizer.$$$reportNull$$$0(4);
        }
        boolean hasInterpreters = false;
        List filesToCompile = null;
        for (PsiFile file : files) {
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            ExternalCompilerBean externalCompiler = ExternalCompilerBean.get(virtualFile.getFileType());
            if (externalCompiler == null) continue;
            if (externalCompiler.interpreter) {
                hasInterpreters = true;
                break;
            }
            if (filesToCompile == null) {
                filesToCompile = new SmartList();
            }
            filesToCompile.add(virtualFile);
        }
        List<Project> projects = ExternalCompilerBackedFileBasedSynchronizer.filesToProjects(files);
        boolean finalHasInterpreters = hasInterpreters;
        List finalFilesToCompile = filesToCompile;
        PageReloader.save(files, this.getIsPsiFileModifiedOrContainsErrorCondition(), () -> {
            if (finalHasInterpreters) {
                for (Project project : projects) {
                    ApplicationInspector.getInstance().reloadPages(project);
                }
            }
            if (finalFilesToCompile != null) {
                for (Processor compilerInvoker : (Processor[])EP_NAME.getExtensions()) {
                    if (!compilerInvoker.process((Object)finalFilesToCompile)) continue;
                    return;
                }
                if (this.refreshAlarm == null) {
                    this.refreshAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
                }
                this.refreshAlarm.cancelAllRequests();
                this.refreshAlarm.addRequest(ExternalCompilerBackedFileBasedSynchronizer.createRefreshTask(projects), 1000);
            }
        });
    }

    private static Runnable createRefreshTask(List<Project> projects) {
        return () -> {
            for (Project project : projects) {
                if (project.isDisposed()) continue;
                VirtualFile baseDir = project.getBaseDir();
                assert (baseDir != null);
                baseDir.refresh(false, true);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doCanHandle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FileWatcherIsCustom
    implements PairProcessor<VirtualFile, Project> {
        FileWatcherIsCustom() {
        }

        public boolean process(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                FileWatcherIsCustom.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FileWatcherIsCustom.$$$reportNull$$$0(1);
            }
            return LiveEditManager.getInstance().isOperable() && ExternalCompilerBackedFileBasedSynchronizer.doCanHandle(file.getFileType(), project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer$FileWatcherIsCustom";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

