/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl.cassandra;

public final class CassParseUtils {
    public static boolean isDoubleQuoted(String value) {
        return CassParseUtils.isQuoted(value, '\"');
    }

    private static boolean isQuoted(String value, char quoteChar) {
        return value != null && value.length() > 1 && value.charAt(0) == quoteChar && value.charAt(value.length() - 1) == quoteChar;
    }

    public static String doubleQuote(String value) {
        return CassParseUtils.quote(value, '\"');
    }

    public static String quote(String value) {
        return CassParseUtils.quote(value, '\'');
    }

    private static String quote(String text, char quoteChar) {
        if (text != null && !text.isEmpty()) {
            int nbMatch = 0;
            int start = -1;
            do {
                if ((start = text.indexOf(quoteChar, start + 1)) == -1) continue;
                ++nbMatch;
            } while (start != -1);
            if (nbMatch == 0) {
                return quoteChar + text + quoteChar;
            }
            int newLength = 2 + text.length() + nbMatch;
            char[] result = new char[newLength];
            result[0] = quoteChar;
            result[newLength - 1] = quoteChar;
            int newIdx = 1;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                result[newIdx++] = c;
                if (c != quoteChar) continue;
                result[newIdx++] = c;
            }
            return new String(result);
        }
        return CassParseUtils.emptyQuoted(quoteChar);
    }

    private static String emptyQuoted(char quoteChar) {
        assert (quoteChar == '\"' || quoteChar == '\'');
        return quoteChar == '\"' ? "\"\"" : "''";
    }
}

