/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.dynamo.RemoteDynamoConnectionImpl;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamoJdbcHelper
extends JdbcHelperImpl {
    public static final String NULL_TYPE = "NULL";
    public static final String NUMBER_TYPE = "N";
    public static final String STRING_TYPE = "S";
    public static final String BINARY_TYPE = "B";
    public static final String BOOLEAN_TYPE = "BOOL";
    public static final String LIST_TYPE = "L";
    public static final String MAP_TYPE = "M";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final Map<String, Integer> TYPES_MAP = new HashMap<String, Integer>();

    public DynamoJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("DYNAMO", version, connection, jdbcClassLoader);
    }

    public DynamoJdbcHelper() {
        this(null, null, null);
    }

    private DynamoJdbcHelper(@NotNull DynamoJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            DynamoJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            DynamoJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    public RemoteConnection wrap(Connection connection) {
        return new RemoteDynamoConnectionImpl(connection, (JdbcHelperImpl)this);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return DynamoJdbcHelper.extractVersion(version);
    }

    @Nullable
    private static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new DynamoJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "DYNAMO")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return this.create(DynamoJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @NotNull
    public static String getTypeName(@Nullable Object o) {
        if (o instanceof Number) {
            return NUMBER_TYPE;
        }
        if (o instanceof String) {
            return STRING_TYPE;
        }
        if (o instanceof byte[]) {
            return BINARY_TYPE;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_TYPE;
        }
        if (o instanceof List) {
            return LIST_TYPE;
        }
        if (o instanceof Map) {
            return MAP_TYPE;
        }
        if (o == null || o.getClass().getSimpleName().equals("ReservedCellValue")) {
            return NULL_TYPE;
        }
        return UNKNOWN_TYPE;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            DynamoJdbcHelper.$$$reportNull$$$0(2);
        }
        return new DynamoJdbcHelper(this, jdbcClassLoader);
    }

    static {
        TYPES_MAP.put(NULL_TYPE, 0);
        TYPES_MAP.put(NUMBER_TYPE, 3);
        TYPES_MAP.put(STRING_TYPE, 12);
        TYPES_MAP.put(BINARY_TYPE, -2);
        TYPES_MAP.put(BOOLEAN_TYPE, 12);
        TYPES_MAP.put(LIST_TYPE, 2000);
        TYPES_MAP.put(MAP_TYPE, 2000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/DynamoJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

