/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.sql.TextFileFragment;
import com.intellij.database.remote.jdba.util.Collects;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ScriptumResource {
    protected TextFileFragment[] myFragments = null;
    protected Map<String, TextFileFragment> myFragmentsMap = null;

    ScriptumResource() {
    }

    @NotNull
    protected abstract TextFileFragment[] loadFragments();

    protected void loadIfNeeded() {
        if (this.myFragments == null) {
            this.myFragments = this.loadFragments();
            this.myFragmentsMap = new TreeMap<String, TextFileFragment>(String.CASE_INSENSITIVE_ORDER);
            for (TextFileFragment fragment : this.myFragments) {
                if (fragment.getFragmentName() == null) continue;
                this.myFragmentsMap.put(fragment.getFragmentName(), fragment);
            }
        }
    }

    @NotNull
    TextFileFragment get(@NotNull String name) {
        TextFileFragment fragment;
        if (name == null) {
            ScriptumResource.$$$reportNull$$$0(0);
        }
        if ((fragment = this.find(name)) == null) {
            if (this.myFragmentsMap == null) {
                throw new IllegalStateException("The scriptum resource is not loaded yet.");
            }
            String msg = "No such fragment with name: " + name + '\n' + Collects.collectionToString(this.myFragmentsMap.keySet(), ", ", "There are fragments: ", ".", "This resource is empty");
            throw new IllegalArgumentException(msg);
        }
        TextFileFragment textFileFragment = fragment;
        if (textFileFragment == null) {
            ScriptumResource.$$$reportNull$$$0(1);
        }
        return textFileFragment;
    }

    @Nullable
    TextFileFragment find(@NotNull String name) {
        if (name == null) {
            ScriptumResource.$$$reportNull$$$0(2);
        }
        this.loadIfNeeded();
        return this.myFragmentsMap.get(name);
    }

    @NotNull
    String[] getExistentNames() {
        this.loadIfNeeded();
        int n = this.myFragments.length;
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            names[i] = this.myFragments[i].getFragmentName();
        }
        if (names == null) {
            ScriptumResource.$$$reportNull$$$0(3);
        }
        return names;
    }

    int count() {
        this.loadIfNeeded();
        return this.myFragments.length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/ScriptumResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/ScriptumResource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistentNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

