/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTableModel
extends AbstractTableModel {
    public static final int LIB_ENABLED_COL = 0;
    public static final int LIB_NAME_COL = 1;
    public static final int LIB_TYPE_COL = 2;
    private final ScriptingLibraryManager myLibraryManager;
    private LibraryScope[] myLibraries;
    private final ScriptingLibraryMappings myMappings;
    private boolean myIsChanged;

    public ScriptingLibraryTableModel(ScriptingLibraryManager libManager, ScriptingLibraryMappings mappings) {
        this.myLibraryManager = libManager;
        this.myMappings = mappings;
        this.myIsChanged = false;
        this.myLibraries = this.getLibrariesScopes();
    }

    public void resetTable() {
        this.myMappings.reset();
        this.myLibraries = this.getLibrariesScopes();
        this.myIsChanged = false;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.myLibraries.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LibraryScope libraryScope = this.myLibraries[rowIndex];
        assert (libraryScope != null);
        return switch (columnIndex) {
            case 0 -> libraryScope.myState;
            case 1 -> libraryScope.myLibrary.getName();
            case 2 -> ScriptingLibraryTableModel.getLibraryLevelName(libraryScope.myLibrary.getLibraryLevel());
            default -> "?";
        };
    }

    public static String getLibraryLevelName(@NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        if (libraryLevel == null) {
            ScriptingLibraryTableModel.Y(0);
        }
        return WebCoreBundle.message((String)(switch (libraryLevel) {
            default -> throw new IncompatibleClassChangeError();
            case ScriptingLibraryModel.LibraryLevel.PREDEFINED -> "library.level.predefined.name";
            case ScriptingLibraryModel.LibraryLevel.GLOBAL -> "library.level.global.name";
            case ScriptingLibraryModel.LibraryLevel.PROJECT -> "library.level.project.name";
        }), (Object[])new Object[0]);
    }

    @NotNull
    public static String getLongestLibraryLevelName() {
        String string = "";
        for (ScriptingLibraryModel.LibraryLevel libraryLevel : ScriptingLibraryModel.LibraryLevel.values()) {
            String string2 = ScriptingLibraryTableModel.getLibraryLevelName(libraryLevel);
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        String string3 = string;
        if (string3 == null) {
            ScriptingLibraryTableModel.Y(1);
        }
        return string3;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myIsChanged = true;
        if (columnIndex == 0 && aValue instanceof Boolean) {
            LibraryScope libraryScope = this.myLibraries[rowIndex];
            libraryScope.myState = Boolean.TRUE.equals(aValue) ? EnabledState.ON : EnabledState.OFF;
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return WebCoreBundle.message((String)(switch (column) {
            case 0 -> "library.table.enabled.column.name";
            case 1 -> "library.table.name.column.name";
            case 2 -> "library.table.type.column.name";
            default -> throw new IllegalStateException("Unknown column: " + column);
        }), (Object[])new Object[0]);
    }

    public void applyChanges() {
        Set set = this.myMappings.getMappings().keySet();
        for (LibraryScope libraryScope : this.myLibraries) {
            String string = libraryScope.myLibrary.getName();
            if (libraryScope.myState == EnabledState.ON && !this.myMappings.isAssociatedWithProject(string)) {
                this.myMappings.associate(null, string, libraryScope.myLibrary.isPredefined());
                continue;
            }
            if (libraryScope.myState != EnabledState.OFF) continue;
            this.myMappings.disassociate(null, string);
            for (VirtualFile virtualFile : set) {
                if (!this.myMappings.isAssociatedWith(virtualFile, string)) continue;
                this.myMappings.disassociate(virtualFile, string);
            }
        }
    }

    public void applyMappings() {
        Map map = this.myMappings.getMappings();
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)object;
            object = ContainerUtil.map((Collection)compoundLibrary.getLibraries(), scriptingLibraryModel -> scriptingLibraryModel.getName());
            for (LibraryScope libraryScope : this.myLibraries) {
                if (libraryScope.myState == EnabledState.OFF && object.contains(libraryScope.myLibrary.getName())) {
                    compoundLibrary.toggleLibrary(libraryScope.myLibrary);
                    continue;
                }
                if (libraryScope.myState != EnabledState.ON || entry.getKey() != null || object.contains(libraryScope.myLibrary.getName())) continue;
                compoundLibrary.toggleLibrary(libraryScope.myLibrary);
            }
        }
    }

    public ScriptingLibraryModel createLibrary(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel level, boolean isOnByDefault) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.myLibraryManager.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
            this.fireLibTableChanged(true);
            for (int i2 = 0; i2 < this.myLibraries.length; ++i2) {
                LibraryScope libraryScope = this.myLibraries[i2];
                if (libraryScope.myLibrary != scriptingLibraryModel) continue;
                this.setValueAt(Boolean.TRUE, i2, 0);
                break;
            }
            return scriptingLibraryModel;
        });
    }

    @Nullable
    public ScriptingLibraryModel getLibrary(String name) {
        ScriptingLibraryTable scriptingLibraryTable = this.myLibraryManager.getScriptingLibraryTable();
        return scriptingLibraryTable.getLibraryByName(name);
    }

    public int getLibraryIndex(String name) {
        int n2 = 0;
        for (LibraryScope libraryScope : this.myLibraries) {
            if (libraryScope.myLibrary.getName().equals(name)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeLibrary(String name) {
        ScriptingLibraryModel scriptingLibraryModel = this.getLibrary(name);
        if (scriptingLibraryModel != null) {
            this.myLibraryManager.removeLibrary(scriptingLibraryModel);
            this.fireLibTableChanged(true);
        }
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String oldName, String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.myLibraryManager.updateLibrary(oldName, name, sourceFiles, compactFiles, docUrls);
            this.myIsChanged = true;
            this.fireTableDataChanged();
            return scriptingLibraryModel;
        });
    }

    public void fireLibTableChanged(boolean keepMappings) {
        this.myIsChanged = true;
        LibraryScope[] libraryScopeArray = this.getLibrariesScopes();
        if (keepMappings) {
            for (LibraryScope libraryScope : libraryScopeArray) {
                for (LibraryScope libraryScope2 : this.myLibraries) {
                    if (!libraryScope2.myLibrary.getName().equals(libraryScope.myLibrary.getName())) continue;
                    libraryScope.myState = libraryScope2.myState;
                }
            }
        }
        this.myLibraries = libraryScopeArray;
        this.fireTableDataChanged();
    }

    @Nullable
    public String getLibNameAt(int row) {
        ScriptingLibraryModel scriptingLibraryModel = this.myLibraries[row].myLibrary;
        return scriptingLibraryModel != null ? scriptingLibraryModel.getName() : null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryAt(int row) {
        return this.myLibraries[row].myLibrary;
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private static ScriptingLibraryModel[] Y(ScriptingLibraryTable scriptingLibraryTable) {
        ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel scriptingLibraryModel3 : scriptingLibraryTable.getAllLibraries()) {
            if (scriptingLibraryModel3 == null) continue;
            arrayList.add(scriptingLibraryModel3);
        }
        arrayList.sort((scriptingLibraryModel, scriptingLibraryModel2) -> {
            if (scriptingLibraryModel.isPredefined() != scriptingLibraryModel2.isPredefined()) {
                return (scriptingLibraryModel.isPredefined() ? 1 : 0) - (scriptingLibraryModel2.isPredefined() ? 1 : 0);
            }
            return scriptingLibraryModel.getName().compareToIgnoreCase(scriptingLibraryModel2.getName());
        });
        return arrayList.toArray(ScriptingLibraryModel.EMPTY_ARRAY);
    }

    public LibraryScope[] getLibrariesScopes() {
        Object object;
        Object object2;
        Map map = this.myMappings.getMappings();
        HashMap<String, HashSet<VirtualFile>> hashMap = new HashMap<String, HashSet<VirtualFile>>();
        for (Map.Entry libraryScopeArray2 : map.entrySet()) {
            VirtualFile i2 = (VirtualFile)libraryScopeArray2.getKey();
            object2 = (ScriptingLibraryModel)libraryScopeArray2.getValue();
            if (!(object2 instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            object = (ScriptingLibraryMappings.CompoundLibrary)object2;
            Collection collection = object.getLibraries();
            VirtualFile virtualFile = collection.iterator();
            while (virtualFile.hasNext()) {
                ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)virtualFile.next();
                HashSet<VirtualFile> hashSet = (HashSet<VirtualFile>)hashMap.get(scriptingLibraryModel.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<VirtualFile>();
                    hashMap.put(scriptingLibraryModel.getName(), hashSet);
                }
                hashSet.add(i2);
            }
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryTableModel.Y(this.myLibraryManager.getScriptingLibraryTable());
        LibraryScope[] libraryScopeArray = new LibraryScope[scriptingLibraryModelArray.length];
        for (int i2 = 0; i2 < scriptingLibraryModelArray.length; ++i2) {
            object2 = EnabledState.OFF;
            object = scriptingLibraryModelArray[i2].getName();
            if (hashMap.containsKey(object)) {
                if (this.myMappings.isAssociatedWithProject((String)object)) {
                    object2 = EnabledState.ON;
                } else {
                    for (VirtualFile virtualFile : (Set)hashMap.get(object)) {
                        if (virtualFile == null) continue;
                        object2 = EnabledState.PARTLY;
                        break;
                    }
                }
            }
            libraryScopeArray[i2] = new LibraryScope(scriptingLibraryModelArray[i2], (EnabledState)((Object)object2));
        }
        return libraryScopeArray;
    }

    private static /* synthetic */ void Y(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryLevel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ScriptingLibraryTableModel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibraryTableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongestLibraryLevelName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryLevelName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class LibraryScope {
        public ScriptingLibraryModel myLibrary;
        public EnabledState myState;

        private LibraryScope(ScriptingLibraryModel library, EnabledState state) {
            this.myLibrary = library;
            this.myState = state;
        }
    }

    public static final class EnabledState
    extends Enum<EnabledState> {
        public static final /* enum */ EnabledState ON = new EnabledState();
        public static final /* enum */ EnabledState PARTLY = new EnabledState();
        public static final /* enum */ EnabledState OFF = new EnabledState();
        private static final /* synthetic */ EnabledState[] $VALUES;

        public static EnabledState[] values() {
            return (EnabledState[])$VALUES.clone();
        }

        public static EnabledState valueOf(String name) {
            return Enum.valueOf(EnabledState.class, name);
        }

        private static /* synthetic */ EnabledState[] Y() {
            return new EnabledState[]{ON, PARTLY, OFF};
        }

        static {
            $VALUES = EnabledState.Y();
        }
    }
}

