/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/DebuggableFileFinderImpl;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "Lcom/intellij/util/Url;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/Url;)V", "scheme", "", "authority", "getAuthority$intellij_javascript_debugger", "()Ljava/lang/String;", "fileUrlMappers", "", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "getFileUrlMappers", "()[Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "lazyFileUrlMappers", "Lkotlin/Lazy;", "computeFileUrlMappers", "isDebuggable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findRemoteUrlByExtensionMappers", "", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "url", "findFile", "findFileByAuthority", "getRemoteUrls", "toString", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nDebuggableFileFinderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggableFileFinderImpl.kt\ncom/intellij/javascript/debugger/DebuggableFileFinderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public class DebuggableFileFinderImpl
implements DebuggableFileFinder {
    @NotNull
    private final Project project;
    @Nullable
    private final Url requestor;
    @Nullable
    private final String scheme;
    @Nullable
    private final String authority;
    @NotNull
    private final Lazy<FileUrlMapper[]> lazyFileUrlMappers;

    public DebuggableFileFinderImpl(@NotNull Project project, @Nullable Url requestor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.requestor = requestor;
        this.lazyFileUrlMappers = LazyKt.lazy(() -> DebuggableFileFinderImpl.lazyFileUrlMappers$lambda$0(this));
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            this.authority = null;
            this.scheme = null;
        } else if (this.requestor == null) {
            this.authority = null;
            this.scheme = null;
        } else {
            this.authority = this.requestor.getAuthority();
            this.scheme = this.requestor.getScheme();
        }
    }

    @Nullable
    public final String getAuthority$intellij_javascript_debugger() {
        return this.authority;
    }

    private final FileUrlMapper[] getFileUrlMappers() {
        return (FileUrlMapper[])this.lazyFileUrlMappers.getValue();
    }

    @Nullable
    protected FileUrlMapper[] computeFileUrlMappers() {
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            return null;
        }
        FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
        return extensions.length == 0 ? null : extensions;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.authority == null || WebServerPathToFileManager.Companion.getInstance(project).getPath(file) != null || !((Collection)this.findRemoteUrlByExtensionMappers(file)).isEmpty();
    }

    private final List<Url> findRemoteUrlByExtensionMappers(VirtualFile file) {
        List list;
        List result = null;
        if (this.getFileUrlMappers() != null) {
            FileUrlMapper[] fileUrlMapperArray = this.getFileUrlMappers();
            Intrinsics.checkNotNull((Object)fileUrlMapperArray);
            for (FileUrlMapper mapper : fileUrlMapperArray) {
                List<Url> urls = mapper.getUrls(file, this.project, this.authority);
                if (!(!((Collection)urls).isEmpty())) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.addAll((Collection)urls);
            }
        }
        if ((list = result) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        FileUrlMapper[] fileUrlMapperArray;
        block7: {
            block6: {
                Object v1;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        return (Navigatable)JsFileUtil.createNavigatable(project, LocalFileFinder.findFile((String)url.getPath()));
                    }
                    fileUrlMapperArray = this.getFileUrlMappers();
                    if (fileUrlMapperArray == null || (fileUrlMapperArray = ArraysKt.asSequence((Object[])fileUrlMapperArray)) == null || (fileUrlMapperArray = SequencesKt.map((Sequence)fileUrlMapperArray, arg_0 -> DebuggableFileFinderImpl.findNavigatable$lambda$1(url, project, this, arg_0))) == null) break block6;
                    FileUrlMapper[] fileUrlMapperArray2 = fileUrlMapperArray;
                    for (Object e : fileUrlMapperArray2) {
                        Navigatable it = (Navigatable)e;
                        boolean bl = false;
                        if (!(it != null)) continue;
                        v1 = e;
                        break block5;
                    }
                    v1 = null;
                }
                if ((fileUrlMapperArray = (Navigatable)v1) != null) break block7;
            }
            fileUrlMapperArray = (Navigatable)JsFileUtil.createNavigatable(project, this.findFileByAuthority(url, project));
        }
        return fileUrlMapperArray;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        FileUrlMapper[] fileUrlMapperArray;
        block9: {
            block8: {
                Object v4;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        String string = url.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String path = string;
                        if (LocalFileFinder.windowsDriveExists((String)path)) {
                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
                            LocalFileSystem localFileSystem2 = localFileSystem;
                            VirtualFile virtualFile = localFileSystem2.findFileByPath(path);
                            if (virtualFile == null) {
                                virtualFile = localFileSystem2.refreshAndFindFileByPath(path);
                            }
                            return virtualFile;
                        }
                        return null;
                    }
                    fileUrlMapperArray = this.getFileUrlMappers();
                    if (fileUrlMapperArray == null || (fileUrlMapperArray = ArraysKt.asSequence((Object[])fileUrlMapperArray)) == null || (fileUrlMapperArray = SequencesKt.map((Sequence)fileUrlMapperArray, arg_0 -> DebuggableFileFinderImpl.findFile$lambda$3(url, project, this, arg_0))) == null) break block8;
                    FileUrlMapper[] fileUrlMapperArray2 = fileUrlMapperArray;
                    for (Object e : fileUrlMapperArray2) {
                        VirtualFile it = (VirtualFile)e;
                        boolean bl = false;
                        if (!(it != null)) continue;
                        v4 = e;
                        break block7;
                    }
                    v4 = null;
                }
                if ((fileUrlMapperArray = (VirtualFile)v4) != null) break block9;
            }
            fileUrlMapperArray = this.findFileByAuthority(url, project);
        }
        return fileUrlMapperArray;
    }

    private final VirtualFile findFileByAuthority(Url url, Project project) {
        VirtualFile virtualFile;
        if (this.authority != null && StringsKt.equals((String)this.authority, (String)url.getAuthority(), (boolean)true)) {
            VirtualFile virtualFile2;
            try {
                WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
                String string = url.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                virtualFile2 = WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, null, (int)6, null);
            }
            catch (InvalidPathException e) {
                JavaScriptDebugProcessKt.getLOG().warn((Throwable)e);
                virtualFile2 = null;
            }
            virtualFile = virtualFile2;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<Url> urls = this.findRemoteUrlByExtensionMappers(file);
        if (!((Collection)urls).isEmpty()) {
            return urls;
        }
        if (file instanceof VmScriptFile) {
            return CollectionsKt.listOf((Object)((VmScriptFile)file).getScript().getUrl());
        }
        return CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
    }

    @NotNull
    public String toString() {
        return "DefaultFileFinder";
    }

    private static final FileUrlMapper[] lazyFileUrlMappers$lambda$0(DebuggableFileFinderImpl this$0) {
        return this$0.computeFileUrlMappers();
    }

    private static final Navigatable findNavigatable$lambda$1(Url $url, Project $project, DebuggableFileFinderImpl this$0, FileUrlMapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNavigatable($url, $project, this$0.requestor);
    }

    private static final VirtualFile findFile$lambda$3(Url $url, Project $project, DebuggableFileFinderImpl this$0, FileUrlMapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile($url, $project, this$0.requestor);
    }
}

