/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptParameterTypesProvider;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class JavaScriptStepDefinition
extends AbstractStepDefinition {
    private final String stepText;

    public JavaScriptStepDefinition(@NotNull PsiElement element, String stepText) {
        if (element == null) {
            JavaScriptStepDefinition.$$$reportNull$$$0(0);
        }
        super(element);
        this.stepText = stepText;
    }

    public List<String> getVariableNames() {
        return Collections.emptyList();
    }

    @Nullable
    public String getCucumberRegex() {
        if (this.stepText == null) {
            return null;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        CucumberJavaScriptParameterTypesProvider parameterTypesProvider = CucumberJavaScriptParameterTypesProvider.getInstance(element.getProject());
        return this.buildRegex(parameterTypesProvider.getParameterTypeManager());
    }

    @Nullable
    private String buildRegex(@NotNull MapParameterTypeManager parameterTypes) {
        String step;
        if (parameterTypes == null) {
            JavaScriptStepDefinition.$$$reportNull$$$0(1);
        }
        if ((step = CucumberJavaScriptUtil.getContentFromLiteralText(this.stepText)) == null) {
            return null;
        }
        if (CucumberJavaScriptUtil.isRegexpString(this.stepText)) {
            return step;
        }
        return CucumberUtil.buildRegexpFromCucumberExpression((String)step, (ParameterTypeManager)parameterTypes);
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        return this.buildRegex(CucumberJavaScriptParameterTypesProvider.getDefaultParameterTypeManager());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/JavaScriptStepDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildRegex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

