/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;

@Service(value={Service.Level.PROJECT})
public final class CucumberJavaScriptParameterTypesProvider {
    @NotNull
    private final CachedValue<MapParameterTypeManager> myParameterTypeManager;

    public CucumberJavaScriptParameterTypesProvider(@NotNull Project project) {
        if (project == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(0);
        }
        this.myParameterTypeManager = CachedValuesManager.getManager((Project)project).createCachedValue(() -> (CachedValueProvider.Result)ReadAction.compute(() -> {
            ArrayList<Object> dependencies = new ArrayList<Object>();
            dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                dependencies.add(dumbService.getModificationTracker());
            }
            return CachedValueProvider.Result.create((Object)CucumberJavaScriptParameterTypesProvider.doGetParameterTypeManager(project), dependencies);
        }));
    }

    @NotNull
    public static CucumberJavaScriptParameterTypesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(1);
        }
        CucumberJavaScriptParameterTypesProvider cucumberJavaScriptParameterTypesProvider = (CucumberJavaScriptParameterTypesProvider)project.getService(CucumberJavaScriptParameterTypesProvider.class);
        if (cucumberJavaScriptParameterTypesProvider == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(2);
        }
        return cucumberJavaScriptParameterTypesProvider;
    }

    @NotNull
    public static MapParameterTypeManager getDefaultParameterTypeManager() {
        MapParameterTypeManager mapParameterTypeManager = MapParameterTypeManager.DEFAULT;
        if (mapParameterTypeManager == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(3);
        }
        return mapParameterTypeManager;
    }

    @NotNull
    public MapParameterTypeManager getParameterTypeManager() {
        MapParameterTypeManager mapParameterTypeManager = (MapParameterTypeManager)this.myParameterTypeManager.getValue();
        if (mapParameterTypeManager == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(4);
        }
        return mapParameterTypeManager;
    }

    @NotNull
    private static MapParameterTypeManager doGetParameterTypeManager(@NotNull Project project) {
        if (project == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(5);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, SmartPsiElementPointer<PsiElement>> declarations = new HashMap<String, SmartPsiElementPointer<PsiElement>>();
        CucumberJavaScriptParameterTypesProvider.fillParameterTypesFromTypeRegistry(project, values, declarations);
        values.putAll(CucumberUtil.STANDARD_PARAMETER_TYPES);
        return new MapParameterTypeManager(values, declarations);
    }

    private static void fillParameterTypesFromTypeRegistry(@NotNull Project project, @NotNull Map<String, String> values, @NotNull Map<String, SmartPsiElementPointer<PsiElement>> declarations) {
        if (project == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(6);
        }
        if (values == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(7);
        }
        if (declarations == null) {
            CucumberJavaScriptParameterTypesProvider.$$$reportNull$$$0(8);
        }
        Collection parameters = JSClassResolver.getInstance().findElementsByNameIncludingImplicit("$cucumberJSCustomParameters", ProjectScope.getAllScope((Project)project));
        for (JSPsiElementBase parameter : parameters) {
            JSLiteralExpression regexpExpression;
            JSPropertyImpl regexpProp;
            JSObjectLiteralExpression objectLiteralExpression;
            JSCallExpressionImpl callExpression;
            String name;
            if (!(parameter instanceof JSImplicitElement) || StringUtil.isEmpty((String)(name = ((JSImplicitElement)parameter).getUserStringData())) || (callExpression = (JSCallExpressionImpl)ObjectUtils.tryCast((Object)parameter.getParent(), JSCallExpressionImpl.class)) == null || (objectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)CucumberJavaScriptUtil.getFirstCallArgument(callExpression, CucumberJavaScriptUtil.OBJECT_LITERAL_TYPES), JSObjectLiteralExpression.class)) == null || (regexpProp = (JSPropertyImpl)ObjectUtils.tryCast((Object)objectLiteralExpression.findProperty("regexp"), JSPropertyImpl.class)) == null || (regexpExpression = CucumberJavaScriptUtil.findFirstChildLiteral(regexpProp)) == null) continue;
            String regexp = StringUtil.notNullize((String)CucumberJavaScriptUtil.getContentFromLiteralText(regexpExpression.getSignificantValue()));
            JSCallExpressionImpl declaration = callExpression;
            JSPropertyImpl nameProp = (JSPropertyImpl)ObjectUtils.tryCast((Object)objectLiteralExpression.findProperty("name"), JSPropertyImpl.class);
            JSLiteralExpression nameLiteral = CucumberJavaScriptUtil.findFirstChildLiteral(nameProp);
            if (nameLiteral != null) {
                declaration = nameLiteral;
            }
            values.put(name, regexp);
            declarations.put(name, (SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)declaration));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptParameterTypesProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptParameterTypesProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultParameterTypeManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetParameterTypeManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillParameterTypesFromTypeRegistry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

