/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.JavaScriptStepDefinition;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberJavaScriptExtension
extends AbstractCucumberExtension {
    public List<AbstractStepDefinition> getStepDefinitions(@NotNull Module module, @NotNull PsiFile featureFile) {
        VirtualFile file;
        if (module == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(0);
        }
        if (featureFile == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(1);
        }
        if ((file = featureFile.getVirtualFile()) == null) {
            return null;
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        Collection steps = JSClassResolver.getInstance().findElementsByNameIncludingImplicit("$cucumberJSSteps", ProjectScope.getAllScope((Project)module.getProject()));
        for (JSPsiElementBase step : steps) {
            JSLiteralExpression literalExpression;
            JSCallExpressionImpl callExpression = (JSCallExpressionImpl)ObjectUtils.tryCast((Object)step.getParent(), JSCallExpressionImpl.class);
            if (callExpression == null || (literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)CucumberJavaScriptUtil.getFirstCallArgument(callExpression, CucumberJavaScriptUtil.LITERAL_STUBS), JSLiteralExpression.class)) == null) continue;
            result.add(new JavaScriptStepDefinition((PsiElement)literalExpression, ((JSImplicitElementImpl)step).getUserStringData()));
        }
        return result;
    }

    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(3);
        }
        return child instanceof JSFile && !DialectDetector.isTypeScript((PsiElement)child);
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(5);
        }
        return this.isStepLikeFile(child, parent);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)JavaScriptFileType.INSTANCE, "JavaScript");
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        return new CucumberJavaScriptStepDefinitionCreator();
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(6);
        }
        if (featureFile == null) {
            return Collections.emptyList();
        }
        return this.getStepDefinitions(module, featureFile);
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile file) {
        if (file == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(7);
        }
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        Collection steps = JSClassResolver.getInstance().findElementsByNameIncludingImplicit("$cucumberJSSteps", ProjectScope.getAllScope((Project)file.getProject()));
        for (JSPsiElementBase step : steps) {
            PsiFile containingFile = step.getContainingFile();
            if (!this.isStepLikeFile((PsiElement)containingFile, (PsiElement)containingFile)) continue;
            result.add(containingFile);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepDefinitions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStepLikeFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWritableStepLikeFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadStepsFor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepDefinitionContainers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

