/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.state.DiagramEdgesParamSnapshot;
import com.intellij.diagram.state.DiagramGraphElementsParamsSnapshot;
import com.intellij.diagram.state.DiagramGroupNodesParamSnapshot;
import com.intellij.diagram.state.DiagramNodesParamSnapshot;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.util.Pair;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class DiagramLayoutSnapshot
extends DiagramGraphElementsParamsSnapshot<NodeLayoutSnapshot, EdgeLayoutSnapshot, GroupNodeLayoutSnapshot> {
    private DiagramLayoutSnapshot(@NotNull DiagramNodesParamSnapshot<NodeLayoutSnapshot> nodesLayoutsSnapshot, @NotNull DiagramEdgesParamSnapshot<EdgeLayoutSnapshot> edgesLayoutsSnapshot, @NotNull DiagramGroupNodesParamSnapshot<GroupNodeLayoutSnapshot> groupNodesLayoutsSnapshot) {
        if (nodesLayoutsSnapshot == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(0);
        }
        if (edgesLayoutsSnapshot == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(1);
        }
        if (groupNodesLayoutsSnapshot == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(2);
        }
        super(nodesLayoutsSnapshot, edgesLayoutsSnapshot, groupNodesLayoutsSnapshot);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(3);
        }
        CompletionStage completionStage = super.restoreAsync(builder2).thenComposeAsync(ThreadContext.captureThreadContext(__ -> GraphLayoutService.getInstance().queryLayout(builder2.getGraphBuilder()).animated().withAnimationDuration(450).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.BEFORE).runAsync()));
        if (completionStage == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<Void> restoreLayoutingNewNodesAsync(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(5);
        }
        CompletionStage completionStage = this.doRestoreLayoutingNewNodesTo(builder2).thenCompose(newlyAddedElements -> CompletableFuture.completedFuture(null));
        if (completionStage == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(6);
        }
        return completionStage;
    }

    @NotNull
    private CompletableFuture<Pair<List<Node>, List<Edge>>> doRestoreLayoutingNewNodesTo(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(7);
        }
        CompletionStage completionStage = this.restoreAsync(builder2).thenApplyAsync(__ -> {
            Stream<Node> newlyAddedNodes = builder2.getDataModel().getNodes().stream().filter(it -> !this.containsRecordFor((DiagramNode<?>)it)).map(builder2::getNode).filter(Objects::nonNull);
            List newlyAddedEdges = builder2.getDataModel().getEdges().stream().filter(it -> !this.containsRecordFor((DiagramEdge<?>)it)).map(builder2::getEdge).filter(Objects::nonNull).collect(Collectors.toList());
            Stream<Node> newlyAddedGroupNodes = builder2.getDataModel().getGroupNodes().stream().filter(it -> !this.containsRecordFor((NodeGroupDescriptor)it)).map(builder2::getGroupNode).filter(Objects::nonNull);
            return Pair.create(Stream.concat(newlyAddedNodes, newlyAddedGroupNodes).collect(Collectors.toList()), newlyAddedEdges);
        }, builder2.getGraphBuilder().getActionExecutor().getGraphExecutor());
        if (completionStage == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    @NotNull
    private static GraphLayoutService.GraphLayoutQueryParams queryPartialLayout(@NotNull DiagramBuilder builder2, @NotNull List<Node> nodesToLayout, @NotNull List<Edge> edgesToLayout) {
        if (builder2 == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(9);
        }
        if (nodesToLayout == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(10);
        }
        if (edgesToLayout == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(11);
        }
        builder2.getGraphBuilder().getActionExecutor().assertGraphThread();
        GraphLayoutService layoutService = GraphLayoutService.getInstance();
        Layouter partialLayouter = layoutService.getPartialLayouter(builder2.getPresentationModel().getSettings().getCurrentLayouter(), false);
        layoutService.markElementsForPartialLayout(builder2.getGraph(), nodesToLayout, edgesToLayout);
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = layoutService.queryLayout(builder2.getGraphBuilder()).withLayouter(partialLayouter).animated().withAnimationDuration(450).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER);
        if (graphLayoutQueryParams == null) {
            DiagramLayoutSnapshot.$$$reportNull$$$0(12);
        }
        return graphLayoutQueryParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesLayoutsSnapshot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgesLayoutsSnapshot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNodesLayoutsSnapshot";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramLayoutSnapshot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToLayout";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgesToLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramLayoutSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLayoutingNewNodesAsync";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRestoreLayoutingNewNodesTo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "queryPartialLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreLayoutingNewNodesAsync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRestoreLayoutingNewNodesTo";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queryPartialLayout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 12 -> new IllegalStateException(string);
        };
    }

    @Immutable
    public static final class GroupNodeLayoutSnapshot
    implements DiagramGroupNodesParamSnapshot.GroupNodeParamSnapshot {
        private final double myX;
        private final double myY;

        private GroupNodeLayoutSnapshot(double x, double y) {
            this.myX = x;
            this.myY = y;
        }

        private static GroupNodeLayoutSnapshot makeSnapshot(@NotNull DiagramBuilder builder2, @NotNull NodeGroupDescriptor node) {
            if (builder2 == null) {
                GroupNodeLayoutSnapshot.$$$reportNull$$$0(0);
            }
            if (node == null) {
                GroupNodeLayoutSnapshot.$$$reportNull$$$0(1);
            }
            builder2.getGraphBuilder().getActionExecutor().assertReadAccess();
            NodeLayout nodeLayout = builder2.getGraph().getNodeLayout(builder2.getGroupNode(node));
            return new GroupNodeLayoutSnapshot(nodeLayout.getX(), nodeLayout.getY());
        }

        @Override
        public void restoreTo(@NotNull DiagramBuilder builder2, @NotNull NodeGroupDescriptor node) {
            if (builder2 == null) {
                GroupNodeLayoutSnapshot.$$$reportNull$$$0(2);
            }
            if (node == null) {
                GroupNodeLayoutSnapshot.$$$reportNull$$$0(3);
            }
            builder2.getGraph().setLocation(builder2.getGroupNode(node), this.myX, this.myY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupNodeLayoutSnapshot snapshot = (GroupNodeLayoutSnapshot)o;
            return Double.compare(snapshot.myX, this.myX) == 0 && Double.compare(snapshot.myY, this.myY) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.myX, this.myY);
        }

        public String toString() {
            return "GroupNodeLayoutSnapshot{myX=" + this.myX + ", myY=" + this.myY + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/state/DiagramLayoutSnapshot$GroupNodeLayoutSnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeSnapshot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Immutable
    public static final class EdgeLayoutSnapshot
    implements DiagramEdgesParamSnapshot.EdgeParamSnapshot {
        @NotNull
        private final Point2D.Double mySourcePoint;
        @NotNull
        private final Point2D.Double myTargetPoint;
        @NotNull
        private final List<Point2D.Double> myPathPoints;

        private EdgeLayoutSnapshot(@NotNull Point2D.Double sourcePoint, @NotNull Point2D.Double targetPoint, @NotNull List<Point2D.Double> pathPoints) {
            if (sourcePoint == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(0);
            }
            if (targetPoint == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(1);
            }
            if (pathPoints == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(2);
            }
            this.mySourcePoint = sourcePoint;
            this.myTargetPoint = targetPoint;
            this.myPathPoints = pathPoints;
        }

        @NotNull
        private static EdgeLayoutSnapshot makeSnapshot(@NotNull DiagramBuilder builder2, @NotNull DiagramEdge<?> edge) {
            if (builder2 == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(3);
            }
            if (edge == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(4);
            }
            builder2.getGraphBuilder().getActionExecutor().assertReadAccess();
            EdgeLayout edgeLayout = builder2.getGraph().getEdgeLayout(builder2.getEdge(edge));
            YPoint sourcePoint = edgeLayout.getSourcePoint();
            YPoint targetPoint = edgeLayout.getTargetPoint();
            ArrayList<Point2D.Double> pathPoints = new ArrayList<Point2D.Double>();
            for (int i = 0; i < edgeLayout.pointCount(); ++i) {
                YPoint p = edgeLayout.getPoint(i);
                pathPoints.add(new Point2D.Double(p.getX(), p.getY()));
            }
            return new EdgeLayoutSnapshot(new Point2D.Double(sourcePoint.getX(), sourcePoint.getY()), new Point2D.Double(targetPoint.getX(), targetPoint.getY()), pathPoints);
        }

        @Override
        public void restoreTo(@NotNull DiagramBuilder builder2, @NotNull DiagramEdge<?> edge) {
            if (builder2 == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(5);
            }
            if (edge == null) {
                EdgeLayoutSnapshot.$$$reportNull$$$0(6);
            }
            EdgeLayout edgeLayout = builder2.getGraph().getEdgeLayout(builder2.getEdge(edge));
            edgeLayout.clearPoints();
            edgeLayout.setSourcePoint(GraphManager.getGraphManager().createYPoint(this.mySourcePoint.x, this.mySourcePoint.y));
            edgeLayout.setTargetPoint(GraphManager.getGraphManager().createYPoint(this.myTargetPoint.x, this.myTargetPoint.y));
            for (Point2D.Double point : this.myPathPoints) {
                edgeLayout.addPoint(point.x, point.y);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeLayoutSnapshot snapshot = (EdgeLayoutSnapshot)o;
            return this.mySourcePoint.equals(snapshot.mySourcePoint) && this.myTargetPoint.equals(snapshot.myTargetPoint) && this.myPathPoints.equals(snapshot.myPathPoints);
        }

        public int hashCode() {
            return Objects.hash(this.mySourcePoint, this.myTargetPoint, this.myPathPoints);
        }

        public String toString() {
            return "EdgeLayoutSnapshot{mySourcePoint=" + String.valueOf(this.mySourcePoint) + ", myTargetPoint=" + String.valueOf(this.myTargetPoint) + ", myPathPoints=" + String.valueOf(this.myPathPoints) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePoint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathPoints";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/state/DiagramLayoutSnapshot$EdgeLayoutSnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeSnapshot";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Immutable
    public static final class NodeLayoutSnapshot
    implements DiagramNodesParamSnapshot.NodeParamSnapshot {
        private final double myX;
        private final double myY;

        private NodeLayoutSnapshot(double x, double y) {
            this.myX = x;
            this.myY = y;
        }

        @NotNull
        private static NodeLayoutSnapshot makeSnapshot(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<?> node) {
            if (builder2 == null) {
                NodeLayoutSnapshot.$$$reportNull$$$0(0);
            }
            if (node == null) {
                NodeLayoutSnapshot.$$$reportNull$$$0(1);
            }
            builder2.getGraphBuilder().getActionExecutor().assertReadAccess();
            NodeLayout nodeLayout = builder2.getGraph().getNodeLayout(builder2.getNode(node));
            return new NodeLayoutSnapshot(nodeLayout.getX(), nodeLayout.getY());
        }

        @Override
        public void restoreTo(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<?> node) {
            if (builder2 == null) {
                NodeLayoutSnapshot.$$$reportNull$$$0(2);
            }
            if (node == null) {
                NodeLayoutSnapshot.$$$reportNull$$$0(3);
            }
            builder2.getGraph().setLocation(builder2.getNode(node), this.myX, this.myY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeLayoutSnapshot snapshot = (NodeLayoutSnapshot)o;
            return Double.compare(snapshot.myX, this.myX) == 0 && Double.compare(snapshot.myY, this.myY) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.myX, this.myY);
        }

        public String toString() {
            return "NodeLayoutSnapshot{myX=" + this.myX + ", myY=" + this.myY + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/state/DiagramLayoutSnapshot$NodeLayoutSnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeSnapshot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Factory
    extends DiagramGraphElementsParamsSnapshot.Factory<DiagramLayoutSnapshot, NodeLayoutSnapshot, EdgeLayoutSnapshot, GroupNodeLayoutSnapshot> {
        @NotNull
        private static final Factory INSTANCE = new Factory(NodeLayoutSnapshot::makeSnapshot, EdgeLayoutSnapshot::makeSnapshot, GroupNodeLayoutSnapshot::makeSnapshot);

        private Factory(@NotNull DiagramNodesParamSnapshot.NodeParamSnapshotFactory<NodeLayoutSnapshot> nodeParamSnapshotFactory, @NotNull DiagramEdgesParamSnapshot.EdgeParamSnapshotFactory<EdgeLayoutSnapshot> edgeParamSnapshotFactory, @NotNull DiagramGroupNodesParamSnapshot.GroupNodeParamSnapshotFactory<GroupNodeLayoutSnapshot> groupNodeParamSnapshotFactory) {
            if (nodeParamSnapshotFactory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (edgeParamSnapshotFactory == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (groupNodeParamSnapshotFactory == null) {
                Factory.$$$reportNull$$$0(2);
            }
            super(nodeParamSnapshotFactory, edgeParamSnapshotFactory, groupNodeParamSnapshotFactory);
        }

        @NotNull
        public static Factory getInstance() {
            Factory factory = INSTANCE;
            if (factory == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return factory;
        }

        @Override
        @NotNull
        public DiagramLayoutSnapshot makeSnapshot(@NotNull DiagramBuilder builder2) {
            if (builder2 == null) {
                Factory.$$$reportNull$$$0(4);
            }
            DiagramLayoutSnapshot diagramLayoutSnapshot = (DiagramLayoutSnapshot)builder2.getActionExecutor().suppressComputableReadLockAssertion(() -> (DiagramLayoutSnapshot)builder2.getActionExecutor().computeReadAction(() -> new DiagramLayoutSnapshot((DiagramNodesParamSnapshot<NodeLayoutSnapshot>)this.myNodeSnapshotFactory.makeSnapshot(builder2), (DiagramEdgesParamSnapshot<EdgeLayoutSnapshot>)this.myEdgeSnapshotFactory.makeSnapshot(builder2), (DiagramGroupNodesParamSnapshot<GroupNodeLayoutSnapshot>)this.myGroupNodeSnapshotFactory.makeSnapshot(builder2))));
            if (diagramLayoutSnapshot == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return diagramLayoutSnapshot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeParamSnapshotFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeParamSnapshotFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupNodeParamSnapshotFactory";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/state/DiagramLayoutSnapshot$Factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/state/DiagramLayoutSnapshot$Factory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "makeSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

