/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeDeferredIconsEvaluator;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.util.Iconable;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeItemComponent
extends CellRendererPanel {
    @NotNull
    private final SimpleColoredComponent myLeft = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent myRight = new SimpleColoredComponent();

    public DiagramNodeItemComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
        this.add((Component)this.myLeft, "West");
        this.add((Component)this.myRight, "East");
        this.myLeft.setOpaque(true);
        this.myLeft.setIconOpaque(true);
        this.myRight.setOpaque(true);
        this.myRight.setIconOpaque(true);
        this.setOpaque(true);
    }

    public void setUp(@NotNull DiagramNodeBodyComponent owner, @NotNull DiagramBuilder builder2, @NotNull DiagramNode<Object> node, @Nullable Object element, boolean selected) {
        if (owner == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(1);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(2);
        }
        this.myLeft.clear();
        this.myRight.clear();
        this.setSelected(selected);
        this.setUpIcon(owner, builder2, node, element);
        this.setUpText(builder2, node, element);
        this.setUpColors(builder2, node, element);
    }

    private void setUpIcon(@NotNull DiagramNodeBodyComponent owner, @NotNull DiagramBuilder builder2, @NotNull DiagramNode<Object> node, @Nullable Object nodeItem) {
        if (owner == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(3);
        }
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(4);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(5);
        }
        Icon icon = DiagramNodeDeferredIconsEvaluator.getInstance().registerEvaluationOrGetReadyIcon(new MyIconable(builder2, node.getIdentifyingElement(), nodeItem), evaluatedIcon -> {
            this.myLeft.setIcon(ScalableIconWrapper.wrap(evaluatedIcon, __ -> owner.getContainerComponent().invalidateRenderCacheForCurrentRealizer()));
            owner.getContainerComponent().invalidateRenderCacheForCurrentRealizer();
        });
        this.myLeft.setIcon(ScalableIconWrapper.wrap(icon, __ -> owner.getContainerComponent().invalidateRenderCacheForCurrentRealizer()));
    }

    private void setUpText(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<Object> node, @Nullable Object element) {
        SimpleColoredText typeText;
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(7);
        }
        DiagramElementManager<?> elementManager = builder2.getProvider().getElementManager();
        Color forcedForeground = this.getForcedForegroundColor(builder2, node, element);
        Color anchorColor = DiagramNodeItemComponent.getAnchorColor(builder2, node, element);
        SimpleColoredText text = elementManager.getItemName(node.getIdentifyingElement(), element, DiagramBuilderFactory.getInstance().getModelBuilder(builder2));
        if (text != null) {
            this.doAppend(this.myLeft, text, forcedForeground, anchorColor);
        }
        if ((typeText = elementManager.getItemType(node.getIdentifyingElement(), element, DiagramBuilderFactory.getInstance().getModelBuilder(builder2))) != null) {
            switch (DiagramConfiguration.getInstance().getDiagramNodeItemStyle()) {
                case PLAIN: {
                    this.doAppend(this.myLeft, new SimpleColoredText(":  ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES), forcedForeground, anchorColor);
                    this.doAppend(this.myLeft, typeText, forcedForeground, anchorColor);
                    break;
                }
                case ALIGNED: {
                    this.doAppend(this.myRight, typeText, forcedForeground, anchorColor);
                }
            }
        }
    }

    private void doAppend(@NotNull SimpleColoredComponent target, @NotNull SimpleColoredText text, @Nullable Color foreground, @Nullable Color anchor) {
        if (target == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(8);
        }
        if (text == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(9);
        }
        if (anchor == null && foreground == null) {
            text.appendToComponent((ColoredTextContainer)target);
            return;
        }
        ArrayList attrs = text.getAttributes();
        ArrayList texts = text.getTexts();
        for (int i = 0; i < texts.size(); ++i) {
            SimpleTextAttributes attr = (SimpleTextAttributes)attrs.get(i);
            Color fg = this.isSelected() ? null : (anchor != null ? anchor : foreground);
            Color bg = this.isSelected() ? null : attr.getBgColor();
            int style = attr.getStyle() | (anchor != null ? 1 : 0);
            target.append((String)texts.get(i), new SimpleTextAttributes(bg, fg, attr.getWaveColor(), style));
        }
    }

    private void setUpColors(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<?> node, @Nullable Object element) {
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(10);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(11);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            this.setForeground((Color)JBColor.BLACK);
            this.setForcedBackground((Color)JBColor.WHITE);
        } else {
            Color defaultFg;
            Color foreground;
            DiagramColorManager colorManager = builder2.getProvider().getColorManager();
            Color background = colorManager.getNodeBackground(builder2, node, element, this.isSelected());
            if (!ColorUtil.areContrasting((Color)background, (Color)(foreground = colorManager.getNodeForeground(builder2, node, element, this.isSelected()))) && ColorUtil.areContrasting((Color)background, (Color)(defaultFg = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground()))) {
                foreground = defaultFg;
            }
            this.setBackground(background);
            this.setForeground(foreground);
        }
    }

    @Nullable
    private Color getForcedForegroundColor(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<?> node, @Nullable Object element) {
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(12);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(13);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            return builder2.getColorScheme().getDefaultForeground();
        }
        if (this.isSelected()) {
            return builder2.getProvider().getColorManager().getNodeForeground(builder2, node, element, true);
        }
        return null;
    }

    @Nullable
    private static Color getAnchorColor(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<?> node, @Nullable Object element) {
        Node yNode;
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(14);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(15);
        }
        if ((yNode = builder2.getNode(node)) == null) {
            return null;
        }
        return Optional.ofNullable(DiagramNodeItemComponent.getAnchorColorAmong(builder2, element, yNode.inEdges(), it -> it.getTargetAnchor())).orElseGet(() -> DiagramNodeItemComponent.getAnchorColorAmong(builder2, element, yNode.outEdges(), it -> it.getSourceAnchor()));
    }

    @Nullable
    private static Color getAnchorColorAmong(@NotNull DiagramBuilder builder2, @Nullable Object element, @NotNull EdgeCursor cursor, @NotNull Function<DiagramEdge<?>, Object> anchorGetter) {
        if (builder2 == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(16);
        }
        if (cursor == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(17);
        }
        if (anchorGetter == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(18);
        }
        Edge edge = cursor.edge();
        while (cursor.ok()) {
            Object anchor;
            DiagramEdge<?> e;
            if (edge != null && builder2.getGraph().isSelected(edge) && (e = builder2.getEdgeObject(edge)) != null && (anchor = anchorGetter.apply(e)) != null && anchor.equals(element)) {
                Color color = e.getAnchorColor();
                return color == null ? JBColor.foreground() : color;
            }
            cursor.next();
            edge = cursor.edge();
        }
        return null;
    }

    public Dimension getPreferredSize() {
        int maxItemLength;
        Dimension size = super.getPreferredSize();
        int itemLength = this.myLeft.toString().length();
        int clampedWidth = itemLength > (maxItemLength = DiagramConfiguration.getInstance().getShortenNodeItemOnLength()) ? (int)Math.round((double)size.width * 1.0 * (double)maxItemLength / (double)itemLength) : size.width;
        return new Dimension(clampedWidth, size.height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cursor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorGetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagram/components/DiagramNodeItemComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUp";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doAppend";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpColors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getForcedForegroundColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchorColor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchorColorAmong";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyIconable
    implements Iconable {
        @NotNull
        private final DiagramBuilder myBuilder;
        @Nullable
        private final Object myNodeElement;
        @Nullable
        private final Object myNodeItem;

        private MyIconable(@NotNull DiagramBuilder builder2, @Nullable Object nodeElement, @Nullable Object nodeItem) {
            if (builder2 == null) {
                MyIconable.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder2;
            this.myNodeElement = nodeElement;
            this.myNodeItem = nodeItem;
        }

        public Icon getIcon(int flags) {
            DiagramElementManager<?> manager = this.myBuilder.getProvider().getElementManager();
            return manager.getItemIcon(this.myNodeElement, this.myNodeItem, DiagramBuilderFactory.getInstance().getModelBuilder(this.myBuilder));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyIconable iconable = (MyIconable)o;
            return Objects.equals(this.myNodeItem, iconable.myNodeItem);
        }

        public int hashCode() {
            return Objects.hash(this.myNodeItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diagram/components/DiagramNodeItemComponent$MyIconable", "<init>"));
        }
    }
}

