/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderExKt;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDiagramNode<T extends PsiElement>
extends DiagramNodeBase<T> {
    @NotNull
    private static final Key<Color> FILE_TAB_COLOR_KEY = Key.create((String)"file tab color");
    @NotNull
    private final SmartPsiElementPointer<T> myPointer;
    @NotNull
    private T lastGoodPsiElement;

    public PsiDiagramNode(@NotNull T psiElement, @NotNull DiagramBuilder builder2) {
        if (psiElement == null) {
            PsiDiagramNode.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            PsiDiagramNode.$$$reportNull$$$0(1);
        }
        super(builder2);
        this.myPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        this.lastGoodPsiElement = psiElement;
    }

    public PsiDiagramNode(@NotNull T psiElement, @NotNull DiagramProvider<T> provider) {
        if (psiElement == null) {
            PsiDiagramNode.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiDiagramNode.$$$reportNull$$$0(3);
        }
        super(provider);
        this.myPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        this.lastGoodPsiElement = psiElement;
    }

    @NotNull
    protected final T getElement() {
        PsiElement element = (PsiElement)ReadAction.compute(() -> this.myPointer.getElement());
        if (element != null) {
            this.lastGoodPsiElement = element;
            PsiElement psiElement = element;
            if (psiElement == null) {
                PsiDiagramNode.$$$reportNull$$$0(4);
            }
            return (T)psiElement;
        }
        T t = this.lastGoodPsiElement;
        if (t == null) {
            PsiDiagramNode.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.getElement().getIcon(0);
    }

    @Override
    @NotNull
    public T getIdentifyingElement() {
        return this.getElement();
    }

    @Override
    @Nullable
    public Color getFileTabForeground() {
        return (Color)UserDataHolderExKt.nullableLazyValue((UserDataHolder)this, FILE_TAB_COLOR_KEY, () -> this.computeFileTabForeground());
    }

    private Color computeFileTabForeground() {
        VirtualFile file;
        T element = this.getElement();
        VirtualFile virtualFile = file = element.isValid() ? PsiUtilCore.getVirtualFile(element) : null;
        if (file == null) {
            return null;
        }
        return FileStatusManager.getInstance((Project)element.getProject()).getStatus(file).getColor();
    }

    @Override
    public void precachePresentation() {
        super.precachePresentation();
        this.getFileTabForeground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/PsiDiagramNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/PsiDiagramNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

