/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderExKt;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleColoredText;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramNodeBase<T>
extends UserDataHolderBase
implements DiagramNode<T>,
Navigatable {
    @NotNull
    private static final Key<String> FQN_KEY = Key.create((String)"FQN");
    @NotNull
    private static final Key<VisibilityLevel> VISIBILITY_LEVEL_KEY = Key.create((String)"visibility");
    @NotNull
    private static final Key<SimpleColoredText> PRESENTABLE_TITLE_KEY = Key.create((String)"presentable title");
    @NotNull
    private final DiagramProvider<T> myProvider;
    @Nullable
    private final DiagramBuilder myBuilder;
    @NotNull
    private final List<NodeLabel> myLabels;

    public DiagramNodeBase(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramNodeBase.$$$reportNull$$$0(0);
        }
        this.myLabels = new ArrayList<NodeLabel>();
        this.myProvider = builder2.getProvider();
        this.myBuilder = builder2;
    }

    public DiagramNodeBase(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            DiagramNodeBase.$$$reportNull$$$0(1);
        }
        this.myLabels = new ArrayList<NodeLabel>();
        this.myProvider = provider;
        this.myBuilder = null;
    }

    @Override
    @NotNull
    public final DiagramProvider<T> getProvider() {
        DiagramProvider<T> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramNodeBase.$$$reportNull$$$0(2);
        }
        return diagramProvider;
    }

    @Nullable
    protected DiagramBuilder getBuilder() {
        return this.myBuilder != null ? this.myBuilder : (DiagramBuilder)this.getUserData(DiagramDataKeys.GRAPH_BUILDER);
    }

    @Override
    @NotNull
    public List<NodeLabel> getLabels() {
        List<NodeLabel> list = this.myLabels;
        if (list == null) {
            DiagramNodeBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return (String)UserDataHolderExKt.nullableLazyValue((UserDataHolder)this, FQN_KEY, () -> this.getProvider().getVfsResolver().getQualifiedName(this.getIdentifyingElement()));
    }

    @ApiStatus.Internal
    @Nullable
    protected String getFQN() {
        return this.getQualifiedName();
    }

    @Override
    @Nullable
    public SimpleColoredText getPresentableTitle() {
        return (SimpleColoredText)UserDataHolderExKt.nullableLazyValue((UserDataHolder)this, PRESENTABLE_TITLE_KEY, () -> this.computePresentableTitle());
    }

    @Nullable
    protected SimpleColoredText computePresentableTitle() {
        DiagramBuilder builder2 = this.getBuilder();
        return builder2 != null ? this.getProvider().getElementManager().getPresentableElementTitle(this.getIdentifyingElement(), builder2) : DiagramNode.super.getPresentableTitle();
    }

    @Override
    @Nullable
    public VisibilityLevel getVisibilityLevel() {
        return (VisibilityLevel)UserDataHolderExKt.nullableLazyValue((UserDataHolder)this, VISIBILITY_LEVEL_KEY, () -> this.myProvider.createVisibilityManager().getVisibilityLevel(this.getIdentifyingElement()));
    }

    @Override
    public void precachePresentation() {
        this.getFQN();
        this.getVisibilityLevel();
        this.getIcon();
        this.putUserData(PRESENTABLE_TITLE_KEY, null);
        this.getPresentableTitle();
    }

    public void navigate(boolean requestFocus) {
        DiagramBuilder builder2 = this.getBuilder();
        if (builder2 == null) {
            return;
        }
        Node node = builder2.getNode(this);
        if (node == null) {
            return;
        }
        Graph2D graph = builder2.getGraph();
        graph.unselectAll();
        graph.setSelected(node, true);
        GraphAnimationService.getInstance().focusViewOnNodes(builder2.getGraphBuilder(), List.of(node), true);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramNodeBase that = (DiagramNodeBase)obj;
        return DiagramNodeIdentity.of(this).equals(DiagramNodeIdentity.of(that));
    }

    public int hashCode() {
        return DiagramNodeIdentity.of(this).hashCode();
    }

    public String toString() {
        return this.getTooltip();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramNodeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramNodeBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

