/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class DefinedNode
extends Node {
    private Node expressionNode;

    public DefinedNode(SourcePosition position, Node expressionNode) {
        super(position);
        assert (expressionNode != null) : "expressionNode is not null";
        this.expressionNode = this.adopt(expressionNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        DefinedNode other = (DefinedNode)node;
        if (this.getExpression() == null && other.getExpression() == null) {
            return true;
        }
        if (this.getExpression() == null || other.getExpression() == null) {
            return false;
        }
        return this.getExpression().isSame(other.getExpression());
    }

    public NodeType getNodeType() {
        return NodeType.DEFINEDNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefinedNode(this);
    }

    public Node getExpression() {
        return this.expressionNode;
    }

    @Deprecated
    public Node getExpressionNode() {
        return this.getExpression();
    }
}

