/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.dvcs.MultiMessage;
import com.intellij.dvcs.MultiRootMessage;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.RestrictingAuthenticationGate;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.fetch.GitFetchHandler;
import git4idea.fetch.GitFetchInProgressListener;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSpec;
import git4idea.fetch.GitFetchSupport;
import git4idea.fetch.GitFetchSupportImpl;
import git4idea.fetch.GitFetchSupportImplKt;
import git4idea.fetch.GitRemoteOperationQueueImpl;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0004ABCDB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J%\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00142\u000b\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!H\u0016J\"\u0010\"\u001a\u00020\u00182\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140$0\u001aH\u0016J\u0016\u0010\u001c\u001a\u00020\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0016J\u001a\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0002J\u001e\u00101\u001a\u0002022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u00103\u001a\u000202H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020+0/2\f\u00105\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J!\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0002\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020&2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010 2\u0006\u0010@\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl;", "Lgit4idea/fetch/GitFetchSupport;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "git", "Lgit4idea/commands/GitImpl;", "getGit", "()Lgit4idea/commands/GitImpl;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "Lorg/jetbrains/annotations/NotNull;", "getProgressManager", "()Lcom/intellij/openapi/progress/ProgressManager;", "fetchQueue", "Lgit4idea/fetch/GitRemoteOperationQueueImpl;", "fetchRequestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getDefaultRemoteToFetch", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "fetchDefaultRemote", "Lgit4idea/fetch/GitFetchResult;", "repositories", "", "fetchAllRemotes", "fetch", "remote", "fetchUnshallow", "refspec", "", "Lorg/jetbrains/annotations/NonNls;", "fetchRemotes", "remotes", "Lcom/intellij/openapi/util/Pair;", "fetchSpec", "Lgit4idea/fetch/GitFetchSpec;", "mergeRepoResults", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "firstResult", "secondResult", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "isFetchRunning", "", "fetchInParallel", "", "Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "getMaxThreads", "", "numberOfRemotes", "waitForFetchTasks", "tasks", "withIndicator", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "doFetch", "fetchTarget", "authenticationGate", "Lcom/intellij/externalProcessAuthHelper/AuthenticationGate;", "getPrunedRef", "line", "FetchTask", "RepoResult", "SingleRemoteResult", "FetchResultImpl", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,390:1\n1563#2:391\n1634#2,3:392\n1634#2,3:395\n1761#2,3:398\n1617#2,9:405\n1869#2:414\n1870#2:416\n1626#2:417\n1504#2:418\n1534#2,3:419\n1537#2,3:429\n1869#2,2:432\n37#3:401\n36#3,3:402\n1#4:415\n382#5,7:422\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl\n*L\n108#1:391\n108#1:392,3\n161#1:395,3\n199#1:398,3\n267#1:405,9\n267#1:414\n267#1:416\n267#1:417\n131#1:418\n131#1:419,3\n131#1:429,3\n134#1:432,2\n262#1:401\n262#1:402,3\n267#1:415\n131#1:422,7\n*E\n"})
public final class GitFetchSupportImpl
implements GitFetchSupport {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRemoteOperationQueueImpl fetchQueue;
    @NotNull
    private final AtomicInteger fetchRequestCounter;

    public GitFetchSupportImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fetchQueue = new GitRemoteOperationQueueImpl();
        this.fetchRequestCounter = new AtomicInteger();
    }

    private final GitImpl getGit() {
        Git git = Git.getInstance();
        Intrinsics.checkNotNull((Object)git, (String)"null cannot be cast to non-null type git4idea.commands.GitImpl");
        return (GitImpl)git;
    }

    private final ProgressManager getProgressManager() {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        return progressManager;
    }

    @Override
    @Nullable
    public GitRemote getDefaultRemoteToFetch(@NotNull GitRepository repository2) {
        GitLocalBranch gitLocalBranch;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Collection<GitRemote> collection = repository2.getRemotes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemotes(...)");
        Collection<GitRemote> remotes = collection;
        if (remotes.isEmpty()) {
            gitLocalBranch = null;
        } else if (remotes.size() == 1) {
            gitLocalBranch = (GitRemote)CollectionsKt.first((Iterable)remotes);
        } else {
            gitLocalBranch = repository2.getCurrentBranch();
            if (gitLocalBranch == null || (gitLocalBranch = gitLocalBranch.findTrackedBranch(repository2)) == null || (gitLocalBranch = gitLocalBranch.getRemote()) == null) {
                gitLocalBranch = GitUtil.findRemoteByName(repository2, "origin");
            }
        }
        return gitLocalBranch;
    }

    @NotNull
    public GitFetchResult fetchDefaultRemote(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            GitRemote remote = this.getDefaultRemoteToFetch(gitRepository);
            if (remote != null) {
                remotesToFetch.add(new GitFetchSpec(gitRepository, remote, null, false, null, 28, null));
                continue;
            }
            GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
        }
        return this.fetch(remotesToFetch);
    }

    @NotNull
    public GitFetchResult fetchAllRemotes(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            if (gitRepository.getRemotes().isEmpty()) {
                GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
                continue;
            }
            for (GitRemote remote : gitRepository.getRemotes()) {
                Intrinsics.checkNotNull((Object)remote);
                remotesToFetch.add(new GitFetchSpec(gitRepository, remote, null, false, null, 28, null));
            }
        }
        return this.fetch(remotesToFetch);
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return this.fetch(CollectionsKt.listOf((Object)new GitFetchSpec(repository2, remote, null, false, null, 28, null)));
    }

    @Override
    @NotNull
    public GitFetchResult fetchUnshallow(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return this.fetch(CollectionsKt.listOf((Object)new GitFetchSpec(repository2, remote, null, true, null, 20, null)));
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull String refspec) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)refspec, (String)"refspec");
        return this.fetch(CollectionsKt.listOf((Object)new GitFetchSpec(repository2, remote, refspec, false, null, 24, null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public GitFetchResult fetchRemotes(@NotNull Collection<? extends com.intellij.openapi.util.Pair<GitRepository, GitRemote>> remotes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        Iterable iterable = remotes;
        GitFetchSupportImpl gitFetchSupportImpl = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            GitRepository gitRepository = (GitRepository)object;
            Object object2 = it.second;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
            collection.add(new GitFetchSpec(gitRepository, (GitRemote)object2, null, false, null, 28, null));
        }
        return gitFetchSupportImpl.fetch((List)destination$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull Collection<GitFetchSpec> fetchSpec) {
        Intrinsics.checkNotNullParameter(fetchSpec, (String)"fetchSpec");
        try {
            int counterAfterIncrement = this.fetchRequestCounter.incrementAndGet();
            if (counterAfterIncrement == 1) {
                ((GitFetchInProgressListener)this.project.getMessageBus().syncPublisher(GitFetchInProgressListener.Companion.getTOPIC())).fetchStarted();
            }
            GitFetchResult gitFetchResult = (GitFetchResult)this.withIndicator(() -> GitFetchSupportImpl.fetch$lambda$4(this, fetchSpec));
            return gitFetchResult;
        }
        finally {
            int counterAfterDecrement = this.fetchRequestCounter.decrementAndGet();
            if (counterAfterDecrement == 0) {
                ((GitFetchInProgressListener)this.project.getMessageBus().syncPublisher(GitFetchInProgressListener.Companion.getTOPIC())).fetchFinished();
            }
        }
    }

    private final RepoResult mergeRepoResults(RepoResult firstResult, SingleRemoteResult secondResult) {
        if (firstResult == null) {
            return new RepoResult(MapsKt.mapOf((Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
        }
        return new RepoResult(MapsKt.plus(firstResult.getResults(), (Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
    }

    @Override
    public boolean isFetchRunning() {
        return this.fetchRequestCounter.get() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FetchTask> fetchInParallel(Collection<GitFetchSpec> remotes) {
        void destination$iv;
        void $this$mapTo$iv;
        List tasks = new ArrayList();
        Iterable iterable = remotes;
        Collection collection = new HashSet();
        GitFetchSupportImpl gitFetchSupportImpl = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            GitFetchSpec gitFetchSpec = (GitFetchSpec)item$iv;
            void var13_13 = destination$iv;
            boolean bl = false;
            var13_13.add(it.getRepository());
        }
        int maxThreads = gitFetchSupportImpl.getMaxThreads((Collection<? extends GitRepository>)destination$iv, remotes.size());
        GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remotes + " using " + maxThreads + " threads");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitFetch pool", (int)maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        ExecutorService executor = executorService;
        ProgressIndicator progressIndicator = this.getProgressManager().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator commonIndicator = progressIndicator;
        RestrictingAuthenticationGate authenticationGate = new RestrictingAuthenticationGate();
        for (GitFetchSpec fetchTarget : remotes) {
            Future<SingleRemoteResult> future;
            GitRepository repository2 = fetchTarget.getRepository();
            GitRemote remote = fetchTarget.getRemote();
            GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remote + " in " + repository2);
            Intrinsics.checkNotNullExpressionValue(executor.submit(() -> GitFetchSupportImpl.fetchInParallel$lambda$8(commonIndicator, this, repository2, remote, fetchTarget, authenticationGate)), (String)"submit(...)");
            tasks.add(new FetchTask(repository2, remote, future));
        }
        return tasks;
    }

    private final int getMaxThreads(Collection<? extends GitRepository> repositories, int numberOfRemotes) {
        boolean bl;
        int config = Registry.Companion.intValue("git.parallel.fetch.threads");
        int maxThreads = config > 0 ? config : (config == -1 ? Runtime.getRuntime().availableProcessors() : (config == -2 ? numberOfRemotes : (config == -3 ? Math.min(numberOfRemotes, Runtime.getRuntime().availableProcessors() * 2) : 1)));
        try {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = repositories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)GitConfigUtil.getValue(this.project, it.getRoot(), "credential.helper"), (String)"store", (boolean)true)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (VcsException e) {
            GitFetchSupportImplKt.access$getLOG$p().warn((Throwable)e);
            return 1;
        }
        boolean isStoreCredentialsHelperUsed = bl;
        if (isStoreCredentialsHelperUsed) {
            return 1;
        }
        return Math.min(maxThreads, 10);
    }

    private final List<SingleRemoteResult> waitForFetchTasks(List<FetchTask> tasks) {
        List results = new ArrayList();
        for (FetchTask task : tasks) {
            try {
                SingleRemoteResult singleRemoteResult = task.getFuture().get();
                Intrinsics.checkNotNullExpressionValue((Object)singleRemoteResult, (String)"get(...)");
                results.add(singleRemoteResult);
            }
            catch (CancellationException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    throw (ProcessCanceledException)throwable;
                }
                GitRepository gitRepository = task.getRepository();
                GitRemote gitRemote = task.getRemote();
                Object object = e.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    String string = GitBundle.message((String)"error.dialog.title", (Object[])new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                }
                results.add(new SingleRemoteResult(gitRepository, gitRemote, (String)object, CollectionsKt.emptyList()));
                GitFetchSupportImplKt.access$getLOG$p().error((Throwable)e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withIndicator(Function0<? extends T> operation) {
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = indicator = this.getProgressManager().getProgressIndicator();
        String prevText = progressIndicator != null ? progressIndicator.getText() : null;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(GitBundle.message((String)"git.fetch.progress", (Object[])new Object[0]));
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            block5: {
                ProgressIndicator progressIndicator3 = indicator;
                if (progressIndicator3 != null) {
                    progressIndicator3.setText(prevText);
                }
                ProgressIndicator progressIndicator4 = indicator;
                if (progressIndicator4 == null) break block5;
                progressIndicator4.setText2(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SingleRemoteResult doFetch(GitFetchSpec fetchTarget, AuthenticationGate authenticationGate) {
        void $this$mapNotNullTo$iv$iv;
        void $this$toTypedArray$iv;
        Collection collection;
        ProgressIndicator indicator = this.getProgressManager().getProgressIndicator();
        GitLineHandlerListener progressListener = (arg_0, arg_1) -> GitFetchSupportImpl.doFetch$lambda$10(indicator, arg_0, arg_1);
        String recurseSubmodules = "--recurse-submodules=no";
        List $this$doFetch_u24lambda_u2411 = collection = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (fetchTarget.getRefspec() != null) {
            $this$doFetch_u24lambda_u2411.add(fetchTarget.getRefspec());
        }
        $this$doFetch_u24lambda_u2411.add(recurseSubmodules);
        String fetchTagsParam = fetchTarget.getFetchTagsMode().getParam();
        if (fetchTagsParam != null) {
            $this$doFetch_u24lambda_u2411.add(fetchTagsParam);
        }
        if (fetchTarget.getUnshallow()) {
            $this$doFetch_u24lambda_u2411.add("--unshallow");
        }
        collection = CollectionsKt.build((List)collection);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] params = thisCollection$iv.toArray(new String[0]);
        GitRepository repository2 = fetchTarget.getRepository();
        GitRemote remote = fetchTarget.getRemote();
        GitCommandResult gitCommandResult = this.getGit().fetch(fetchTarget.getRepository(), remote, (List<? extends GitLineHandlerListener>)CollectionsKt.listOf((Object)progressListener), authenticationGate, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"fetch(...)");
        GitCommandResult result2 = gitCommandResult;
        List<String> list = result2.getOutput();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOutput(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.getPrunedRef(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pruned = (List)destination$iv$iv;
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository2.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository2, remote);
            repository2.update();
        }
        String error = result2.success() ? null : result2.getErrorOutputAsJoinedString();
        return new SingleRemoteResult(repository2, remote, error, pruned);
    }

    private final String getPrunedRef(String line) {
        Matcher matcher = GitFetchSupportImplKt.access$getPRUNE_PATTERN$p().matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final FetchResultImpl fetch$lambda$4(GitFetchSupportImpl this$0, Collection $fetchSpec) {
        void $this$groupByTo$iv$iv;
        StructuredIdeActivity activity = IdeActivityDefinition.started$default((IdeActivityDefinition)VcsStatisticsCollector.INSTANCE.getFETCH_ACTIVITY(), (Project)this$0.project, null, (int)2, null);
        List<FetchTask> tasks = this$0.fetchInParallel($fetchSpec);
        List<SingleRemoteResult> results = this$0.waitForFetchTasks(tasks);
        Map mergedResults = new LinkedHashMap();
        List succeedResults = new ArrayList();
        for (SingleRemoteResult result2 : results) {
            RepoResult res = (RepoResult)mergedResults.get(result2.getRepository());
            mergedResults.put(result2.getRepository(), this$0.mergeRepoResults(res, result2));
            if (!result2.success()) continue;
            succeedResults.add(result2);
        }
        Iterable $this$groupBy$iv = succeedResults;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            SingleRemoteResult it2 = (SingleRemoteResult)element$iv$iv;
            boolean $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = false;
            GitRepository key$iv$iv = it2.getRepository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            SingleRemoteResult $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = (SingleRemoteResult)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it.getRemote());
        }
        Map successFetchesMap = destination$iv$iv;
        if (!successFetchesMap.isEmpty()) {
            Project project = this$0.project;
            ProgressIndicator progressIndicator = this$0.getProgressManager().getProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            GitFetchHandler.Companion.afterSuccessfulFetch(project, successFetchesMap, progressIndicator);
            Iterable $this$forEach$iv = successFetchesMap.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GitRepository it = (GitRepository)element$iv;
                boolean bl = false;
                it.getTagHolder().reload();
            }
        }
        StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
        Project project = this$0.project;
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
        return new FetchResultImpl(project, vcsNotifier, mergedResults);
    }

    private static final SingleRemoteResult fetchInParallel$lambda$8$lambda$7$lambda$6(GitFetchSupportImpl this$0, GitFetchSpec $fetchTarget, RestrictingAuthenticationGate $authenticationGate) {
        return this$0.doFetch($fetchTarget, (AuthenticationGate)$authenticationGate);
    }

    private static final void fetchInParallel$lambda$8$lambda$7(ProgressIndicator $commonIndicator, Ref.ObjectRef $result, GitFetchSupportImpl this$0, GitRepository $repository, GitRemote $remote, GitFetchSpec $fetchTarget, RestrictingAuthenticationGate $authenticationGate) {
        $commonIndicator.checkCanceled();
        $result.element = this$0.fetchQueue.executeForRemote($repository, $remote, () -> GitFetchSupportImpl.fetchInParallel$lambda$8$lambda$7$lambda$6(this$0, $fetchTarget, $authenticationGate));
    }

    private static final SingleRemoteResult fetchInParallel$lambda$8(ProgressIndicator $commonIndicator, GitFetchSupportImpl this$0, GitRepository $repository, GitRemote $remote, GitFetchSpec $fetchTarget, RestrictingAuthenticationGate $authenticationGate) {
        SingleRemoteResult singleRemoteResult;
        $commonIndicator.checkCanceled();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ProgressManager.getInstance().executeProcessUnderProgress(() -> GitFetchSupportImpl.fetchInParallel$lambda$8$lambda$7($commonIndicator, result2, this$0, $repository, $remote, $fetchTarget, $authenticationGate), $commonIndicator);
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            singleRemoteResult = null;
        } else {
            singleRemoteResult = (SingleRemoteResult)result2.element;
        }
        return singleRemoteResult;
    }

    private static final void doFetch$lambda$10(ProgressIndicator $indicator, String line, Key outputType) {
        if ($indicator != null && Intrinsics.areEqual((Object)outputType, (Object)ProcessOutputTypes.STDERR)) {
            $indicator.setText2(line);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0015\u0010\u0016\u001a\u00020\u00132\u000b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019H\u0016J\u0019\u0010\u001a\u001a\u00020\u00152\u000f\b\u0002\u0010\u001b\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u001c\u0010\u001d\u001a\u00070\u0018\u00a2\u0006\u0002\b\u001e2\r\u0010\u001b\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "Lgit4idea/fetch/GitFetchResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "results", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsNotifier;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVcsNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "getResults", "()Ljava/util/Map;", "isFailed", "", "showNotification", "", "showNotificationIfFailed", "title", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "doShowNotification", "failureTitle", "throwExceptionIfFailed", "buildMessage", "Lorg/jetbrains/annotations/Nls;", "appendDetails", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "details", "Lcom/intellij/dvcs/MultiRootMessage;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$FetchResultImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,390:1\n1761#2,3:391\n1563#2:394\n1634#2,3:395\n504#3,7:398\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$FetchResultImpl\n*L\n323#1:391,3\n358#1:394\n358#1:395,3\n362#1:398,7\n*E\n"})
    private static final class FetchResultImpl
    implements GitFetchResult {
        @NotNull
        private final Project project;
        @NotNull
        private final VcsNotifier vcsNotifier;
        @NotNull
        private final Map<GitRepository, RepoResult> results;
        private final boolean isFailed;

        /*
         * WARNING - void declaration
         */
        public FetchResultImpl(@NotNull Project project, @NotNull VcsNotifier vcsNotifier, @NotNull Map<GitRepository, RepoResult> results) {
            boolean bl;
            boolean bl2;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)vcsNotifier, (String)"vcsNotifier");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                this.project = project;
                this.vcsNotifier = vcsNotifier;
                this.results = results;
                Iterable iterable = this.results.values();
                FetchResultImpl fetchResultImpl = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RepoResult it = (RepoResult)element$iv;
                        boolean bl3 = false;
                        if (!(!it.totallySuccessful())) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
            }
            fetchResultImpl.isFailed = bl = bl2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsNotifier getVcsNotifier() {
            return this.vcsNotifier;
        }

        @NotNull
        public final Map<GitRepository, RepoResult> getResults() {
            return this.results;
        }

        @Override
        public void showNotification() {
            FetchResultImpl.doShowNotification$default(this, null, 1, null);
        }

        @Override
        public boolean showNotificationIfFailed() {
            if (this.isFailed) {
                this.doShowNotification(null);
            }
            return !this.isFailed;
        }

        @Override
        public boolean showNotificationIfFailed(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            if (this.isFailed) {
                this.doShowNotification(title);
            }
            return !this.isFailed;
        }

        private final void doShowNotification(String failureTitle) {
            String string;
            NotificationType type;
            NotificationType notificationType = type = !this.isFailed ? NotificationType.INFORMATION : NotificationType.ERROR;
            if (!this.isFailed) {
                string = GitBundle.message((String)"notification.title.fetch.success", (Object[])new Object[0]);
            } else {
                string = failureTitle;
                if (string == null) {
                    String string2 = GitBundle.message((String)"notification.title.fetch.failure", (Object[])new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String title = string3;
            String message = this.buildMessage(failureTitle);
            Notification notification = VcsNotifier.standardNotification().createNotification(title, message, type);
            notification.setDisplayId(!this.isFailed ? "git.fetch.result" : "git.fetch.result.error");
            this.vcsNotifier.notify(notification);
        }

        static /* synthetic */ void doShowNotification$default(FetchResultImpl fetchResultImpl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            fetchResultImpl.doShowNotification(string);
        }

        @Override
        public void throwExceptionIfFailed() {
            if (this.isFailed) {
                throw new VcsException(this.buildMessage(null));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String buildMessage(String failureTitle) {
            GitRepository repo;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.results.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(gitRepository.getRoot());
            }
            List roots = (List)destination$iv$iv;
            MultiRootMessage errorMessage = new MultiRootMessage(this.project, (Collection)roots, true, false, 8, null);
            MultiRootMessage prunedRefs = new MultiRootMessage(this.project, (Collection)roots, false, false, 12, null);
            Iterator<Map.Entry<GitRepository, RepoResult>> $this$filterValues$iv = this.results;
            boolean entry = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
                RepoResult it = (RepoResult)entry2.getValue();
                boolean bl3 = false;
                if (!(!it.totallySuccessful())) continue;
                result$iv.put(entry2.getKey(), entry2.getValue());
            }
            Map failed = result$iv;
            for (Map.Entry entry3 : failed.entrySet()) {
                repo = (GitRepository)entry3.getKey();
                RepoResult result2 = (RepoResult)entry3.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                errorMessage.append((Object)virtualFile, result2.error());
            }
            for (Map.Entry<GitRepository, RepoResult> entry4 : this.results.entrySet()) {
                repo = entry4.getKey();
                RepoResult result2 = entry4.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                prunedRefs.append((Object)virtualFile, result2.prunedRefs());
            }
            HtmlBuilder sb = new HtmlBuilder();
            if (this.isFailed && failed.size() != roots.size() && !((Collection)failed.keySet()).isEmpty()) {
                String string = failureTitle;
                if (string == null) {
                    String string2 = GitBundle.message((String)"notification.title.fetch.failure", (Object[])new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
                sb.append((HtmlChunk)HtmlChunk.text((String)string).bold());
                sb.append(GitUtil.mention(failed.keySet()));
            }
            this.appendDetails(sb, errorMessage);
            this.appendDetails(sb, prunedRefs);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void appendDetails(HtmlBuilder sb, MultiRootMessage details) {
            String text2 = details.asString();
            if (((CharSequence)text2).length() > 0) {
                if (!sb.isEmpty()) {
                    sb.br();
                }
                sb.append(text2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "future", "Ljava/util/concurrent/Future;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/util/concurrent/Future;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getFuture", "()Ljava/util/concurrent/Future;", "intellij.vcs.git"})
    private static final class FetchTask {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final Future<SingleRemoteResult> future;

        public FetchTask(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull Future<SingleRemoteResult> future) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(future, (String)"future");
            this.repository = repository2;
            this.remote = remote;
            this.future = future;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final Future<SingleRemoteResult> getFuture() {
            return this.future;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eJ\u000b\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "", "results", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "<init>", "(Ljava/util/Map;)V", "getResults", "()Ljava/util/Map;", "totallySuccessful", "", "error", "", "Lorg/jetbrains/annotations/Nls;", "prunedRefs", "Lcom/intellij/openapi/util/NlsSafe;", "multiRemoteMessage", "Lcom/intellij/dvcs/MultiMessage;", "remoteInPrefix", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$RepoResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,390:1\n1740#2,3:391\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$RepoResult\n*L\n285#1:391,3\n*E\n"})
    private static final class RepoResult {
        @NotNull
        private final Map<GitRemote, SingleRemoteResult> results;

        public RepoResult(@NotNull Map<GitRemote, SingleRemoteResult> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.results = results;
        }

        @NotNull
        public final Map<GitRemote, SingleRemoteResult> getResults() {
            return this.results;
        }

        public final boolean totallySuccessful() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.results.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SingleRemoteResult it = (SingleRemoteResult)element$iv;
                        boolean bl2 = false;
                        if (it.success()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final String error() {
            MultiMessage<GitRemote> errorMessage = this.multiRemoteMessage(true);
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : this.results.entrySet()) {
                GitRemote remote = entry.getKey();
                SingleRemoteResult result2 = entry.getValue();
                if (result2.getError() == null) continue;
                errorMessage.append((Object)remote, result2.getError());
            }
            return errorMessage.asString();
        }

        @NotNull
        public final String prunedRefs() {
            MultiMessage<GitRemote> prunedRefs = this.multiRemoteMessage(false);
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : this.results.entrySet()) {
                GitRemote remote = entry.getKey();
                SingleRemoteResult result2 = entry.getValue();
                if (!(!((Collection)result2.getPrunedRefs()).isEmpty())) continue;
                prunedRefs.append((Object)remote, CollectionsKt.joinToString$default((Iterable)result2.getPrunedRefs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            return prunedRefs.asString();
        }

        private final MultiMessage<GitRemote> multiRemoteMessage(boolean remoteInPrefix) {
            return new MultiMessage((Collection)this.results.keySet(), (Function1)multiRemoteMessage.1.INSTANCE, (Function1)multiRemoteMessage.2.INSTANCE, remoteInPrefix, false, 16, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "error", "", "Lorg/jetbrains/annotations/Nls;", "prunedRefs", "", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;Ljava/util/List;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getError", "()Ljava/lang/String;", "getPrunedRefs", "()Ljava/util/List;", "success", "", "intellij.vcs.git"})
    private static final class SingleRemoteResult {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String error;
        @NotNull
        private final List<String> prunedRefs;

        public SingleRemoteResult(@NotNull GitRepository repository2, @NotNull GitRemote remote, @Nullable String error, @NotNull List<String> prunedRefs) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(prunedRefs, (String)"prunedRefs");
            this.repository = repository2;
            this.remote = remote;
            this.error = error;
            this.prunedRefs = prunedRefs;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<String> getPrunedRefs() {
            return this.prunedRefs;
        }

        public final boolean success() {
            return this.error == null;
        }
    }
}

