/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.bun;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.bun.BunDebugAdapter;
import com.intellij.javascript.bun.BunDebugProcess;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointType;
import com.intellij.javascript.debugger.dap.launcher.LauncherKt;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.dap.DapBreakpointsDescription;
import com.intellij.platform.dap.DapDebugSession;
import com.intellij.platform.dap.DapExceptionBreakpoint;
import com.intellij.platform.dap.DapExceptionInfo;
import com.intellij.platform.dap.DapStartRequest;
import com.intellij.platform.dap.DebugAdapterDescriptor;
import com.intellij.platform.dap.DebugAdapterSupportProvider;
import com.intellij.platform.dap.connection.DebugAdapterHandle;
import com.intellij.platform.dap.xdebugger.DapXDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/bun/BunDebugAdapterSupportProvider;", "Lcom/intellij/platform/dap/DebugAdapterSupportProvider;", "Lcom/intellij/javascript/bun/BunDebugAdapter;", "<init>", "()V", "adapterId", "getAdapterId", "()Lcom/intellij/javascript/bun/BunDebugAdapter;", "createDebugAdapterDescriptor", "Lcom/intellij/platform/dap/DebugAdapterDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getDebugAdapterFile", "Ljava/nio/file/Path;", "Companion", "intellij.javascript.bun"})
final class BunDebugAdapterSupportProvider
implements DebugAdapterSupportProvider<BunDebugAdapter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BunDebugAdapter adapterId = BunDebugAdapter.INSTANCE;
    @NotNull
    public static final String DEBUG_ADAPTER_FILE_NAME = "debug-adapter/bun-debug-adapter-server.js";

    @NotNull
    public BunDebugAdapter getAdapterId() {
        return this.adapterId;
    }

    @NotNull
    public DebugAdapterDescriptor<BunDebugAdapter> createDebugAdapterDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (DebugAdapterDescriptor)new DebugAdapterDescriptor<BunDebugAdapter>(this, project){
            private final BunDebugAdapter id;
            private final DapBreakpointsDescription breakpointsDescription;
            final /* synthetic */ BunDebugAdapterSupportProvider this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.id = BunDebugAdapter.INSTANCE;
                Class<JavaScriptBreakpointType> clazz = JavaScriptBreakpointType.class;
                Class<JavaScriptExceptionBreakpointType> clazz2 = JavaScriptExceptionBreakpointType.class;
                this.breakpointsDescription = new DapBreakpointsDescription(clazz, clazz2){

                    public boolean doesExceptionMatchBreakpoint(DapExceptionInfo exceptionInfo, DapExceptionBreakpoint breakpoint) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)exceptionInfo, (String)"exceptionInfo");
                        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
                        XBreakpoint ideBreakpoint = breakpoint.getIdeBreakpoint();
                        if (!(ideBreakpoint.getType() instanceof JavaScriptExceptionBreakpointType)) {
                            return false;
                        }
                        XBreakpointProperties xBreakpointProperties = ideBreakpoint.getProperties();
                        JavaScriptExceptionBreakpointProperties javaScriptExceptionBreakpointProperties = xBreakpointProperties instanceof JavaScriptExceptionBreakpointProperties ? (JavaScriptExceptionBreakpointProperties)xBreakpointProperties : null;
                        if (javaScriptExceptionBreakpointProperties == null) {
                            return false;
                        }
                        JavaScriptExceptionBreakpointProperties exceptionProperties = javaScriptExceptionBreakpointProperties;
                        return exceptionProperties.getExceptionName() == null || Intrinsics.areEqual((Object)exceptionProperties.getExceptionName(), (object = exceptionInfo.getRawDetails()) != null && (object = object.getFullTypeName()) != null ? StringsKt.removeSurrounding((String)object, (CharSequence)"\"") : null);
                    }
                };
            }

            public BunDebugAdapter getId() {
                return this.id;
            }

            public Object launchDebugAdapter(ExecutionEnvironment environment, ExecutionResult executionResult, String sessionId, Continuation<? super DebugAdapterHandle> $completion) {
                List additionalParams;
                int it = Registry.Companion.get("bun.dap.debug.port").asInteger();
                boolean bl = false;
                Integer debugPort = it < 0 ? null : Boxing.boxInt((int)it);
                String debugAdapterExecutable = ((Object)BunDebugAdapterSupportProvider.access$getDebugAdapterFile(this.this$0)).toString();
                String logPath = Registry.Companion.get("bun.dap.log.path").asString();
                List list = additionalParams = ((CharSequence)logPath).length() > 0 ? CollectionsKt.listOf((Object)("--logPath=" + FileUtil.expandUserHome((String)logPath))) : CollectionsKt.emptyList();
                Map map = debugPort != null || ((CharSequence)logPath).length() > 0 ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"NODE_ENV", (Object)"development")) : MapsKt.emptyMap();
                return LauncherKt.NodeJsBasedDebugAdapter((Project)this.$project, (String)debugAdapterExecutable, (List)additionalParams, (Map)map, (Integer)debugPort);
            }

            public DapBreakpointsDescription getBreakpointsDescription() {
                return this.breakpointsDescription;
            }

            public DapXDebugProcess createXDebugProcess(XDebugSession session, DapDebugSession dapDebugSession, CoroutineScope xDebugProcessScope, CoroutineScope globalScope, DebugAdapterDescriptor<?> debugAdapterDescriptor, ExecutionEnvironment executionEnvironment, ExecutionResult executionResult, DapStartRequest startRequestType, Map<String, ? extends Object> startRequestArguments) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)dapDebugSession, (String)"dapDebugSession");
                Intrinsics.checkNotNullParameter((Object)xDebugProcessScope, (String)"xDebugProcessScope");
                Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
                Intrinsics.checkNotNullParameter(debugAdapterDescriptor, (String)"debugAdapterDescriptor");
                Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
                Intrinsics.checkNotNullParameter((Object)startRequestType, (String)"startRequestType");
                Intrinsics.checkNotNullParameter(startRequestArguments, (String)"startRequestArguments");
                return new BunDebugProcess(session, dapDebugSession, xDebugProcessScope, globalScope, debugAdapterDescriptor, executionEnvironment, executionResult, startRequestType, startRequestArguments);
            }
        };
    }

    private final Path getDebugAdapterFile() {
        try {
            return JSPluginPathManager.getPluginResource(this.getClass(), (String)DEBUG_ADAPTER_FILE_NAME, (String)"bun/debug-adapter/dist");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final /* synthetic */ Path access$getDebugAdapterFile(BunDebugAdapterSupportProvider $this) {
        return $this.getDebugAdapterFile();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/bun/BunDebugAdapterSupportProvider$Companion;", "", "<init>", "()V", "DEBUG_ADAPTER_FILE_NAME", "", "intellij.javascript.bun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

