/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol.commands;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenRequestArgs;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptOpenEditorCommand
extends TypeScriptCommandWithArguments<TypeScriptFileWithConfigArgs> {
    public static final String COMMAND_OPEN = "open";
    @NotNull
    private final VirtualFile myFile;
    private final long myTimestamp;
    private final long myContentLength;
    private final int myLastLineStartOffset;
    private final int myLineCount;

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public long getContentLength() {
        return this.myContentLength;
    }

    public int getLineCount() {
        return this.myLineCount;
    }

    public int getLastLineStartOffset() {
        return this.myLastLineStartOffset;
    }

    /*
     * WARNING - void declaration
     */
    public TypeScriptOpenEditorCommand(@NotNull VirtualFile file, long timestamp, long contentLength, int lineCount, int lastLineStartOffset, @Nullable CharSequence charSequence, @Nullable String string) {
        void projectFileName;
        void content;
        if (file == null) {
            TypeScriptOpenEditorCommand.$$$reportNull$$$0(0);
        }
        super(COMMAND_OPEN, new TypeScriptOpenRequestArgs(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file), content == null ? null : content.toString(), (String)projectFileName));
        this.myFile = file;
        this.myTimestamp = timestamp;
        this.myContentLength = contentLength;
        this.myLineCount = lineCount;
        this.myLastLineStartOffset = lastLineStartOffset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            TypeScriptOpenEditorCommand.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public String getPresentableText(@NotNull Project project) {
        if (project == null) {
            TypeScriptOpenEditorCommand.$$$reportNull$$$0(2);
        }
        String file = TypeScriptLanguageServiceUtil.getRelativePath(project, LocalFilePath.getPath(((TypeScriptFileWithConfigArgs)this.arguments).file));
        return JavaScriptBundle.message("typescript.language.service.compile.project.open.file", StringUtil.notNullize((String)file));
    }

    @Override
    public boolean isResponseExpected() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptOpenEditorCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptOpenEditorCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

