/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSSuperMemberUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureHandler
implements ChangeSignatureHandler {
    private final BiConsumer<? super JSFunction, ? super PsiElement> myRefactoringHandler;

    public JSChangeSignatureHandler(BiConsumer<? super JSFunction, ? super PsiElement> refactoringHandler) {
        this.myRefactoringHandler = refactoringHandler;
    }

    public JSChangeSignatureHandler() {
        this((function, context2) -> new JSChangeSignatureDialog((JSFunction)function, false, (PsiElement)context2).show());
    }

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element2) {
        PsiElement resolved;
        ES6ImportedExportedDefaultBinding importedBinding;
        PsiElement resolved2;
        ASTNode nameIdentifier;
        if (element2 == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, JSParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class);
        }
        JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class);
        if (parentFunction != null && PsiTreeUtil.isAncestor((PsiElement)parentFunction.getNameIdentifier(), (PsiElement)element2, (boolean)false)) {
            return parentFunction;
        }
        JSNamedElement parentVar = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSFieldVariable.class, TypeScriptPropertySignature.class});
        if (parentVar != null && PsiTreeUtil.isAncestor((PsiElement)parentVar.getNameIdentifier(), (PsiElement)element2, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentVar, JSFunction.class);
        }
        JSAssignmentExpression parentAssignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSAssignmentExpression.class);
        if (parentAssignment != null && parentAssignment.getLOperand() instanceof JSDefinitionExpression && PsiTreeUtil.isAncestor((PsiElement)parentAssignment.getLOperand(), (PsiElement)element2, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentAssignment, JSFunctionExpression.class);
        }
        JSProperty parentProperty = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JSProperty.class);
        if (parentProperty != null && parentProperty.getParent() instanceof JSObjectLiteralExpression && (nameIdentifier = parentProperty.findNameIdentifier()) != null && PsiTreeUtil.isAncestor((PsiElement)nameIdentifier.getPsi(), (PsiElement)element2, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentProperty, JSFunctionExpression.class);
        }
        JSCallExpression expression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSCallExpression.class);
        if (expression != null) {
            JSClass superClass;
            JSClass clazz;
            JSExpression methodExpression = expression.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                resolved2 = JSChangeSignatureHandler.fromResolveResult(((JSReferenceExpression)methodExpression).resolve());
                if (resolved2 != null) {
                    return resolved2;
                }
            } else if (methodExpression instanceof JSSuperExpression && (clazz = JSResolveUtil.getClassOfContext((PsiElement)methodExpression)) != null && (superClass = (JSClass)ArrayUtil.getFirstElement((Object[])clazz.getSuperClasses())) != null) {
                return superClass.getConstructor();
            }
        }
        if ((importedBinding = (ES6ImportedExportedDefaultBinding)PsiTreeUtil.getParentOfType((PsiElement)element2, ES6ImportedExportedDefaultBinding.class)) != null && (resolved2 = JSChangeSignatureHandler.fromResolveResult((PsiElement)importedBinding)) != null) {
            return resolved2;
        }
        ES6ImportExportSpecifier specifier = (ES6ImportExportSpecifier)PsiTreeUtil.getParentOfType((PsiElement)element2, ES6ImportExportSpecifier.class);
        if (specifier != null && (resolved = JSChangeSignatureHandler.fromResolveResult(specifier.resolve())) != null) {
            return resolved;
        }
        return element2;
    }

    @Nullable
    private static PsiElement fromResolveResult(@Nullable PsiElement resolved) {
        if (resolved != null) {
            resolved = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolved);
        }
        if (resolved instanceof JSFunction) {
            return resolved;
        }
        if (resolved instanceof JSVariable) {
            return PsiTreeUtil.getChildOfType((PsiElement)resolved, JSFunctionExpression.class);
        }
        if (resolved instanceof JSDefinitionExpression && resolved.getParent() instanceof JSAssignmentExpression) {
            return PsiTreeUtil.getChildOfType((PsiElement)resolved.getParent(), JSFunctionExpression.class);
        }
        if (resolved instanceof JSProperty && resolved.getParent() instanceof JSObjectLiteralExpression) {
            return PsiTreeUtil.getChildOfType((PsiElement)resolved, JSFunctionExpression.class);
        }
        if (resolved instanceof TypeScriptPropertySignature) {
            return PsiTreeUtil.getChildOfType((PsiElement)resolved, JSFunction.class);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        throw new RuntimeException("This is never invoked");
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element2 = elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!JSRefactoringUtil.checkReadOnlyStatus(element2, editor, JSChangeSignatureHandler.getRefactoringName())) {
            return;
        }
        JSFunctionItem functionItem = JSChangeSignatureHandler.getFunction(element2);
        if (!(functionItem instanceof JSFunction)) {
            CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JSChangeSignatureHandler.getCannotRefactorReason()), (String)JSChangeSignatureHandler.getRefactoringName(), null);
            return;
        }
        if (!JSChangeSignatureHandler.canRefactorFunction(functionItem, editor)) {
            return;
        }
        JSQualifiedNamedElement namedElement = JSChangeSignatureUtil.getMemberFromFunction((JSFunction)functionItem);
        PsiElement contextElement = JSChangeSignatureHandler.getContextElement(dataContext);
        this.invoke(namedElement, contextElement != null ? contextElement : element2);
    }

    public static JSFunctionItem getFunction(PsiElement element2) {
        return element2 instanceof JSFunction ? (JSFunction)element2 : JSPsiImplUtils.calculatePossibleFunction(element2, null, false);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return null;
    }

    public static boolean canRefactorFunction(@NotNull JSFunctionItem element2, Editor editor) {
        if (element2 == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (element2 instanceof JSFunctionExpression) {
            boolean result2 = JSChangeSignatureHandler.canRefactorFunctionExpression((JSFunctionExpression)element2, true);
            if (!result2) {
                CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JavaScriptBundle.message("cannot.refactor.anonymous.function", new Object[0])), (String)JSChangeSignatureHandler.getRefactoringName(), null);
            }
            return result2;
        }
        return element2 instanceof JSFunction;
    }

    public static boolean canRefactorFunctionExpression(JSFunctionExpression element2, boolean acceptEventListenerCall) {
        PsiElement parent = element2.getParent();
        boolean isDefaultExport = parent instanceof ES6ExportDefaultAssignment;
        if (parent instanceof JSVariable || parent instanceof JSProperty || isDefaultExport || parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getLOperand() instanceof JSDefinitionExpression) {
            return ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach(psiReference -> {
                if (!(psiReference instanceof JSReferenceExpression)) {
                    return true;
                }
                if (JSResolveUtil.isSelfReference(parent, (PsiElement)psiReference)) {
                    return true;
                }
                PsiElement refParent = ((JSReferenceExpression)psiReference).getParent();
                if (JSChangeSignatureHandler.isEventListenerCallArgument(refParent)) {
                    return true;
                }
                if (refParent instanceof ES6ImportSpecifier || refParent instanceof ES6ExportDefaultAssignment || refParent instanceof ES6ImportedExportedDefaultBinding) {
                    return true;
                }
                return refParent instanceof JSCallExpression;
            });
        }
        return acceptEventListenerCall && JSChangeSignatureHandler.isEventListenerCallArgument(parent);
    }

    private static boolean isEventListenerCallArgument(PsiElement element2) {
        return element2 instanceof JSArgumentList && element2.getParent() instanceof JSCallExpression && JSResolveUtil.isEventListenerCall((JSCallExpression)element2.getParent());
    }

    @Nullable
    private static PsiElement getContextElement(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    private void invoke(@NotNull JSQualifiedNamedElement member, @Nullable PsiElement context2) {
        JSQualifiedNamedElement superMember;
        JSFunction superFunction;
        if (member == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if ((superFunction = JSChangeSignatureUtil.getFunctionFromMember((PsiElement)(superMember = JSSuperMemberUtil.checkSuperMember(member, JSChangeSignatureHandler.getRefactoringName(), RefactoringBundle.message((String)"to.refactor"))))) != null) {
            this.myRefactoringHandler.accept(superFunction, (PsiElement)context2);
        }
    }

    @NlsContexts.DialogTitle
    @NotNull
    private static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"changeSignature.refactoring.name");
        if (string == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getCannotRefactorReason() {
        String string = JavaScriptBundle.message("error.wrong.caret.position.method.name", new Object[0]);
        if (string == null) {
            JSChangeSignatureHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRefactorReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTargetMember";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRefactorFunction";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

