/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTagsKt;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTagsKt;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagInternalDefinition;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagSymbol;
import com.intellij.model.Pointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolQualifiedKind;
import com.intellij.polySymbols.context.PolyContext;
import com.intellij.polySymbols.query.PolySymbolQueryScopeContributor;
import com.intellij.polySymbols.query.PolySymbolQueryScopeProviderRegistrar;
import com.intellij.polySymbols.utils.PolySymbolScopeWithCache;
import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/psi/jsdoc/impl/JSDocSymbolQueryScopeContributor;", "Lcom/intellij/polySymbols/query/PolySymbolQueryScopeContributor;", "<init>", "()V", "registerProviders", "", "registrar", "Lcom/intellij/polySymbols/query/PolySymbolQueryScopeProviderRegistrar;", "detectJSDocDialect", "Lcom/intellij/lang/javascript/psi/jsdoc/JSDocBlockTags$JSDocDialect;", "location", "Lcom/intellij/psi/PsiElement;", "JSDocTagsScope", "intellij.javascript.psi.impl"})
public final class JSDocSymbolQueryScopeContributor
implements PolySymbolQueryScopeContributor {
    public void registerProviders(@NotNull PolySymbolQueryScopeProviderRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Class[] classArray = new Class[]{JSDocTag.class, JSDocInlineTag.class};
        registrar.forPsiLocations(classArray).contributeScopeProvider(arg_0 -> JSDocSymbolQueryScopeContributor.registerProviders$lambda$0(this, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JSDocBlockTags.JSDocDialect detectJSDocDialect(PsiElement location) {
        JSDocBlockTags.JSDocDialect jSDocDialect;
        if (DialectDetector.isActionScript(location)) {
            jSDocDialect = JSDocBlockTags.JSDocDialect.ASDoc;
            return jSDocDialect;
        }
        String string = PolyContext.Companion.get("jsdoc-dialect", location);
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 110654041: {
                    if (!string.equals("tsdoc")) break;
                    n = 1;
                    break;
                }
                case 418264509: {
                    if (!string.equals("jsdoc-closure")) break;
                    n = 2;
                    break;
                }
                case 1882069443: {
                    if (!string.equals("jsdoc-typescript")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    jSDocDialect = JSDocBlockTags.JSDocDialect.TSDoc;
                    return jSDocDialect;
                }
                case 2: {
                    jSDocDialect = JSDocBlockTags.JSDocDialect.JSDocClosure;
                    return jSDocDialect;
                }
                case 3: {
                    jSDocDialect = JSDocBlockTags.JSDocDialect.JSDocTypeScript;
                    return jSDocDialect;
                }
            }
        }
        jSDocDialect = JSDocBlockTags.JSDocDialect.JSDoc;
        return jSDocDialect;
    }

    private static final List registerProviders$lambda$0(JSDocSymbolQueryScopeContributor this$0, JSElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = it.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return CollectionsKt.listOf((Object)((Object)new JSDocTagsScope(project, this$0.detectJSDocDialect((PsiElement)it))));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/psi/jsdoc/impl/JSDocSymbolQueryScopeContributor$JSDocTagsScope;", "Lcom/intellij/polySymbols/utils/PolySymbolScopeWithCache;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/lang/javascript/psi/jsdoc/JSDocBlockTags$JSDocDialect;", "project", "dialect", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/psi/jsdoc/JSDocBlockTags$JSDocDialect;)V", "initialize", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/polySymbols/PolySymbol;", "cacheDependencies", "", "", "provides", "", "qualifiedKind", "Lcom/intellij/polySymbols/PolySymbolQualifiedKind;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSDocSymbolQueryScopeContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDocSymbolQueryScopeContributor.kt\ncom/intellij/lang/javascript/psi/jsdoc/impl/JSDocSymbolQueryScopeContributor$JSDocTagsScope\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n1321#2:75\n1322#2:86\n536#3:76\n521#3,6:77\n216#4:83\n217#4:85\n24#5:84\n*S KotlinDebug\n*F\n+ 1 JSDocSymbolQueryScopeContributor.kt\ncom/intellij/lang/javascript/psi/jsdoc/impl/JSDocSymbolQueryScopeContributor$JSDocTagsScope\n*L\n50#1:75\n50#1:86\n52#1:76\n52#1:77,6\n53#1:83\n53#1:85\n58#1:84\n*E\n"})
    private static final class JSDocTagsScope
    extends PolySymbolScopeWithCache<Project, JSDocBlockTags.JSDocDialect> {
        public JSDocTagsScope(@NotNull Project project, @NotNull JSDocBlockTags.JSDocDialect dialect) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
            super(null, project, (UserDataHolder)project, (Object)dialect);
        }

        /*
         * WARNING - void declaration
         */
        protected void initialize(@NotNull Function1<? super PolySymbol, Unit> consumer, @NotNull Set<Object> cacheDependencies) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter(cacheDependencies, (String)"cacheDependencies");
            Function1 matchDialect = JSDocBlockTags.JSDocDialect.ASDoc == this.getKey() ? JSDocTagsScope::initialize$lambda$0 : JSDocTagsScope::initialize$lambda$1;
            Sequence sequence = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)JSDocBlockTags.getEntries())), (Iterable)((Iterable)JSDocInlineTags.getEntries()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Map $this$filter$iv;
                JSDocTagInternalDefinition definition = (JSDocTagInternalDefinition)element$iv;
                boolean bl = false;
                Map map2 = MapsKt.plus(definition.getSynonyms(), (Pair)TuplesKt.to((Object)definition.getName(), definition.getDialects()));
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!((Boolean)matchDialect.invoke(it.getValue())).booleanValue()) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                boolean $i$f$forEach2 = false;
                iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry it = element$iv2 = iterator.next();
                    boolean bl3 = false;
                    try {
                        Project project = this.getProject();
                        Object k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        consumer.invoke((Object)new JSDocTagSymbol(project, (String)k, definition, (JSDocBlockTags.JSDocDialect)((Object)this.getKey())));
                    }
                    catch (RuntimeException e) {
                        JSDocTagsScope $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(JSDocTagsScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Error for " + it.getKey(), (Throwable)e);
                    }
                }
            }
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"NEVER_CHANGED");
            cacheDependencies.add(modificationTracker);
        }

        protected boolean provides(@NotNull PolySymbolQualifiedKind qualifiedKind) {
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            return Intrinsics.areEqual((Object)qualifiedKind, (Object)JSDocBlockTagsKt.getJSDOC_BLOCK_TAGS()) || Intrinsics.areEqual((Object)qualifiedKind, (Object)JSDocInlineTagsKt.getJSDOC_INLINE_TAGS());
        }

        @NotNull
        public Pointer<JSDocTagsScope> createPointer() {
            Pointer pointer = Pointer.hardPointer((Object)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
            return pointer;
        }

        private static final boolean initialize$lambda$0(Set it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.contains((Object)JSDocBlockTags.JSDocDialect.ASDoc);
        }

        private static final boolean initialize$lambda$1(Set it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !it.contains((Object)JSDocBlockTags.JSDocDialect.ASDoc) || it.size() > 1;
        }
    }
}

