/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ComputedNameStub;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ComputedNameImpl
extends JSStubElementImpl<ES6ComputedNameStub>
implements ES6ComputedName {
    public ES6ComputedNameImpl(ASTNode node) {
        super(node);
    }

    public ES6ComputedNameImpl(ES6ComputedNameStub element2) {
        super(element2, JSStubElementTypes.COMPUTED_NAME);
    }

    @Override
    @Nullable
    public JSExpression getExpression() {
        ASTNode next;
        ASTNode lBracket = this.getNode().findChildByType(JSTokenTypes.LBRACKET);
        if (lBracket != null && (next = lBracket.getTreeNext()) != null && JSElementTypes.EXPRESSIONS.contains(next.getElementType())) {
            return (JSExpression)next.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public String getExpressionAsPropertyName() {
        ES6ComputedNameStub stub = (ES6ComputedNameStub)this.getGreenStub();
        if (stub != null) {
            return stub.getExpressionAsPropertyName();
        }
        JSExpression expr = this.getExpression();
        if (JSPsiImplUtils.isSymbolRef(expr)) {
            return "[" + expr.getText() + "]";
        }
        if (expr instanceof JSLiteralExpression) {
            String value = ((JSLiteralExpression)expr).getStringValue();
            if (value != null) {
                return value;
            }
            if (((JSLiteralExpression)expr).isNumericLiteral()) {
                return expr.getText();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getExpressionAsReferenceName() {
        ES6ComputedNameStub stub = (ES6ComputedNameStub)this.getGreenStub();
        if (stub != null) {
            return stub.getExpressionAsReferenceName();
        }
        JSExpression expr = this.getExpression();
        if (JSSymbolUtil.isAccurateReferenceExpression(expr)) {
            return expr.getText();
        }
        return null;
    }

    @Override
    public boolean isExpressionNumericLiteral() {
        JSLiteralExpression literalExpression;
        ES6ComputedNameStub greenStub = (ES6ComputedNameStub)this.getGreenStub();
        if (greenStub != null) {
            return greenStub.isExpressionNumericLiteral();
        }
        JSExpression jSExpression = this.getExpression();
        return jSExpression instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)jSExpression).isNumericLiteral();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ES6ComputedNameImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ComputedName(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ComputedNameImpl", "accept"));
    }
}

