/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectionUtilsKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL_ID__TEST_SUITE = "suite";
    public static final String PROTOCOL_ID__TEST = "test";
    private final boolean myLocationUrlStartsWithTestFilePath;
    @NotNull
    private final JsTestFrameworkDetector myTestFrameworkDetector;

    public JSTestLocationProvider(@NotNull JsTestFrameworkDetector testFrameworkDetector) {
        if (testFrameworkDetector == null) {
            JSTestLocationProvider.$$$reportNull$$$0(0);
        }
        this(false, testFrameworkDetector);
    }

    public JSTestLocationProvider(boolean locationUrlStartsWithTestFilePath, @NotNull JsTestFrameworkDetector testFrameworkDetector) {
        if (testFrameworkDetector == null) {
            JSTestLocationProvider.$$$reportNull$$$0(1);
        }
        this.myLocationUrlStartsWithTestFilePath = locationUrlStartsWithTestFilePath;
        this.myTestFrameworkDetector = testFrameworkDetector;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path2, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (protocol == null) {
            JSTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            JSTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            JSTestLocationProvider.$$$reportNull$$$0(5);
        }
        if ("file".equals(protocol)) {
            List list = FileUrlProvider.INSTANCE.getLocation(protocol, path2, project, scope2);
            if (list == null) {
                JSTestLocationProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        Location<?> location = PROTOCOL_ID__TEST_SUITE.equals(protocol) || PROTOCOL_ID__TEST.equals(protocol) ? this.getTestLocation(project, path2, PROTOCOL_ID__TEST_SUITE.equals(protocol)) : null;
        if (location != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                JSTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            JSTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private Location<?> getTestLocation(@NotNull Project project, @NotNull String locationData, boolean suite) {
        List<String> path2;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (locationData == null) {
            JSTestLocationProvider.$$$reportNull$$$0(10);
        }
        if ((path2 = EscapeUtils.split(locationData, '.')).isEmpty()) {
            return null;
        }
        String testFilePath = null;
        List<String> names = path2;
        if (this.myLocationUrlStartsWithTestFilePath) {
            testFilePath = (String)ContainerUtil.getFirstItem(path2);
            names = path2.subList(1, path2.size());
        }
        if (names.isEmpty()) {
            return null;
        }
        PsiElement element2 = this.findTestElement(project, new JsTestSelector(names, suite), testFilePath);
        return element2 != null ? PsiLocation.fromPsiElement((PsiElement)element2) : null;
    }

    @Nullable
    private static VirtualFile findSuitableFile(@NotNull Project project, @Nullable String testFilePath) {
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)testFilePath)) {
            List files = TestsLocationProviderUtil.findSuitableFilesFor((String)testFilePath, (Project)project);
            return (VirtualFile)ContainerUtil.getFirstItem((List)files);
        }
        return null;
    }

    @Nullable
    private PsiElement findTestElement(@NotNull Project project, @NotNull JsTestSelector testSelector, @Nullable String preferredTestFilePath) {
        PsiElement element2;
        VirtualFile testFile;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(12);
        }
        if (testSelector == null) {
            JSTestLocationProvider.$$$reportNull$$$0(13);
        }
        if ((testFile = JSTestLocationProvider.findSuitableFile(project, preferredTestFilePath)) != null && (element2 = JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestFile(project, this.myTestFrameworkDetector, testSelector, testFile)) != null) {
            return element2;
        }
        if (this.myLocationUrlStartsWithTestFilePath) {
            return null;
        }
        return JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestNamesIndexes(project, this.myTestFrameworkDetector, testSelector);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/navigation/JSTestLocationProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/navigation/JSTestLocationProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTestElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

