/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.CollectJasmineStructureElementPathsKt;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteNode;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructure
extends AbstractTestFileStructure {
    private final JasmineSuiteNode myNode;
    private final Map<PsiElement, AbstractJasmineElement> myLeafElementToInfoMap;
    @Nullable
    Set<String> elementPathsCache;
    @Nullable
    String lastElementsPathsDelimiterCache;

    public JasmineFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JasmineFileStructure.$$$reportNull$$$0(0);
        }
        super(jsFile);
        this.myNode = new JasmineSuiteNode();
        this.myLeafElementToInfoMap = new IdentityHashMap<PsiElement, AbstractJasmineElement>();
        this.elementPathsCache = null;
        this.lastElementsPathsDelimiterCache = null;
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.myNode.getChildSuites();
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasJasmineSymbols();
    }

    public void addSuiteStructure(@NotNull JasmineSuiteStructure suiteStructure) {
        if (suiteStructure == null) {
            JasmineFileStructure.$$$reportNull$$$0(2);
        }
        this.myNode.addChild(suiteStructure);
    }

    public void addSpecStructure(@NotNull JasmineSpecStructure spec) {
        if (spec == null) {
            JasmineFileStructure.$$$reportNull$$$0(3);
        }
        this.myNode.addChild(spec);
    }

    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        List<AbstractJasmineElement> list = this.myNode.getChildren();
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getSpecs() {
        List<JasmineSpecStructure> list = this.myNode.getChildSpecs();
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean hasJasmineSymbols() {
        return !this.getSuites().isEmpty() || !this.getSpecs().isEmpty();
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.myNode.getChildSuites()) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return inner;
        }
        return null;
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSpecStructure specChild : this.getSpecs()) {
            TextRange specTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(specTextRange, offset)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteStructure : this.getSuites()) {
            JasmineSpecStructure specStructure = suiteStructure.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineFileStructure.$$$reportNull$$$0(6);
        }
        for (JasmineSuiteStructure suiteStructure : this.getSuites()) {
            AbstractJasmineElement result2 = suiteStructure.findJasmineElement(textRange);
            if (result2 == null) continue;
            return result2;
        }
        for (JasmineSpecStructure spec : this.getSpecs()) {
            TextRange callTextRange = spec.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return spec;
        }
        return null;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineFileStructure.$$$reportNull$$$0(7);
        }
        return JasmineFileStructure.toTestElementPath(this.findJasmineElement(textRange));
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull PsiElement testIdentifierLeafElement) {
        if (testIdentifierLeafElement == null) {
            JasmineFileStructure.$$$reportNull$$$0(8);
        }
        return JasmineFileStructure.toTestElementPath(this.myLeafElementToInfoMap.get(testIdentifierLeafElement));
    }

    public void forEach(@Nullable Consumer<JasmineSuiteStructure> suiteConsumer, @Nullable Consumer<JasmineSpecStructure> specConsumer) {
        this.myNode.iterateChildrenRecursively(suiteConsumer, specConsumer);
    }

    @Nullable
    private static JsTestElementPath toTestElementPath(@Nullable AbstractJasmineElement element2) {
        JSCallExpression psiElement;
        JasmineSuiteStructure suiteStructure;
        if (element2 == null) {
            return null;
        }
        String specName = null;
        if (element2 instanceof JasmineSuiteStructure) {
            suiteStructure = (JasmineSuiteStructure)element2;
            psiElement = suiteStructure.getEnclosingCallExpression();
        } else {
            JasmineSpecStructure specStructure = (JasmineSpecStructure)element2;
            suiteStructure = (JasmineSuiteStructure)element2.getParent();
            specName = element2.getName();
            psiElement = specStructure.getEnclosingCallExpression();
        }
        SmartList suites = new SmartList();
        while (suiteStructure != null) {
            suites.add(suiteStructure.getName());
            suiteStructure = (JasmineSuiteStructure)suiteStructure.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath((List<String>)suites, specName, (PsiElement)psiElement);
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String specName) {
        AbstractJasmineElement element2;
        if (suiteNames == null) {
            JasmineFileStructure.$$$reportNull$$$0(9);
        }
        return (element2 = this.findJasmineElement(suiteNames, specName)) != null ? element2.getNavigationElement() : null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull JsTestSelector testSelector) {
        if (testSelector == null) {
            JasmineFileStructure.$$$reportNull$$$0(10);
        }
        return this.findPsiElement(testSelector.getSuitNames(), testSelector.getTestName());
    }

    @Nullable
    public AbstractJasmineElement findStructureElement(@NotNull JsTestSelector testSelector) {
        if (testSelector == null) {
            JasmineFileStructure.$$$reportNull$$$0(11);
        }
        return this.findJasmineElement(testSelector.getSuitNames(), testSelector.getTestName());
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull List<String> suiteNames, @Nullable String specName) {
        JasmineSuiteStructure suite;
        if (suiteNames == null) {
            JasmineFileStructure.$$$reportNull$$$0(12);
        }
        if (suiteNames.isEmpty() && specName == null) {
            return null;
        }
        JasmineSuiteNode node = this.myNode;
        for (int i = 0; i < suiteNames.size() - 1; ++i) {
            suite = node.findChildSuiteByName(suiteNames.get(i));
            if (suite == null) {
                return null;
            }
            node = suite.getNode();
        }
        String lastSuiteName = (String)ContainerUtil.getLastItem(suiteNames);
        if (lastSuiteName != null) {
            suite = node.findChildSuiteByName(lastSuiteName);
            if (suite != null) {
                node = suite.getNode();
            }
            if (specName == null) {
                return suite != null ? suite : node.findChildSpecByName(lastSuiteName);
            }
        }
        return specName != null ? node.findChildSpecByName(specName) : null;
    }

    void postProcess() {
        this.myNode.postProcess();
        this.myNode.iterateChildrenRecursively(suite -> this.register(suite.getEnclosingCallExpression(), (AbstractJasmineElement)suite), spec -> this.register(spec.getEnclosingCallExpression(), (AbstractJasmineElement)spec));
    }

    private void register(@NotNull JSCallExpression callExpression, @NotNull AbstractJasmineElement element2) {
        JSReferenceExpression referenceExpression;
        PsiElement identifierLeafElement;
        if (callExpression == null) {
            JasmineFileStructure.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            JasmineFileStructure.$$$reportNull$$$0(14);
        }
        PsiElement psiElement = identifierLeafElement = (referenceExpression = JasmineFileStructureBuilder.getMethodReferenceExpression(callExpression)) != null ? referenceExpression.getReferenceNameElement() : null;
        if (identifierLeafElement != null) {
            this.myLeafElementToInfoMap.put(identifierLeafElement, element2);
        }
    }

    @NotNull
    public Set<String> collectElementPaths(@NotNull String elementsPathsDelimiter) {
        if (elementsPathsDelimiter == null) {
            JasmineFileStructure.$$$reportNull$$$0(15);
        }
        if (this.elementPathsCache == null || this.lastElementsPathsDelimiterCache == null || !this.lastElementsPathsDelimiterCache.equals(elementsPathsDelimiter)) {
            this.lastElementsPathsDelimiterCache = elementsPathsDelimiter;
            this.elementPathsCache = CollectJasmineStructureElementPathsKt.collectJasmineStructureElementPaths(this, elementsPathsDelimiter);
        }
        Set<String> set = this.elementPathsCache;
        if (set == null) {
            JasmineFileStructure.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifierLeafElement";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSelector";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsPathsDelimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElementPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSuiteStructure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSpecStructure";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findStructureElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectElementPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 16 -> new IllegalStateException(string);
        };
    }
}

