/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.actions.HttpClientActionsUsage;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.FileTypeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestInvalidLogFileException
extends Exception {
    private final ProblemFix myProblemFix;
    private final HttpClientActionsUsage.ProblemType myProblemType;

    public HttpRequestInvalidLogFileException() {
        this(RestClientBundle.message("http.request.show.log.file.action.failed", new Object[0]), null, HttpClientActionsUsage.ProblemType.GENERAL);
    }

    private HttpRequestInvalidLogFileException(@NotNull String s, @Nullable ProblemFix problemFix, @NotNull HttpClientActionsUsage.ProblemType problemType) {
        if (s == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(0);
        }
        if (problemType == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(1);
        }
        super(s);
        this.myProblemFix = problemFix;
        this.myProblemType = problemType;
    }

    @Nullable
    public ProblemFix getProblemFix() {
        return this.myProblemFix;
    }

    @ApiStatus.Internal
    @NotNull
    public HttpClientActionsUsage.ProblemType getProblemType() {
        HttpClientActionsUsage.ProblemType problemType = this.myProblemType;
        if (problemType == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(2);
        }
        return problemType;
    }

    @NotNull
    public static HttpRequestInvalidLogFileException createInvalidTypeException(@NotNull Project project, @NotNull FileType type) {
        if (project == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(3);
        }
        if (type == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(4);
        }
        return new HttpRequestInvalidLogFileException(RestClientBundle.message("http.request.log.file.wrong.type", type.getDescription()), new OpenConfiguration(() -> ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new FileTypeConfigurable())), HttpClientActionsUsage.ProblemType.INVALID_FILE_TYPE);
    }

    @NotNull
    public static HttpRequestInvalidLogFileException createIgnoredLogException(@NotNull Project project, @NotNull String ignoredPath) {
        if (project == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(5);
        }
        if (ignoredPath == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(6);
        }
        return new HttpRequestInvalidLogFileException(RestClientBundle.message("http.request.log.file.is.ignored", ignoredPath), new OpenConfiguration(() -> ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new FileTypeConfigurable())), HttpClientActionsUsage.ProblemType.INCLUDED_IN_IGNORED);
    }

    @NotNull
    public static HttpRequestInvalidLogFileException createExcludedLogException(@NotNull String excludedPath) {
        if (excludedPath == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(7);
        }
        return new HttpRequestInvalidLogFileException(RestClientBundle.message("http.request.log.file.is.excluded", excludedPath), null, HttpClientActionsUsage.ProblemType.EXCLUDED_FILE);
    }

    public static HttpRequestInvalidLogFileException createTooLargeLogFileException(@NotNull Project project) {
        if (project == null) {
            HttpRequestInvalidLogFileException.$$$reportNull$$$0(8);
        }
        return new HttpRequestInvalidLogFileException(RestClientBundle.message("http.request.log.too.large", new Object[0]), new CustomAction(RestClientBundle.message("http.request.log.too.large.fix.link.label", new Object[0]), () -> HttpRequestHistoryManager.getInstance(project).cleanupLogFile()), HttpClientActionsUsage.ProblemType.TOO_LARGE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInvalidTypeException";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createIgnoredLogException";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedLogException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTooLargeLogFileException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ProblemFix {
        @NlsContexts.LinkLabel
        @NotNull
        public String text();

        @NotNull
        public Runnable action();
    }

    record OpenConfiguration(@NotNull Runnable action) implements ProblemFix
    {
        @NotNull
        private final Runnable action;

        OpenConfiguration(@NotNull Runnable action) {
            if (action == null) {
                OpenConfiguration.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public String text() {
            String string = RestClientBundle.message("http.request.show.log.file.action.failed.open.config", new Object[0]);
            if (string == null) {
                OpenConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public Runnable action() {
            Runnable runnable = this.action;
            if (runnable == null) {
                OpenConfiguration.$$$reportNull$$$0(2);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException$OpenConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException$OpenConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    record CustomAction(@NlsContexts.LinkLabel @NotNull String text, @NotNull Runnable action) implements ProblemFix
    {
        private final @NlsContexts.LinkLabel @NotNull String text;
        @NotNull
        private final Runnable action;

        CustomAction(@NlsContexts.LinkLabel @NotNull String text2, @NotNull Runnable action) {
            if (text2 == null) {
                CustomAction.$$$reportNull$$$0(0);
            }
            if (action == null) {
                CustomAction.$$$reportNull$$$0(1);
            }
        }

        @Override
        @NlsContexts.LinkLabel
        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                CustomAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Runnable action() {
            Runnable runnable = this.action;
            if (runnable == null) {
                CustomAction.$$$reportNull$$$0(3);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException$CustomAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestInvalidLogFileException$CustomAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

