# This `require` guarantees that config scripts are run with the same load paths as the executable when `bundle exec` is used.
require 'bundler/setup' if (ENV['RUBYOPT'] || '').include?('bundler/setup')

require 'rubygems'

# RUBY-17641 - build rbenv gemsets GEM_PATH before simplecov initialization
def check_rbenv_gemset
  `rbenv which gem`.strip == $0
rescue
  false
end

unless check_rbenv_gemset
  require 'simplecov'

  SimpleCov.at_exit do
    # getting result will trigger ResultMerger to store results
    # if merging is not disabled
    SimpleCov.result
  end

# trick SimpleCov::ResultMerger into using provided output file
  module SimpleCov::ResultMerger
    def self.resultset_path
      ENV['RUBYMINE_SIMPLECOV_COVERAGE_PATH']
    end
  end
  SimpleCov.track_files "#{Dir.getwd}/**/*.rb" # include "0% covered" files into coverage report
  SimpleCov.project_name ENV['RUBYMINE_SIMPLECOV_RUN_CONFIGURATION']
  SimpleCov.command_name "#{SimpleCov.project_name}:#{Process.pid.to_s}"
  SimpleCov.use_merging ENV['RUBYMINE_SIMPLECOV_MERGING'] != 'false'

  pattern = ""
  i = 0
  patterns = []
  while pattern do
    pattern = ENV["RUBYMINE_SIMPLECOV_EXCLUDE_#{i}"]
    if pattern
      pattern = pattern.strip
      if pattern[0] == "/" && pattern[-1] == "/"
        patterns << pattern[1..-2]
      else
        patterns << pattern
      end
    end
    i += 1
  end

  patterns.each do |pattern|
    SimpleCov.add_filter pattern
  end

  SimpleCov.start do
    branch_cov = ENV['ENABLE_BRANCH_COVERAGE']
    subprocess_cov = ENV['ENABLE_FORKED_COVERAGE']
    if !running
      if branch_cov
        if respond_to?(:enable_coverage)
          enable_coverage :branch
        else
          STDERR.print "#{ENV['UNSUPPORTED_BRANCH_COVERAGE_WARNING']}\n"
        end
      end
      if subprocess_cov
        if respond_to?(:enable_for_subprocesses)
          enable_for_subprocesses(true)
        else
          STDERR.print "#{ENV['UNSUPPORTED_FORKED_COVERAGE_WARNING']}\n"
        end
      end
    elsif (respond_to?(:branch_coverage?) && !branch_coverage? && branch_cov) ||
        (respond_to?(:enabled_for_subprocesses?) && !enabled_for_subprocesses? && subprocess_cov)
      # if simplecov is running without branch/subprocess coverage and it's supposed to be set, we should tell user
      # to fix his SimpleCov config
      STDERR.print "#{ENV['SIMPLECOV_WRONG_CONFIG_MESSAGE']}\n"
    end
  end
end
