# frozen_string_literal: true

module Constants
  # append on each write
  APPEND = _
  # disable line code conversion and make ASCII-8BIT
  BINARY = _
  # create file if it does not exist
  CREAT = _
  # Try to minimize cache effects of the I/O to and from this file.
  DIRECT = _
  DSYNC = _
  # error if CREAT and the file exists
  EXCL = _
  FNM_CASEFOLD = _
  FNM_DOTMATCH = _
  FNM_NOESCAPE = _
  FNM_PATHNAME = _
  FNM_SYSCASE = _
  LOCK_EX = _
  LOCK_NB = _
  LOCK_SH = _
  LOCK_UN = _
  # do not change atime
  NOATIME = _
  # not to make opened IO the controlling terminal device
  NOCTTY = _
  # do not follow symlinks
  NOFOLLOW = _
  # do not block on open or for data to become available
  NONBLOCK = _
  NULL = _
  # open for reading only
  RDONLY = _
  # open for reading and writing
  RDWR = _
  RSYNC = _
  SYNC = _
  # truncate size to 0
  TRUNC = _
  # open for writing only
  WRONLY = _
end
