# frozen_string_literal: true

# A <code>Regexp</code> holds a regular expression, used to match a pattern
# against strings. Regexps are created using the <code>/.../</code> and
# <code>%r{...}</code> literals, and by the <code>Regexp::new</code>
# constructor.
class Regexp
  EXTENDED = _
  IGNORECASE = _
  MULTILINE = _

  # Synonym for <code>Regexp.new</code>
  def self.compile(*args) end

  # Escapes any characters that would have special meaning in a regular
  # expression. Returns a new escaped string, or self if no characters are
  # escaped.  For any string,
  # <code>Regexp.escape(<i>str</i>)=~<i>str</i></code> will be true.
  #
  #    Regexp.escape('\\*?{}.')   #=> \\\\\*\?\{\}\.
  def self.escape(str) end

  # The first form returns the <code>MatchData</code> object generated by the
  # last successful pattern match. Equivalent to reading the global variable
  # <code>$~</code>. The second form returns the nth field in this
  # <code>MatchData</code> object.
  #
  #    /c(.)t/ =~ 'cat'       #=> 0
  #    Regexp.last_match      #=> #<MatchData:0x401b3d30>
  #    Regexp.last_match(0)   #=> "cat"
  #    Regexp.last_match(1)   #=> "a"
  #    Regexp.last_match(2)   #=> nil
  def self.last_match(*several_variants) end

  # Escapes any characters that would have special meaning in a regular
  # expression. Returns a new escaped string, or self if no characters are
  # escaped.  For any string,
  # <code>Regexp.escape(<i>str</i>)=~<i>str</i></code> will be true.
  #
  #    Regexp.escape('\\*?{}.')   #=> \\\\\*\?\{\}\.
  def self.quote(str) end

  # Return a <code>Regexp</code> object that is the union of the given
  # <em>pattern</em>s, i.e., will match any of its parts. The <em>pattern</em>s
  # can be Regexp objects, in which case their options will be preserved, or
  # Strings. If no patterns are given, returns <code>/(?!)/</code>.
  #
  #    Regexp.union                         #=> /(?!)/
  #    Regexp.union("penzance")             #=> /penzance/
  #    Regexp.union("a+b*c")                #=> /a\+b\*c/
  #    Regexp.union("skiing", "sledding")   #=> /skiing|sledding/
  #    Regexp.union(["skiing", "sledding"]) #=> /skiing|sledding/
  #    Regexp.union(/dogs/, /cats/i)        #=> /(?-mix:dogs)|(?i-mx:cats)/
  def self.union(*several_variants) end

  # Constructs a new regular expression from <i>pattern</i>, which can be either
  # a <code>String</code> or a <code>Regexp</code> (in which case that regexp's
  # options are propagated, and new options may not be specified (a change as of
  # Ruby 1.8). If <i>options</i> is a <code>Fixnum</code>, it should be one or
  # more of the constants <code>Regexp::EXTENDED</code>,
  # <code>Regexp::IGNORECASE</code>, and <code>Regexp::MULTILINE</code>,
  # <em>or</em>-ed together. Otherwise, if <i>options</i> is not
  # <code>nil</code>, the regexp will be case insensitive. The <i>lang</i>
  # parameter enables multibyte support for the regexp: `n', `N' = none, `e',
  # `E' = EUC, `s', `S' = SJIS, `u', `U' = UTF-8.
  #
  #    r1 = Regexp.new('^a-z+:\\s+\w+')           #=> /^a-z+:\s+\w+/
  #    r2 = Regexp.new('cat', true)               #=> /cat/i
  #    r3 = Regexp.new('dog', Regexp::EXTENDED)   #=> /dog/x
  #    r4 = Regexp.new(r2)                        #=> /cat/i
  def initialize(*several_variants) end

  # Case Equality---Synonym for <code>Regexp#=~</code> used in case statements.
  #
  #    a = "HELLO"
  #    case a
  #    when /^[a-z]*$/; print "Lower case\n"
  #    when /^[A-Z]*$/; print "Upper case\n"
  #    else;            print "Mixed case\n"
  #    end
  #
  # <em>produces:</em>
  #
  #    Upper case
  def ===(str) end

  # Returns a <code>MatchData</code> object describing the match, or
  # <code>nil</code> if there was no match. This is equivalent to retrieving the
  # value of the special variable <code>$~</code> following a normal match.
  #
  #    /(.)(.)(.)/.match("abc")[2]   #=> "b"
  def =~(p1) end

  # Match---Matches <i>rxp</i> against the contents of <code>$_</code>.
  # Equivalent to <code><i>rxp</i> =~ $_</code>.
  #
  #    $_ = "input data"
  #    ~ /at/   #=> 7
  def ~; end

  # Returns the value of the case-insensitive flag.
  def casefold?; end

  # Equality---Two regexps are equal if their patterns are identical, they have
  # the same character set code, and their <code>casefold?</code> values are the
  # same.
  #
  #    /abc/  == /abc/x   #=> false
  #    /abc/  == /abc/i   #=> false
  #    /abc/u == /abc/n   #=> false
  def eql?(other) end
  alias == eql?

  # Produce a hash based on the text and options of this regular expression.
  def hash; end

  # Produce a nicely formatted string-version of _rxp_. Perhaps surprisingly,
  # <code>#inspect</code> actually produces the more natural version of
  # the string than <code>#to_s</code>.
  #
  #     /ab+c/ix.to_s         #=> /ab+c/ix
  def inspect; end

  # Returns the character set code for the regexp.
  def kcode; end

  # Returns a <code>MatchData</code> object describing the match, or
  # <code>nil</code> if there was no match. This is equivalent to retrieving the
  # value of the special variable <code>$~</code> following a normal match.
  #
  #    /(.)(.)(.)/.match("abc")[2]   #=> "b"
  def match(str) end

  # Returns the set of bits corresponding to the options used when creating this
  # Regexp (see <code>Regexp::new</code> for details. Note that additional bits
  # may be set in the returned options: these are used internally by the regular
  # expression code. These extra bits are ignored if the options are passed to
  # <code>Regexp::new</code>.
  #
  #    Regexp::IGNORECASE                  #=> 1
  #    Regexp::EXTENDED                    #=> 2
  #    Regexp::MULTILINE                   #=> 4
  #
  #    /cat/.options                       #=> 128
  #    /cat/ix.options                     #=> 131
  #    Regexp.new('cat', true).options     #=> 129
  #    Regexp.new('cat', 0, 's').options   #=> 384
  #
  #    r = /cat/ix
  #    Regexp.new(r.source, r.options)     #=> /cat/ix
  def options; end

  # Returns the original string of the pattern.
  #
  #    /ab+c/ix.source   #=> "ab+c"
  def source; end

  # Returns a string containing the regular expression and its options (using the
  # <code>(?xxx:yyy)</code> notation. This string can be fed back in to
  # <code>Regexp::new</code> to a regular expression with the same semantics as
  # the original. (However, <code>Regexp#==</code> may not return true when
  # comparing the two, as the source of the regular expression itself may
  # differ, as the example shows).  <code>Regexp#inspect</code> produces a
  # generally more readable version of <i>rxp</i>.
  #
  #    r1 = /ab+c/ix         #=> /ab+c/ix
  #    s1 = r1.to_s          #=> "(?ix-m:ab+c)"
  #    r2 = Regexp.new(s1)   #=> /(?ix-m:ab+c)/
  #    r1 == r2              #=> false
  #    r1.source             #=> "ab+c"
  #    r2.source             #=> "(?ix-m:ab+c)"
  def to_s; end
end
