#!/usr/bin/env sh

if [ $# -lt 2 ]; then
  echo "Usage: $0 SOURCE_FILE TARGET_FILE" 1>&2
  exit 1
fi

SOURCE_FILE="$1"
TARGET_DIR="$2"

if [ -L "$SOURCE_FILE" ]; then
  SOURCE_FILE=$(readlink -f "$SOURCE_FILE") # dereference
fi

if [ -d "$SOURCE_FILE" ]; then
  echo "Error: source path points to a directory '$SOURCE_FILE'" 1>&2
  exit 1
fi

if [ -f "$SOURCE_FILE" ]; then
  mkdir -p "$TARGET_DIR"
  cp --update "$SOURCE_FILE" "$TARGET_DIR"
else
  rm --force "$TARGET_DIR"
fi

exit 0
