require 'net/http'
require 'json'
require 'uri'

BASH_COMMAND_TO_COLLECT_ALL_GEM_NAMES = <<~COMMAND
  
  {
    gem list -r --clear-sources --no-versions -s https://rubygems.org ;
    gem list -r --clear-sources --no-versions -s https://rubygems.org --prerelease ;
  }
COMMAND

RUBYGEMS_TRACKED_GEM_NAMES_FILE = 'rubygems_tracked_gems.txt'

DOWNLOADS_NUMBER_THRESHOLD = 50_000

# Get all gems from rubygems.org
name_lines = %x[#{BASH_COMMAND_TO_COLLECT_ALL_GEM_NAMES}].lines

# Parse lines with gems names
uniq_names = name_lines.map do |line|
  line.strip
end.uniq

puts "Total number of gems is #{uniq_names.size}"

# Request versions info and sum downloads across them for each gem
name_total_downloads_list = uniq_names.map.with_index do |name, idx|
  if idx % 10 == 0
    sleep 1
  end

  puts "Processing #{idx} gem with name '#{name}'"
  begin
    uri = URI("https://rubygems.org/api/v1/versions/#{name}.json")

    response = Net::HTTP.get(uri)
    json_array = JSON.parse(response)

    total_downloads = json_array.sum { |obj| obj["downloads_count"].to_i }
    puts "Total downloads of gem '#{name}' is '#{total_downloads}'"
    [name, total_downloads.to_i]
  rescue Exception => e
    puts e
    nil
  end
end.compact

sorted_name_total_downloads_list = name_total_downloads_list.sort_by do |_, total_downloads|
  total_downloads
end.reverse

filtered_name_total_downloads_list = sorted_name_total_downloads_list.filter do |_, total_downloads|
  total_downloads >= DOWNLOADS_NUMBER_THRESHOLD
end

final_name_list = filtered_name_total_downloads_list.sort_by do |name, _|
  name
end

File.open(RUBYGEMS_TRACKED_GEM_NAMES_FILE, 'w') do |file|
  final_name_list.each do |name, _|
    file.puts(name)
  end
end