# frozen_string_literal: true

require 'tempfile'

Tempfile.create(%w[rm_brakeman_output .json]) do |output_file|
  begin
    brakeman_command = [
      'brakeman',
      '--quiet', # don't output run info
      '--no-pager', # output directly to terminal
      '--no-exit-on-warn', # 0 exit code with warnings (normal is 3)
      '--no-exit-on-error', # 0 exit code with errors (normal is 7)
      '--output', output_file.path,
      *ARGV
    ]
    raise StandardError unless system(*brakeman_command)

    output_file.each_line { |line| $stdout.write line }

  rescue => e
    $stderr.write "Brakeman command failed: code=#{$?}, error=#{e}\n"
    exit($?.exitstatus || 1)
  end
end
