/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.psi.mixin;

import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.psi.api.RbsAttributeDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsClassName;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsDefaultType;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendCall;
import com.intellij.ruby.rbs.common.psi.api.RbsGenericsBound;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleInclusionCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleSelfType;
import com.intellij.ruby.rbs.common.psi.api.RbsSimpleType;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeElement;
import com.intellij.ruby.rbs.common.psi.api.RbsVariableDeclarationElement;
import com.intellij.ruby.rbs.common.psi.data.RbsBooleanLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsIntegerLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsNilLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsStringLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTupleTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.psi.data.RbsVariableType;
import com.intellij.ruby.rbs.common.psi.impl.RbsSuperClassImpl;
import com.intellij.ruby.rbs.common.psi.impl.RbsTypeImpl;
import com.intellij.ruby.rbs.common.psi.mixin.RbsMethodTypeMixin;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.model.psi.reference.PsiOwnSymbolReferenceProvider;

public abstract class RbsSimpleTypeMixin
extends RbsTypeImpl
implements RbsSimpleType {
    protected RbsSimpleTypeMixin(@NotNull ASTNode node) {
        if (node == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public PsiElement getInteger() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_TINTEGER);
    }

    @Override
    @Nullable
    public PsiElement getKeyword() {
        return this.findChildByType(RbsTokenSets.RBS_KEYWORDS);
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        Collection collection = PsiOwnSymbolReferenceProvider.getReferencesOrEmptyCollection((PsiElement)this);
        if (collection == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public PsiElement getString() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null ? this.findChildByType(RbsElementTypesGenerated.RBS_TSTRING) : null;
    }

    @Nullable
    public PsiElement getSymbol() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null ? this.findChildByType(RbsElementTypesGenerated.RBS_TSYMBOL) : this.findChildByType(RbsElementTypesGenerated.RBS_TSTRING);
    }

    @Override
    @NotNull
    public RbsTypeSignature getTypeSignature() {
        RbsTypeSignature nonOptionalTypeSignature = this.getNonOptionalTypeSignature();
        RbsTypeSignature rbsTypeSignature = this.isOptional() ? new RbsOptionalTypeSignature(nonOptionalTypeSignature) : nonOptionalTypeSignature;
        if (rbsTypeSignature == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(2);
        }
        return rbsTypeSignature;
    }

    public boolean isInstanceContext() {
        RbsAttributeDeclarationElement attributeDeclaration = (RbsAttributeDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsAttributeDeclarationElement.class);
        if (attributeDeclaration != null) {
            return attributeDeclaration.getDeclarationType() == RbsDeclarationType.INSTANCE_DECLARATION;
        }
        RbsMethodDeclarationElement methodDeclaration = (RbsMethodDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsMethodDeclarationElement.class);
        if (methodDeclaration != null) {
            return methodDeclaration.getDeclarationTypes().equals(Set.of(RbsDeclarationType.INSTANCE_DECLARATION));
        }
        RbsModuleInclusionCallElement moduleInclusionCall = (RbsModuleInclusionCallElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsModuleInclusionCallElement.class);
        if (moduleInclusionCall != null) {
            return !(moduleInclusionCall instanceof RbsExtendCall);
        }
        RbsModuleSelfType selfType = (RbsModuleSelfType)PsiTreeUtil.getParentOfType((PsiElement)this, RbsModuleSelfType.class);
        if (selfType != null) {
            return true;
        }
        RbsSuperClassImpl superclass = (RbsSuperClassImpl)PsiTreeUtil.getParentOfType((PsiElement)this, RbsSuperClassImpl.class);
        if (superclass != null) {
            return true;
        }
        RbsGenericsBound genericsBound = (RbsGenericsBound)PsiTreeUtil.getParentOfType((PsiElement)this, RbsGenericsBound.class);
        if (genericsBound != null) {
            return true;
        }
        RbsDefaultType defaultType = (RbsDefaultType)PsiTreeUtil.getParentOfType((PsiElement)this, RbsDefaultType.class);
        if (defaultType != null) {
            return true;
        }
        RbsVariableDeclarationElement variableDeclaration = (RbsVariableDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsVariableDeclarationElement.class);
        if (variableDeclaration != null) {
            return variableDeclaration.getDeclarationType() == RbsDeclarationType.INSTANCE_DECLARATION && variableDeclaration.getVariableType() == RbsVariableType.INSTANCE_VARIABLE;
        }
        return false;
    }

    @Override
    public boolean isOptional() {
        return PsiUtilCore.getElementType((PsiElement)this.getLastChild()) == RbsElementTypesGenerated.RBS_KQUESTION;
    }

    @Override
    public boolean isSingleton() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KSINGLETON) != null;
    }

    @Override
    public boolean isString() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null && this.findChildByType(RbsTokenSets.RBS_OPEN_QUOTES) != null;
    }

    public boolean isSymbol() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) != null || this.findChildByType(RbsElementTypesGenerated.RBS_TSYMBOL) != null;
    }

    @Override
    public boolean isTuple() {
        return this.getQualifiedName() == null && this.findChildByType(RbsElementTypesGenerated.RBS_KLBRACKET) != null;
    }

    @NotNull
    private RbsTypeSignature getNonOptionalTypeSignature() {
        PsiElement integer;
        if (this.isSingleton()) {
            RbsClassName className = this.getClassName();
            if (className == null) {
                RbsKeywordTypeSignature rbsKeywordTypeSignature = RbsKeywordTypeSignature.UNTYPED;
                if (rbsKeywordTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(3);
                }
                return rbsKeywordTypeSignature;
            }
            return new RbsSingletonTypeSignature(RbsSimpleTypeMixin.createQualifiedNameReferenceSignature(this, className.getStrippedText()));
        }
        if (this.getProcType() != null) {
            RbsProcTypeSignature rbsProcTypeSignature = this.getProcType().getTypeSignature();
            if (rbsProcTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(4);
            }
            return rbsProcTypeSignature;
        }
        if (this.getQualifiedName() != null) {
            return this.getQualifiedNameTypeSignature(this.getQualifiedName().getStrippedText());
        }
        if (this.getRecordType() != null) {
            RbsRecordTypeSignature rbsRecordTypeSignature = this.getRecordType().getTypeSignature();
            if (rbsRecordTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(5);
            }
            return rbsRecordTypeSignature;
        }
        if (this.isTuple()) {
            return new RbsTupleTypeSignature(ContainerUtil.map((Collection)this.getTypeListElements(), RbsTypeElement::getTypeSignature));
        }
        if (this.getType() != null) {
            RbsTypeSignature rbsTypeSignature = this.getType().getTypeSignature();
            if (rbsTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(6);
            }
            return rbsTypeSignature;
        }
        PsiElement keyword = this.getKeyword();
        if (keyword != null) {
            RbsTypeSignature signature;
            RbsKeywordTypeSignature typeSignature = RbsKeywordTypeSignature.forName(keyword.getText());
            if (typeSignature != null) {
                RbsKeywordTypeSignature rbsKeywordTypeSignature = typeSignature;
                if (rbsKeywordTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(7);
                }
                return rbsKeywordTypeSignature;
            }
            switch (keyword.getText()) {
                case "true": {
                    RbsTypeSignature rbsTypeSignature = new RbsBooleanLiteralSignature(true);
                    break;
                }
                case "false": {
                    RbsTypeSignature rbsTypeSignature = new RbsBooleanLiteralSignature(false);
                    break;
                }
                case "nil": {
                    RbsTypeSignature rbsTypeSignature = RbsNilLiteralSignature.INSTANCE;
                    break;
                }
                case "self?": {
                    RbsTypeSignature rbsTypeSignature = new RbsOptionalTypeSignature(RbsKeywordTypeSignature.SELF);
                    break;
                }
                default: {
                    RbsTypeSignature rbsTypeSignature = signature = null;
                }
            }
            if (signature != null) {
                RbsTypeSignature rbsTypeSignature = signature;
                if (rbsTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(8);
                }
                return rbsTypeSignature;
            }
        }
        if ((integer = this.getInteger()) != null) {
            return new RbsIntegerLiteralSignature(new BigInteger(integer.getText().replaceAll("_", "")));
        }
        if (this.isString()) {
            PsiElement string = this.getString();
            return new RbsStringLiteralSignature(string != null ? string.getText() : "");
        }
        if (this.isSymbol()) {
            PsiElement symbol = this.getSymbol();
            if (symbol != null && PsiUtilCore.getElementType((PsiElement)symbol) == RbsElementTypesGenerated.RBS_TSYMBOL) {
                return new RbsSymbolLiteralSignature(StringUtil.trimStart((String)symbol.getText(), (String)":"));
            }
            return new RbsSymbolLiteralSignature(symbol != null ? symbol.getText() : "");
        }
        throw new UnsupportedOperationException(String.format("Unrecognised type: %s{text='%s'}", this.getClass(), this.getText()));
    }

    @NotNull
    private RbsTypeSignature getQualifiedNameTypeSignature(@NotNull String qualifiedName) {
        int index;
        int index2;
        int index3;
        RbsMethodTypeMixin methodType;
        if (qualifiedName == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(9);
        }
        if ((methodType = (RbsMethodTypeMixin)PsiTreeUtil.getParentOfType((PsiElement)this, RbsMethodTypeMixin.class)) != null && (index3 = ContainerUtil.indexOf(methodType.getTypeParamIdentifiers(), identifier -> identifier != null && identifier.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE, qualifiedName, index3);
        }
        RbsTypeDeclarationElement typeAliasDeclaration = (RbsTypeDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsTypeDeclarationElement.class);
        if (typeAliasDeclaration != null && (index2 = ContainerUtil.indexOf(typeAliasDeclaration.getModuleTypeParamIdentifiers(), identifier -> identifier != null && identifier.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.TYPE_ALIAS_VARIABLE, qualifiedName, index2);
        }
        RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsContainerDeclarationElement.class);
        if (containerDeclaration != null && this.isInstanceContext() && (index = ContainerUtil.indexOf(containerDeclaration.getModuleTypeParamIdentifiers(), parameter -> parameter != null && parameter.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, qualifiedName, index);
        }
        return RbsSimpleTypeMixin.createQualifiedNameReferenceSignature(this, qualifiedName);
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static RbsTypeSignature createQualifiedNameReferenceSignature(@NotNull RbsSimpleTypeMixin element, @NotNull String qualifiedName) {
        Fqn containerFqn;
        if (element == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(10);
        }
        if (qualifiedName == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(11);
        }
        ArrayList<RbsUseClauseType.Wildcard> useClauses = new ArrayList<RbsUseClauseType.Wildcard>();
        List typeArgumentSignatures = ContainerUtil.map((Collection)element.getTypeListElements(), RbsTypeElement::getTypeSignature);
        String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)qualifiedName, (String)"::"), (Object)qualifiedName);
        String suffix = StringUtil.substringAfter((String)qualifiedName, (String)"::");
        for (RbsUseClauseType type : RbsPsiUtil.getUseClauseTypes(element)) {
            block11: {
                Fqn finalFqn;
                block10: {
                    if (type instanceof RbsUseClauseType.Alias) {
                        RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)type;
                        Object object = alias.fqn();
                        Fqn fqn = object;
                        Object aliasName = object = alias.name();
                        if (!name.equals(aliasName)) break block10;
                        finalFqn = suffix != null ? Fqn.concat(fqn, suffix, new String[0]) : fqn;
                        return new RbsQualifiedNameReferenceSignature(finalFqn, typeArgumentSignatures);
                    }
                }
                if (type instanceof RbsUseClauseType.Import) {
                    RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)type;
                    Fqn fqn = finalFqn = import_.fqn();
                    if (!name.equals(fqn.split().getName())) break block11;
                    finalFqn = suffix != null ? Fqn.concat(fqn, suffix, new String[0]) : fqn;
                    return new RbsQualifiedNameReferenceSignature(finalFqn, typeArgumentSignatures);
                }
            }
            if (!(type instanceof RbsUseClauseType.Wildcard)) continue;
            RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
            useClauses.add(wildcard);
        }
        RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)element, RbsContainerDeclarationElement.class);
        Fqn fqn = containerFqn = containerDeclaration != null ? containerDeclaration.getFqn() : Fqn.INVALID;
        if (useClauses.isEmpty() && containerFqn == Fqn.INVALID || qualifiedName.startsWith("::")) {
            return new RbsQualifiedNameReferenceSignature(Fqn.of(qualifiedName, new String[0]), typeArgumentSignatures);
        }
        return new RbsQualifiedNameReferenceSignature(useClauses, containerFqn, qualifiedName, typeArgumentSignatures);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/psi/mixin/RbsSimpleTypeMixin";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/psi/mixin/RbsSimpleTypeMixin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameTypeSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedNameReferenceSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

