/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.psi.mixin;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.psi.api.RbsKeyword;
import com.intellij.ruby.rbs.common.psi.api.RbsRecordType;
import com.intellij.ruby.rbs.common.psi.data.RbsBooleanLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsIntegerLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsStringLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.impl.RbsRecordFieldImpl;
import com.intellij.ruby.rbs.common.psi.mixin.RbsCompositeElement;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class RbsRecordTypeMixin
extends RbsCompositeElement
implements RbsRecordType {
    protected RbsRecordTypeMixin(@NotNull ASTNode node) {
        if (node == null) {
            RbsRecordTypeMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public RbsRecordTypeSignature getTypeSignature() {
        ArrayList<RbsRecordTypeSignature.Field> fields = new ArrayList<RbsRecordTypeSignature.Field>();
        for (RbsRecordFieldImpl field : ContainerUtil.filterIsInstance((Collection)this.getRecordFieldList(), RbsRecordFieldImpl.class)) {
            String text;
            RbsRecordTypeSignature.FieldType fieldType = field.isOptional() ? RbsRecordTypeSignature.FieldType.OPTIONAL : RbsRecordTypeSignature.FieldType.REQUIRED;
            RbsKeywordTypeSignature valueTypeSignature = field.getType() != null ? field.getType().getTypeSignature() : RbsKeywordTypeSignature.UNTYPED;
            PsiElement element = field.getBoolean();
            if (element != null) {
                RbsBooleanLiteralSignature keyTypeSignature = new RbsBooleanLiteralSignature(PsiUtilCore.getElementType((PsiElement)element) == RbsElementTypesGenerated.RBS_KTRUE);
                fields.add(new RbsRecordTypeSignature.Field(fieldType, keyTypeSignature, valueTypeSignature));
                continue;
            }
            PsiElement identifier = field.getIdentifier();
            if (identifier != null) {
                RbsSymbolLiteralSignature keyTypeSignature = new RbsSymbolLiteralSignature(identifier.getText());
                fields.add(new RbsRecordTypeSignature.Field(fieldType, keyTypeSignature, valueTypeSignature));
                continue;
            }
            PsiElement integer = field.getInteger();
            if (integer != null) {
                RbsIntegerLiteralSignature keyTypeSignature = new RbsIntegerLiteralSignature(new BigInteger(integer.getText().replaceAll("_", "")));
                fields.add(new RbsRecordTypeSignature.Field(fieldType, keyTypeSignature, valueTypeSignature));
                continue;
            }
            RbsKeyword keyword = field.getKeyword();
            if (keyword != null) {
                RbsSymbolLiteralSignature keyTypeSignature = new RbsSymbolLiteralSignature(Strings.trimEnd((String)keyword.getText(), (String)":"));
                fields.add(new RbsRecordTypeSignature.Field(fieldType, keyTypeSignature, valueTypeSignature));
                continue;
            }
            if (field.isString()) {
                text = (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)field.getString(), PsiElement::getText)), (Object)"");
                fields.add(new RbsRecordTypeSignature.Field(fieldType, new RbsStringLiteralSignature(text), valueTypeSignature));
                continue;
            }
            if (field.isSymbol()) {
                text = (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)field.getSymbol(), PsiElement::getText)), (Object)"");
                RbsSymbolLiteralSignature keyTypeSignature = new RbsSymbolLiteralSignature(field.isQuotedSymbol() ? text : Strings.trimStart((String)text, (String)":"));
                fields.add(new RbsRecordTypeSignature.Field(fieldType, keyTypeSignature, valueTypeSignature));
                continue;
            }
            throw new UnsupportedOperationException("Unrecognised record key type: %s".formatted(field.getText()));
        }
        return new RbsRecordTypeSignature(fields);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ruby/rbs/common/psi/mixin/RbsRecordTypeMixin", "<init>"));
    }
}

