/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.psi.mixin;

import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.psi.api.RbsClassDecl;
import com.intellij.ruby.rbs.common.psi.api.RbsClassName;
import com.intellij.ruby.rbs.common.psi.api.RbsClassNameElement;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsSuperClass;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeElement;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeParameter;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVariance;
import com.intellij.ruby.rbs.common.psi.stub.RbsClassDeclarationStub;
import com.intellij.ruby.rbs.common.psi.stub.RbsStubBasedPsiElement;
import com.intellij.ruby.rbs.common.psi.tree.RbsClassDeclarationElementType;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiOwnSymbolDeclarationProvider;
import org.jetbrains.plugins.ruby.model.psi.reference.PsiOwnSymbolReferenceProvider;

public abstract class RbsClassDeclarationMixin
extends RbsStubBasedPsiElement<RbsClassDeclarationStub>
implements RbsClassDecl {
    protected RbsClassDeclarationMixin(@NotNull RbsClassDeclarationStub stub) {
        if (stub == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(0);
        }
        super(stub, RbsClassDeclarationElementType.INSTANCE);
    }

    protected RbsClassDeclarationMixin(@NotNull ASTNode node) {
        if (node == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        RbsClassDeclarationStub stub = (RbsClassDeclarationStub)this.getGreenStub();
        if (stub != null) {
            Fqn fqn = stub.getFqn();
            if (fqn == null) {
                RbsClassDeclarationMixin.$$$reportNull$$$0(2);
            }
            return fqn;
        }
        RbsContainerDeclarationElement parent = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsContainerDeclarationElement.class);
        String name = (String)ObjectUtils.doIfNotNull((Object)this.getClassName(), RbsClassNameElement::getStrippedText);
        if (parent == null || name == null) {
            Fqn fqn = Fqn.of(name, new String[0]);
            if (fqn == null) {
                RbsClassDeclarationMixin.$$$reportNull$$$0(3);
            }
            return fqn;
        }
        Fqn fqn = Fqn.concat(parent.getFqn(), name, new String[0]);
        if (fqn == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(4);
        }
        return fqn;
    }

    @Override
    public @NotNull List<@Nullable PsiElement> getModuleTypeParamIdentifiers() {
        List list = ContainerUtil.map((Collection)this.getModuleTypeParamList(), moduleTypeParam -> (PsiElement)ObjectUtils.doIfNotNull((Object)moduleTypeParam.getNode().findChildByType(RbsElementTypesGenerated.RBS_TUIDENT), ASTNode::getPsi));
        if (list == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        RbsClassName className = this.getClassName();
        if (className == null) {
            return null;
        }
        return className.getNameIdentifier();
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<? extends @NotNull PsiSymbolDeclaration> getOwnDeclarations() {
        Collection collection = PsiOwnSymbolDeclarationProvider.getDeclarationsOrEmptyCollection((PsiElement)this);
        if (collection == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        Collection collection = PsiOwnSymbolReferenceProvider.getReferencesOrEmptyCollection((PsiElement)this);
        if (collection == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @Nullable
    public String getSuperclassName() {
        RbsClassDeclarationStub stub = (RbsClassDeclarationStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSuperclassName();
        }
        return Optional.ofNullable(this.getSuperClass()).map(RbsSuperClass::getClassName).map(PsiElement::getText).orElse(null);
    }

    @Override
    @NotNull
    public List<RbsTypeSignature> getSuperclassTypeArgumentSignatures() {
        RbsClassDeclarationStub stub = (RbsClassDeclarationStub)this.getGreenStub();
        if (stub != null) {
            List<RbsTypeSignature> list = stub.getSuperclassTypeArgumentSignatures();
            if (list == null) {
                RbsClassDeclarationMixin.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<RbsTypeSignature> list = Stream.ofNullable(this.getSuperClass()).flatMap(superclass -> superclass.getTypeListElements().stream()).map(RbsTypeElement::getTypeSignature).toList();
        if (list == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public @NotNull List<@Nullable RbsTypeParameter> getTypeParameters() {
        RbsClassDeclarationStub stub = (RbsClassDeclarationStub)this.getGreenStub();
        if (stub != null) {
            List<RbsTypeParameter> list = stub.getTypeParameters();
            if (list == null) {
                RbsClassDeclarationMixin.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.map((Collection)this.getModuleTypeParamList(), moduleTypeParam -> {
            ASTNode node = moduleTypeParam.getNode();
            String name = (String)ObjectUtils.doIfNotNull((Object)node.findChildByType(RbsElementTypesGenerated.RBS_TUIDENT), ASTNode::getText);
            if (name == null) {
                return null;
            }
            RbsVariance variance = RbsVariance.fromNode(node.findChildByType(RbsTokenSets.RBS_MODULE_TYPE_PARAM_VARIANCE));
            boolean isUnchecked = node.findChildByType(RbsElementTypesGenerated.RBS_KUNCHECKED) != null;
            RbsTypeSignature upperBound = moduleTypeParam.getUpperBoundTypeSignature();
            RbsTypeSignature defaultType = moduleTypeParam.getDefaultTypeTypeSignature();
            return new RbsTypeParameter(name, variance, isUnchecked, upperBound, defaultType);
        });
        if (list == null) {
            RbsClassDeclarationMixin.$$$reportNull$$$0(11);
        }
        return list;
    }

    public IElementType getIElementType() {
        return RbsClassDeclarationElementType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/psi/mixin/RbsClassDeclarationMixin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/psi/mixin/RbsClassDeclarationMixin";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTypeParamIdentifiers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassTypeArgumentSignatures";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

