/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.psi.data;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ruby.rbs.common.psi.data.RbsLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.util.RbsNamingConventionUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsRecordTypeSignature
implements RbsTypeSignature {
    private final List<Field> myFields;

    public RbsRecordTypeSignature(@NotNull List<Field> fields) {
        if (fields == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(0);
        }
        HashSet keys = new HashSet();
        this.myFields = fields.stream().filter(it -> keys.add(it.myKeyTypeSignature)).toList();
    }

    @Override
    public void accept(@NotNull RbsTypeSignatureVisitor visitor) {
        if (visitor == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(1);
        }
        visitor.visitRecordTypeSignature(this);
    }

    @Override
    @NotNull
    public RbsRecordTypeSignature apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
        if (fun == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(2);
        }
        return new RbsRecordTypeSignature(ContainerUtil.map(this.myFields, it -> it.apply(fun)));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFields.equals(((RbsRecordTypeSignature)obj).myFields);
    }

    @Nullable
    public Field getField(@NotNull RbsTypeSignature key) {
        if (key == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(3);
        }
        return (Field)ContainerUtil.find(this.myFields, it -> it.getKeyTypeSignature().equals(key));
    }

    @NotNull
    public List<Field> getFields() {
        List<Field> list = this.myFields;
        if (list == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<RbsLiteralSignature> getKeyTypeSignatures() {
        List list = ContainerUtil.map(this.myFields, Field::getKeyTypeSignature);
        if (list == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<RbsTypeSignature> getValueTypeSignatures() {
        List list = ContainerUtil.map(this.myFields, Field::getValueTypeSignature);
        if (list == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(6);
        }
        return list;
    }

    public int hashCode() {
        return this.myFields.hashCode();
    }

    @NotNull
    public String toString() {
        if (this.myFields.isEmpty()) {
            return "{}";
        }
        String string = "{ %s }".formatted(StringUtil.join(this.myFields, (String)", "));
        if (string == null) {
            RbsRecordTypeSignature.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/psi/data/RbsRecordTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/psi/data/RbsRecordTypeSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypeSignatures";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTypeSignatures";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class Field {
        private final FieldType myFieldType;
        private final RbsLiteralSignature myKeyTypeSignature;
        private final RbsTypeSignature myValueTypeSignature;

        public Field(@NotNull FieldType type, @NotNull RbsLiteralSignature keyTypeSignature, @NotNull RbsTypeSignature valueTypeSignature) {
            if (type == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (keyTypeSignature == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (valueTypeSignature == null) {
                Field.$$$reportNull$$$0(2);
            }
            this.myFieldType = type;
            this.myKeyTypeSignature = keyTypeSignature;
            this.myValueTypeSignature = valueTypeSignature;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            return this.myFieldType == other.myFieldType && this.myKeyTypeSignature.equals(other.myKeyTypeSignature) && this.myValueTypeSignature.equals(other.myValueTypeSignature);
        }

        @NotNull
        public FieldType getFieldType() {
            FieldType fieldType = this.myFieldType;
            if (fieldType == null) {
                Field.$$$reportNull$$$0(3);
            }
            return fieldType;
        }

        @NotNull
        public RbsLiteralSignature getKeyTypeSignature() {
            RbsLiteralSignature rbsLiteralSignature = this.myKeyTypeSignature;
            if (rbsLiteralSignature == null) {
                Field.$$$reportNull$$$0(4);
            }
            return rbsLiteralSignature;
        }

        @NotNull
        public RbsTypeSignature getValueTypeSignature() {
            RbsTypeSignature rbsTypeSignature = this.myValueTypeSignature;
            if (rbsTypeSignature == null) {
                Field.$$$reportNull$$$0(5);
            }
            return rbsTypeSignature;
        }

        public int hashCode() {
            int result = this.myFieldType.hashCode();
            result = 31 * result + this.myKeyTypeSignature.hashCode();
            result = 31 * result + this.myValueTypeSignature.hashCode();
            return result;
        }

        public boolean isOptional() {
            return this.myFieldType == FieldType.OPTIONAL;
        }

        public boolean isRequired() {
            return this.myFieldType == FieldType.REQUIRED;
        }

        @NotNull
        public String toString() {
            RbsSymbolLiteralSignature literal;
            String text;
            RbsLiteralSignature rbsLiteralSignature = this.myKeyTypeSignature;
            Object key = rbsLiteralSignature instanceof RbsSymbolLiteralSignature ? (RbsNamingConventionUtils.isValidSymbolName(":" + (text = (literal = (RbsSymbolLiteralSignature)rbsLiteralSignature).getLiteral())) ? text + ":" : (!text.contains("`") ? "`%s`:".formatted(text) : String.valueOf(this.myKeyTypeSignature) + " =>")) : String.valueOf(this.myKeyTypeSignature) + " =>";
            String string = switch (this.myFieldType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> String.format("?%s %s", key, this.myValueTypeSignature);
                case 1 -> String.format("%s %s", key, this.myValueTypeSignature);
            };
            if (string == null) {
                Field.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private Field apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
            if (fun == null) {
                Field.$$$reportNull$$$0(7);
            }
            return new Field(this.myFieldType, (RbsLiteralSignature)this.myKeyTypeSignature.apply(fun), this.myValueTypeSignature.apply(fun));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyTypeSignature";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueTypeSignature";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/rbs/common/psi/data/RbsRecordTypeSignature$Field";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/rbs/common/psi/data/RbsRecordTypeSignature$Field";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyTypeSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueTypeSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static enum FieldType {
        OPTIONAL,
        REQUIRED;

    }
}

