/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.psi.data;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbsProcTypeSignature
implements RbsTypeSignature {
    private final List<Parameter> myParameters;
    private final boolean myHasUntypedParameters;
    @Nullable
    private final RbsTypeSignature mySelfTypeSignature;
    @Nullable
    private final RbsProcTypeSignature myBlockTypeSignature;
    private final boolean myIsBlockOptional;
    private final RbsTypeSignature myReturnTypeSignature;

    public RbsProcTypeSignature(@NotNull List<Parameter> parameters, @NotNull RbsTypeSignature returnTypeSignature) {
        if (parameters == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(0);
        }
        if (returnTypeSignature == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(1);
        }
        this(parameters, false, null, null, false, returnTypeSignature);
    }

    public RbsProcTypeSignature(@NotNull List<Parameter> parameters, @Nullable RbsTypeSignature selfTypeSignature, @Nullable RbsProcTypeSignature blockTypeSignature, boolean isBlockOptional, @NotNull RbsTypeSignature returnTypeSignature) {
        if (parameters == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(2);
        }
        if (returnTypeSignature == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(3);
        }
        this(parameters, false, selfTypeSignature, blockTypeSignature, isBlockOptional, returnTypeSignature);
    }

    public RbsProcTypeSignature(boolean hasUntypedParameters, @NotNull RbsTypeSignature returnTypeSignature) {
        if (returnTypeSignature == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(4);
        }
        this(Collections.emptyList(), hasUntypedParameters, null, null, true, returnTypeSignature);
    }

    public RbsProcTypeSignature(@NotNull List<Parameter> parameters, boolean hasUntypedParameters, @Nullable RbsTypeSignature selfTypeSignature, @Nullable RbsProcTypeSignature blockTypeSignature, boolean isBlockOptional, @NotNull RbsTypeSignature returnTypeSignature) {
        if (parameters == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(5);
        }
        if (returnTypeSignature == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(6);
        }
        if (!(!hasUntypedParameters || parameters.isEmpty() && selfTypeSignature == null && blockTypeSignature == null && isBlockOptional)) {
            throw new IllegalArgumentException();
        }
        this.myParameters = List.copyOf(parameters);
        this.myHasUntypedParameters = hasUntypedParameters;
        this.mySelfTypeSignature = selfTypeSignature;
        this.myBlockTypeSignature = blockTypeSignature;
        this.myIsBlockOptional = isBlockOptional;
        this.myReturnTypeSignature = returnTypeSignature;
    }

    @Override
    public void accept(@NotNull RbsTypeSignatureVisitor visitor) {
        if (visitor == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(7);
        }
        visitor.visitProcTypeSignature(this);
    }

    @Override
    @NotNull
    public RbsProcTypeSignature apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
        if (fun == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(8);
        }
        List parameters = ContainerUtil.map(this.myParameters, parameter -> parameter.apply(fun));
        RbsTypeSignature selfTypeSignature = this.mySelfTypeSignature != null ? this.mySelfTypeSignature.apply(fun) : null;
        RbsTypeSignature blockTypeSignature = this.myBlockTypeSignature != null ? this.myBlockTypeSignature.apply((Function)fun) : null;
        RbsTypeSignature returnTypeSignature = this.myReturnTypeSignature.apply(fun);
        return new RbsProcTypeSignature(parameters, this.myHasUntypedParameters, selfTypeSignature, (RbsProcTypeSignature)blockTypeSignature, this.myIsBlockOptional, returnTypeSignature);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsProcTypeSignature other = (RbsProcTypeSignature)obj;
        return this.myParameters.equals(other.myParameters) && this.myHasUntypedParameters == other.myHasUntypedParameters && Objects.equals(this.mySelfTypeSignature, other.mySelfTypeSignature) && Objects.equals(this.myBlockTypeSignature, other.myBlockTypeSignature) && this.myIsBlockOptional == other.myIsBlockOptional && this.myReturnTypeSignature.equals(other.myReturnTypeSignature);
    }

    @Nullable
    public Parameter findParameter(@NotNull ParameterType parameterType) {
        if (parameterType == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(9);
        }
        if (this.myHasUntypedParameters) {
            return new Parameter(parameterType, RbsKeywordTypeSignature.UNTYPED);
        }
        return this.findParameter(EnumSet.of(parameterType));
    }

    @Nullable
    public Parameter findParameter(@NotNull Set<ParameterType> parameterTypes) {
        if (parameterTypes == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(10);
        }
        if (this.myHasUntypedParameters && !parameterTypes.isEmpty()) {
            return new Parameter(parameterTypes.iterator().next(), RbsKeywordTypeSignature.UNTYPED);
        }
        return (Parameter)ContainerUtil.find(this.myParameters, parameter -> parameterTypes.contains((Object)parameter.getParameterType()));
    }

    @Nullable
    public Parameter findParameter(@NotNull Set<ParameterType> parameterTypes, @NotNull String name) {
        if (parameterTypes == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(11);
        }
        if (name == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(12);
        }
        if (this.myHasUntypedParameters && !parameterTypes.isEmpty()) {
            return new Parameter(parameterTypes.iterator().next(), RbsKeywordTypeSignature.UNTYPED, name);
        }
        return (Parameter)ContainerUtil.find(this.myParameters, parameter -> parameterTypes.contains((Object)parameter.getParameterType()) && name.equals(parameter.getName()));
    }

    @Nullable
    public Parameter findParameter(@NotNull Set<ParameterType> parameterTypes, int index) {
        if (parameterTypes == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(13);
        }
        if (index < 0) {
            return null;
        }
        if (this.myHasUntypedParameters) {
            return new Parameter(parameterTypes.iterator().next(), RbsKeywordTypeSignature.UNTYPED);
        }
        return (Parameter)ContainerUtil.getOrElse((List)ContainerUtil.filter(this.myParameters, parameter -> parameterTypes.contains((Object)parameter.getParameterType())), (int)index, null);
    }

    @Nullable
    public RbsProcTypeSignature getBlockTypeSignature() {
        return this.myBlockTypeSignature;
    }

    @NotNull
    public List<Parameter> getParameters() {
        List<Parameter> list = this.myParameters;
        if (list == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public RbsTypeSignature getReturnTypeSignature() {
        RbsTypeSignature rbsTypeSignature = this.myReturnTypeSignature;
        if (rbsTypeSignature == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(15);
        }
        return rbsTypeSignature;
    }

    @Nullable
    public RbsTypeSignature getSelfTypeSignature() {
        return this.mySelfTypeSignature;
    }

    public boolean hasUntypedParameters() {
        return this.myHasUntypedParameters;
    }

    public int hashCode() {
        int result = this.myParameters.hashCode();
        result = 31 * result + Boolean.hashCode(this.myHasUntypedParameters);
        result = 31 * result + Objects.hashCode(this.mySelfTypeSignature);
        result = 31 * result + Objects.hashCode(this.myBlockTypeSignature);
        result = 31 * result + Boolean.hashCode(this.myIsBlockOptional);
        result = 31 * result + this.myReturnTypeSignature.hashCode();
        return result;
    }

    public boolean isBlockOptional() {
        return this.myIsBlockOptional;
    }

    @NotNull
    public String toString() {
        String selfType;
        String parameters = this.myHasUntypedParameters ? "?" : StringUtil.join(this.myParameters, (String)", ");
        String string = selfType = this.mySelfTypeSignature != null ? "[self: %s]".formatted(this.mySelfTypeSignature) : "";
        String block = this.myBlockTypeSignature != null ? "%s{ %s }".formatted(this.myIsBlockOptional ? "?" : "", this.myBlockTypeSignature) : "";
        String string2 = StringUtil.collapseWhiteSpace((CharSequence)"^(%s) %s %s -> %s".formatted(parameters, selfType, block, this.myReturnTypeSignature));
        if (string2 == null) {
            RbsProcTypeSignature.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypeSignature";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/psi/data/RbsProcTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/psi/data/RbsProcTypeSignature";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findParameter";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static final class Parameter {
        private final ParameterType myParameterType;
        @Nullable
        private final String myKeywordName;
        private final RbsTypeSignature myTypeSignature;
        @Nullable
        private final String myVariableName;

        public Parameter(@NotNull ParameterType type, @NotNull RbsTypeSignature typeSignature) {
            if (type == null) {
                Parameter.$$$reportNull$$$0(0);
            }
            if (typeSignature == null) {
                Parameter.$$$reportNull$$$0(1);
            }
            this(type, typeSignature, null);
        }

        public Parameter(@NotNull ParameterType type, @NotNull RbsTypeSignature typeSignature, @Nullable String variableName) {
            if (type == null) {
                Parameter.$$$reportNull$$$0(2);
            }
            if (typeSignature == null) {
                Parameter.$$$reportNull$$$0(3);
            }
            this(type, null, typeSignature, variableName);
        }

        public Parameter(@NotNull ParameterType type, @Nullable String keywordName, @NotNull RbsTypeSignature typeSignature, @Nullable String variableName) {
            if (type == null) {
                Parameter.$$$reportNull$$$0(4);
            }
            if (typeSignature == null) {
                Parameter.$$$reportNull$$$0(5);
            }
            this.myParameterType = type;
            this.myKeywordName = keywordName;
            this.myTypeSignature = typeSignature;
            this.myVariableName = variableName;
        }

        @NotNull
        public Parameter apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
            if (fun == null) {
                Parameter.$$$reportNull$$$0(6);
            }
            return new Parameter(this.myParameterType, this.myKeywordName, this.myTypeSignature.apply(fun), this.myVariableName);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return this.myParameterType.equals((Object)other.myParameterType) && Objects.equals(this.myKeywordName, other.myKeywordName) && this.myTypeSignature.equals(other.myTypeSignature) && Objects.equals(this.myVariableName, other.myVariableName);
        }

        @Nullable
        public String getKeywordName() {
            return this.myKeywordName;
        }

        @Nullable
        public String getName() {
            return (String)ObjectUtils.coalesce((Object)this.myKeywordName, (Object)this.myVariableName);
        }

        @NotNull
        public ParameterType getParameterType() {
            ParameterType parameterType = this.myParameterType;
            if (parameterType == null) {
                Parameter.$$$reportNull$$$0(7);
            }
            return parameterType;
        }

        @NotNull
        public RbsTypeSignature getTypeSignature() {
            RbsTypeSignature rbsTypeSignature = this.myTypeSignature;
            if (rbsTypeSignature == null) {
                Parameter.$$$reportNull$$$0(8);
            }
            return rbsTypeSignature;
        }

        @Nullable
        public String getVariableName() {
            return this.myVariableName;
        }

        public int hashCode() {
            int result = this.myParameterType.hashCode();
            result = 31 * result + Objects.hashCode(this.myKeywordName);
            result = 31 * result + this.myTypeSignature.hashCode();
            result = 31 * result + Objects.hashCode(this.myVariableName);
            return result;
        }

        public boolean isKeyword() {
            return this.myParameterType.isKeyword();
        }

        public boolean isKeywordRest() {
            return this.myParameterType == ParameterType.KEYWORD_REST;
        }

        public boolean isPositional() {
            return this.myParameterType.isPositional();
        }

        public boolean isPositionalRest() {
            return this.myParameterType == ParameterType.POSITIONAL_REST;
        }

        public boolean isRequired() {
            return this.myParameterType.isRequired();
        }

        @NotNull
        public String toString() {
            String string = switch (this.myParameterType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> String.format("%s %s", this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
                case 1 -> String.format("?%s %s", this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
                case 2 -> String.format("*%s %s", this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
                case 3 -> String.format("%s: %s %s", this.myKeywordName, this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
                case 4 -> String.format("?%s: %s %s", this.myKeywordName, this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
                case 5 -> String.format("**%s %s", this.myTypeSignature, StringUtil.notNullize((String)this.myVariableName)).trim();
            };
            if (string == null) {
                Parameter.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeSignature";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fun";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ruby/rbs/common/psi/data/RbsProcTypeSignature$Parameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ruby/rbs/common/psi/data/RbsProcTypeSignature$Parameter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeSignature";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static enum ParameterType {
        POSITIONAL_REQUIRED,
        POSITIONAL_OPTIONAL,
        POSITIONAL_REST,
        KEYWORD_REQUIRED,
        KEYWORD_OPTIONAL,
        KEYWORD_REST;

        public static final Set<ParameterType> KEYWORD_TYPES;
        public static final Set<ParameterType> POSITIONAL_TYPES;
        public static final Set<ParameterType> REQUIRED_TYPES;

        public boolean isKeyword() {
            return KEYWORD_TYPES.contains((Object)this);
        }

        public boolean isPositional() {
            return POSITIONAL_TYPES.contains((Object)this);
        }

        public boolean isRequired() {
            return REQUIRED_TYPES.contains((Object)this);
        }

        static {
            KEYWORD_TYPES = EnumSet.of(KEYWORD_OPTIONAL, KEYWORD_REQUIRED);
            POSITIONAL_TYPES = EnumSet.of(POSITIONAL_OPTIONAL, POSITIONAL_REQUIRED);
            REQUIRED_TYPES = EnumSet.of(POSITIONAL_REQUIRED, KEYWORD_REQUIRED);
        }
    }
}

