/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.formatter.processors;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.formatter.RbsBlock;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;

public final class RbsIndentProcessor
extends RubyFormattingProcessor {
    RbsIndentProcessor(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            RbsIndentProcessor.$$$reportNull$$$0(0);
        }
        super(settings);
    }

    @NotNull
    public Indent getChildIndent(@NotNull RbsBlock parentBlock, @NotNull ASTNode childNode) {
        if (parentBlock == null) {
            RbsIndentProcessor.$$$reportNull$$$0(1);
        }
        if (childNode == null) {
            RbsIndentProcessor.$$$reportNull$$$0(2);
        }
        ASTNode parentNode = parentBlock.getNode();
        PsiElement psiParent = parentNode.getPsi();
        IElementType parentElementType = PsiUtilCore.getElementType((PsiElement)psiParent);
        IElementType childType = childNode.getElementType();
        IElementType firstParentChildType = parentNode.getFirstChildNode().getElementType();
        if ((parentElementType == RbsElementTypesGenerated.RBS_RECORD_TYPE || parentElementType == RbsElementTypesGenerated.RBS_BLOCK) && !RbsTokenSets.RBS_INDENT_ELEM_IN_BRACES.contains(childType) || parentElementType == RbsElementTypesGenerated.RBS_TYPE_LIST && (childType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE || childType == RbsElementTypesGenerated.RBS_KCOMMA) || parentElementType == RbsElementTypesGenerated.RBS_GENERICS_BOUND && (childType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE || childType == RbsElementTypesGenerated.RBS_KLT) || parentElementType == RbsElementTypesGenerated.RBS_DEFAULT_TYPE && (childType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE || childType == RbsElementTypesGenerated.RBS_KEQ) || RbsTokenSets.RBS_TYPE_PARAMS.contains(parentElementType) && childType != RbsElementTypesGenerated.RBS_GENERICS_BOUND && childType != RbsElementTypesGenerated.RBS_DEFAULT_TYPE) {
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true);
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(3);
            }
            return indent;
        }
        if (RbsTokenSets.RBS_METHOD_PARAM_TYPES.contains(parentElementType) || childType == RbsElementTypesGenerated.RBS_CLASS_NAME && parentElementType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE && firstParentChildType == RbsElementTypesGenerated.RBS_KSINGLETON || childType == RbsElementTypesGenerated.RBS_KCOMMA && parentElementType == RbsElementTypesGenerated.RBS_SIMPLE_FUNCTION_TYPE || childType == RbsElementTypesGenerated.RBS_KCOMMA && parentElementType == RbsElementTypesGenerated.RBS_MODULE_TYPE_PARAMS || childType == RbsElementTypesGenerated.RBS_DECLARATION_MEMBERS) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(4);
            }
            return indent;
        }
        if (RbsTokenSets.RBS_CHILD_TYPE_NEED_CONT_INDENT.contains(childType) || RbsTokenSets.RBS_TOP_DECLARATION_ALIAS_MEMBER.contains(parentElementType) || RbsTokenSets.RBS_USE_MEMBER.contains(childType)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(5);
            }
            return indent;
        }
        if (RbsIndentProcessor.isPartOfMethodType(parentElementType, childType) || (childType == RbsElementTypesGenerated.RBS_CLASS_NAME || childType == RbsElementTypesGenerated.RBS_INTERFACE_NAME) && RbsTokenSets.RBS_TOP_DECLARATIONS.contains(parentElementType) || childType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE && parentElementType != RbsElementTypesGenerated.RBS_SIMPLE_FUNCTION_TYPE && parentElementType != RbsElementTypesGenerated.RBS_PROC_TYPE || RbsTokenSets.RBS_TOP_DECLARATIONS_TUNE.contains(childType)) {
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(6);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            RbsIndentProcessor.$$$reportNull$$$0(7);
        }
        return indent;
    }

    @NotNull
    public Indent getNewChildIndent(@NotNull RbsBlock parentBlock, int newChildIndex) {
        IElementType parentElementType;
        if (parentBlock == null) {
            RbsIndentProcessor.$$$reportNull$$$0(8);
        }
        if (RbsTokenSets.RBS_TOP_DECLARATIONS.contains(parentElementType = parentBlock.getNode().getElementType())) {
            if (parentBlock.getSubBlocks().size() > newChildIndex + 1) {
                IElementType nextChildElementType = ASTBlock.getElementType((Block)parentBlock.getSubBlocks().get(newChildIndex + 1));
                if ((parentElementType == RbsElementTypesGenerated.RBS_CLASS_DECL || parentElementType == RbsElementTypesGenerated.RBS_MODULE_DECL) && !RbsTokenSets.RBS_CLASS_STATEMENTS.contains(nextChildElementType) || parentElementType == RbsElementTypesGenerated.RBS_INTERFACE_DECL && !RbsTokenSets.RBS_INTERFACE_STATEMENTS.contains(nextChildElementType)) {
                    Indent indent = Indent.getContinuationIndent();
                    if (indent == null) {
                        RbsIndentProcessor.$$$reportNull$$$0(9);
                    }
                    return indent;
                }
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(10);
            }
            return indent;
        }
        if ((parentElementType == RbsElementTypesGenerated.RBS_SIMPLE_FUNCTION_TYPE || parentElementType == RbsElementTypesGenerated.RBS_PROC_TYPE) && RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLPAREN, RbsElementTypesGenerated.RBS_KRPAREN) || RbsTokenSets.RBS_METHOD_PARAM_TYPES.contains(parentElementType) || (parentElementType == RbsElementTypesGenerated.RBS_BLOCK || parentElementType == RbsElementTypesGenerated.RBS_RECORD_TYPE) && RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLBRACE, RbsElementTypesGenerated.RBS_KRBRACE) || parentElementType == RbsElementTypesGenerated.RBS_SIMPLE_TYPE && (RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLPAREN, RbsElementTypesGenerated.RBS_KRPAREN) || RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLBRACKET, RbsElementTypesGenerated.RBS_KRBRACKET) || RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLBRACE, RbsElementTypesGenerated.RBS_KRBRACE)) || RbsTokenSets.RBS_TOP_DECLARATIONS_TUNE.contains(parentElementType) && RbsIndentProcessor.isNewChildBetweenParentheses((Block)parentBlock, newChildIndex, RbsElementTypesGenerated.RBS_KLBRACKET, RbsElementTypesGenerated.RBS_KRBRACKET) || parentElementType == RbsElementTypesGenerated.RBS_TYPE_LIST || parentElementType == RbsElementTypesGenerated.RBS_GENERICS_BOUND || parentElementType == RbsElementTypesGenerated.RBS_DEFAULT_TYPE || RbsTokenSets.RBS_TYPE_PARAMS.contains(parentElementType)) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(11);
            }
            return indent;
        }
        if (RbsTokenSets.RBS_NEW_CHILD_INDENT_CONT_AFTER_ENTER.contains(parentElementType)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                RbsIndentProcessor.$$$reportNull$$$0(12);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            RbsIndentProcessor.$$$reportNull$$$0(13);
        }
        return indent;
    }

    private static boolean isNewChildBetweenParentheses(@NotNull Block parentBlock, int newChildIndex, @NotNull IElementType leftParenType, @NotNull IElementType rightParenType) {
        if (parentBlock == null) {
            RbsIndentProcessor.$$$reportNull$$$0(14);
        }
        if (leftParenType == null) {
            RbsIndentProcessor.$$$reportNull$$$0(15);
        }
        if (rightParenType == null) {
            RbsIndentProcessor.$$$reportNull$$$0(16);
        }
        int countParenthesesBeforeNewChild = 0;
        List previousChildren = parentBlock.getSubBlocks().subList(0, newChildIndex);
        for (Block prevChild : previousChildren) {
            IElementType prevChildType = ASTBlock.getElementType((Block)prevChild);
            if (prevChildType == leftParenType) {
                ++countParenthesesBeforeNewChild;
            }
            if (prevChildType != rightParenType) continue;
            --countParenthesesBeforeNewChild;
        }
        return countParenthesesBeforeNewChild > 0;
    }

    private static boolean isPartOfMethodType(@NotNull IElementType parentElementType, @NotNull IElementType childType) {
        if (parentElementType == null) {
            RbsIndentProcessor.$$$reportNull$$$0(17);
        }
        if (childType == null) {
            RbsIndentProcessor.$$$reportNull$$$0(18);
        }
        return parentElementType == RbsElementTypesGenerated.RBS_METHOD_TYPE && RbsTokenSets.RBS_METHOD_TYPE_ELEMENTS.contains(childType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/formatter/processors/RbsIndentProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/formatter/processors/RbsIndentProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewChildIndent";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNewChildBetweenParentheses";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfMethodType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

