/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.ruby.rbs.common.formatter.processors.RbsFormattingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsBlock
implements ASTBlock {
    private final ASTNode myNode;
    private final Indent myIndent;
    private final RbsFormattingHelper myHelper;
    private final Wrap myWrap;
    private final TextRange myTextRange;
    private final NotNullLazyValue<List<Block>> mySubBlocks;

    public RbsBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull RbsFormattingHelper helper) {
        if (node == null) {
            RbsBlock.$$$reportNull$$$0(0);
        }
        if (indent == null) {
            RbsBlock.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            RbsBlock.$$$reportNull$$$0(2);
        }
        this.mySubBlocks = NotNullLazyValue.lazy(() -> this.generateSubBlocks());
        this.myNode = node;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myHelper = helper;
        this.myTextRange = node.getTextRange();
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            RbsBlock.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            RbsBlock.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List list = (List)this.mySubBlocks.getValue();
        if (list == null) {
            RbsBlock.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            RbsBlock.$$$reportNull$$$0(6);
        }
        return this.myHelper.getSpacingProcessor().getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.myHelper.getIndentProcessor().getNewChildIndent(this, newChildIndex), null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return this.getSubBlocks().isEmpty();
    }

    @NotNull
    private List<Block> generateSubBlocks() {
        ASTNode[] nodeChildren = this.myNode.getChildren(null);
        if (nodeChildren.length == 0) {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                RbsBlock.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        for (ASTNode childNode : nodeChildren) {
            if (!RbsBlock.canBeCorrectBlock(childNode)) continue;
            RbsBlock childBlock = new RbsBlock(childNode, this.myHelper.getIndentProcessor().getChildIndent(this, childNode), this.myHelper.getWrapProcessor().getChildWrap(), this.myHelper);
            subBlocks.add((Block)childBlock);
        }
        ArrayList<Block> arrayList = subBlocks;
        if (arrayList == null) {
            RbsBlock.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean canBeCorrectBlock(@NotNull ASTNode node) {
        if (node == null) {
            RbsBlock.$$$reportNull$$$0(9);
        }
        return !node.getText().trim().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/formatter/RbsBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/formatter/RbsBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBeCorrectBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

