/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import org.jetbrains.annotations.NotNull;

public final class RbsSpaceTypedHandler
extends TypedHandlerDelegate {
    private static final int MINIMUM_OFFSET = "alias self.a".length();
    @NotNull
    @NlsSafe
    private static final String SELF = " self.";

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(3);
        }
        if (c != ' ' || !RbsPsiUtil.isRbsFile(file) || !RbsSpaceTypedHandler.shouldInsertSelf(editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RbsSpaceTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)SELF, (boolean)false, (int)6);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
        if (result == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    private static boolean shouldInsertSelf(@NotNull Editor editor) {
        int offset;
        if (editor == null) {
            RbsSpaceTypedHandler.$$$reportNull$$$0(6);
        }
        if ((offset = editor.getCaretModel().getOffset()) < MINIMUM_OFFSET) {
            return false;
        }
        HighlighterIterator iterator = editor.getHighlighter().createIterator(offset - 1);
        if (iterator.getTokenType() != RbsElementTypesGenerated.RBS_TMETHOD_NAME) {
            return false;
        }
        iterator.retreat();
        if (iterator.getTokenType() != RbsElementTypesGenerated.RBS_KDOT) {
            return false;
        }
        iterator.retreat();
        if (iterator.getTokenType() != RbsElementTypesGenerated.RBS_KSELF) {
            return false;
        }
        iterator.retreat();
        if (iterator.getTokenType() != TokenType.WHITE_SPACE) {
            return false;
        }
        iterator.retreat();
        return iterator.getTokenType() == RbsElementTypesGenerated.RBS_KALIAS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/editor/RbsSpaceTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/editor/RbsSpaceTypedHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertSelf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

