/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.editor;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsQuoteHandler
implements QuoteHandler,
MultiCharQuoteHandler {
    private static final String OPEN_ANNOTATION_QUOTES = "{[(<|";
    private static final String CLOSE_ANNOTATION_QUOTES = "}])>|";
    private static final String NORMAL_QUOTES = "\"'`";
    private static final String OPEN_QUOTES = "{[(<|\"'`";
    private static final String CLOSE_QUOTES = "}])>|\"'`";

    RbsQuoteHandler() {
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        return RbsTokenSets.RBS_CLOSE_QUOTES.contains(iterator.getTokenType());
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            RbsQuoteHandler.$$$reportNull$$$0(0);
        }
        if (offset < 1) {
            return null;
        }
        while (iterator.getEnd() > offset && iterator.getStart() > 0) {
            iterator.retreat();
        }
        if (iterator.getTokenType() != RbsElementTypesGenerated.RBS_LAQUOTE) {
            return null;
        }
        char closeQuote = RbsQuoteHandler.getCloseQuoteChar(iterator.getDocument().getCharsSequence().charAt(offset - 1));
        return closeQuote == '\u0000' ? null : String.valueOf(closeQuote);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if ((tokenType == TokenType.BAD_CHARACTER || tokenType == RbsElementTypesGenerated.RBS_TMETHOD_NAME) && iterator.getDocument().getCharsSequence().charAt(offset) == '`') {
            return true;
        }
        return RbsTokenSets.RBS_OPEN_QUOTES.contains(tokenType);
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        return !iterator.atEnd() && !RbsTokenSets.RBS_CLOSE_QUOTES.contains(iterator.getTokenType());
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return RbsTokenSets.RBS_LITERALS.contains(iterator.getTokenType());
    }

    static char getCloseQuoteChar(char openQuote) {
        int quoteIndex = OPEN_QUOTES.indexOf(openQuote);
        return quoteIndex < 0 ? (char)'\u0000' : CLOSE_QUOTES.charAt(quoteIndex);
    }

    static char getAnnotationCloseQuoteChar(char openQuote) {
        int quoteIndex = OPEN_ANNOTATION_QUOTES.indexOf(openQuote);
        return quoteIndex < 0 ? (char)'\u0000' : CLOSE_ANNOTATION_QUOTES.charAt(quoteIndex);
    }

    static char getOpenQuoteChar(char closeQuote) {
        int quoteIndex = CLOSE_QUOTES.indexOf(closeQuote);
        return quoteIndex < 0 ? (char)'\u0000' : OPEN_QUOTES.charAt(quoteIndex);
    }

    static char getAnnotationOpenQuoteChar(char closeQuote) {
        int quoteIndex = CLOSE_ANNOTATION_QUOTES.indexOf(closeQuote);
        return quoteIndex < 0 ? (char)'\u0000' : OPEN_ANNOTATION_QUOTES.charAt(quoteIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/ruby/rbs/common/editor/RbsQuoteHandler", "getClosingQuote"));
    }
}

