/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.RbsLanguage;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class RbsEndInsertHandler
implements EnterHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(RbsEndInsertHandler.class);

    RbsEndInsertHandler() {
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(2);
        }
        if (RbsPsiUtil.isRbsFile(file)) {
            RbsEndInsertHandler.addMissingEndsAtCaretLine(file, editor);
        } else {
            LOG.debug("Not our file: ", new Object[]{file});
        }
        return super.postProcessEnter(file, editor, dataContext);
    }

    private static void addMissingEndsAtCaretLine(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(4);
        }
        if (RbsEndInsertHandler.shouldInsertEnd(editor, file)) {
            LOG.debug("We should append end after caret");
            int currentOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            int offsetToInsert = CharArrayUtil.shiftForwardUntil((CharSequence)document.getCharsSequence(), (int)currentOffset, (String)"\n\r");
            document.insertString(offsetToInsert, (CharSequence)"\nend");
            RbsEndInsertHandler.commitAndReFormatAffectedContainers(file, editor);
        } else {
            LOG.debug("We should not append end after caret");
        }
    }

    private static boolean shouldInsertEnd(@NotNull Editor editor, @NotNull PsiFile file) {
        int currentOffset;
        if (editor == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(6);
        }
        if ((currentOffset = editor.getCaretModel().getOffset()) < 1) {
            LOG.debug("We are sure that we are not in declaration line.");
            return false;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        return RbsEndInsertHandler.isInsideDeclaration(file, currentOffset) && RbsEndInsertHandler.getBeginEndBalance(file) > 0;
    }

    private static boolean isInsideDeclaration(@NotNull PsiFile file, int offset) {
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(7);
        }
        for (PsiElement currentPsiElement = file.findElementAt(offset - 1); currentPsiElement != null; currentPsiElement = currentPsiElement.getParent()) {
            IElementType currentElementType = PsiUtilCore.getElementType((PsiElement)currentPsiElement);
            if (currentElementType == RbsElementTypesGenerated.RBS_DECLARATION_MEMBERS) {
                return false;
            }
            if (!RbsTokenSets.RBS_TOP_DECLARATIONS.contains(currentElementType)) continue;
            return true;
        }
        return false;
    }

    public static int getBeginEndBalance(@NotNull PsiFile file) {
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        int balance = 0;
        while (psiElement != null) {
            IElementType parentElementType;
            IElementType tokenType = PsiUtilCore.getElementType((PsiElement)psiElement);
            if (tokenType == RbsElementTypesGenerated.RBS_KEND) {
                if (--balance < 0) {
                    return balance;
                }
            } else if (RbsTokenSets.RBS_END_OPENERS.contains(tokenType) && !RbsTokenSets.RBS_TOP_DECLARATION_ALIAS.contains(parentElementType = PsiUtilCore.getElementType((PsiElement)psiElement.getParent()))) {
                ++balance;
            }
            psiElement = PsiTreeUtil.nextLeaf((PsiElement)psiElement);
        }
        return balance;
    }

    private static void commitAndReFormatAffectedContainers(@NotNull PsiFile file, @NotNull Editor editor) {
        Project project;
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(10);
        }
        if ((project = editor.getProject()) == null) {
            LOG.debug("Project is null, unable to reformat");
            return;
        }
        RbsEndInsertHandler.commitAndReformatCurrentContainer(file, editor, project, 0, true);
    }

    public static boolean commitAndReformatCurrentContainer(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Project project, int caretShiftLeftOffset, boolean adjustLineIndent) {
        if (file == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(12);
        }
        if (project == null) {
            RbsEndInsertHandler.$$$reportNull$$$0(13);
        }
        CaretModel caretModel = editor.getCaretModel();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement rbsElementAtCaret = file.getViewProvider().findElementAt(caretModel.getOffset() - caretShiftLeftOffset, RbsLanguage.getInstance());
        if (rbsElementAtCaret == null) {
            LOG.debug("No rbs element at caret, unable to reformat");
            return false;
        }
        ASTNode rbsNode = rbsElementAtCaret.getNode();
        PsiElement containerToReformat = RbsTokenSets.RBS_CONTAINERS.contains(rbsNode.getElementType()) ? rbsElementAtCaret : (PsiElement)ObjectUtils.doIfNotNull((Object)TreeUtil.findParent((ASTNode)rbsElementAtCaret.getNode(), (TokenSet)RbsTokenSets.RBS_CONTAINERS), ASTNode::getPsi);
        if (containerToReformat != null) {
            LOG.debug("Re-formatting container: ", new Object[]{containerToReformat.getNode()});
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformatText(file, Collections.singletonList(containerToReformat.getTextRange()));
            if (adjustLineIndent) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                codeStyleManager.adjustLineIndent(file, caretModel.getOffset() - caretShiftLeftOffset);
            }
            return true;
        }
        LOG.debug("Unable to re-format, no class-like container at offset: ", new Object[]{caretModel.getOffset() - caretShiftLeftOffset});
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ruby/rbs/common/editor/RbsEndInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addMissingEndsAtCaretLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInsertEnd";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeginEndBalance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "commitAndReFormatAffectedContainers";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "commitAndReformatCurrentContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

