/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.rbs.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ruby.rbs.common.psi.data.RbsAttributeType;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import icons.RubyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class RbsIcons {
    public static final Icon RBS_FILE_ICON = RubyIcons.Rbs.RbsFile;
    public static final Icon RBS_CLASS_ICON = AllIcons.Nodes.Class;
    public static final Icon RBS_MODULE_ICON = RubyIcons.Ruby.Nodes.Module;
    public static final Icon RBS_INTERFACE_ICON = AllIcons.Nodes.Interface;
    public static final Icon RBS_CONSTANT_ICON = AllIcons.Nodes.Constant;
    public static final Icon RBS_TYPE_ALIAS_ICON = AllIcons.Nodes.Type;
    public static final Icon RBS_TYPE_VARIABLE_ICON = AllIcons.Nodes.Type;
    public static final Icon RBS_GLOBAL_VARIABLE_ICON = AllIcons.Nodes.Gvariable;
    public static final Icon RBS_CLASS_VARIABLE_ICON = LayeredIcon.layeredIcon(() -> new Icon[]{RubyIcons.Ruby.Nodes.Variable, AllIcons.Nodes.StaticMark});
    public static final Icon RBS_INSTANCE_VARIABLE_ICON = RubyIcons.Ruby.Nodes.Variable;
    public static final Icon RBS_PUBLIC_ATTRIBUTE_ACCESSOR_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_ACCESSOR, RbsVisibility.PUBLIC_VISIBILITY);
    public static final Icon RBS_PUBLIC_ATTRIBUTE_READER_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_READER, RbsVisibility.PUBLIC_VISIBILITY);
    public static final Icon RBS_PUBLIC_ATTRIBUTE_WRITER_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_WRITER, RbsVisibility.PUBLIC_VISIBILITY);
    public static final Icon RBS_PRIVATE_ATTRIBUTE_ACCESSOR_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_ACCESSOR, RbsVisibility.PRIVATE_VISIBILITY);
    public static final Icon RBS_PRIVATE_ATTRIBUTE_READER_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_READER, RbsVisibility.PRIVATE_VISIBILITY);
    public static final Icon RBS_PRIVATE_ATTRIBUTE_WRITER_ICON = RbsIcons.createAttributeIconWithVisibility(RbsAttributeType.ATTRIBUTE_WRITER, RbsVisibility.PRIVATE_VISIBILITY);
    public static final Icon RBS_PUBLIC_METHOD_ICON = RbsIcons.createIconWithVisibility(AllIcons.Nodes.Method, RbsVisibility.PUBLIC_VISIBILITY);
    public static final Icon RBS_PRIVATE_METHOD_ICON = RbsIcons.createIconWithVisibility(AllIcons.Nodes.Method, RbsVisibility.PRIVATE_VISIBILITY);
    public static final Icon RBS_METHOD_ALIAS_ICON = AllIcons.Nodes.Alias;
    public static final Icon RBS_MODULE_METHOD_ICON = RBS_PUBLIC_METHOD_ICON;
    public static final Icon RBS_PARAMETER_ICON = AllIcons.Nodes.Parameter;
    public static final Icon RBS_USE_CLAUSE_ALIAS_ICON = AllIcons.Nodes.Alias;
    public static final Icon RBS_LIBRARY_ICON = AllIcons.Nodes.PpLibFolder;
    public static final Icon RBS_COLLECTION_LIBRARY_ICON = AllIcons.Nodes.PpLibFolder;

    private RbsIcons() {
    }

    @NotNull
    private static Icon createAttributeIconWithVisibility(@NotNull RbsAttributeType attributeType, @NotNull RbsVisibility visibility) {
        if (attributeType == null) {
            RbsIcons.$$$reportNull$$$0(0);
        }
        if (visibility == null) {
            RbsIcons.$$$reportNull$$$0(1);
        }
        LayeredIcon icon = switch (attributeType) {
            default -> throw new MatchException(null, null);
            case RbsAttributeType.ATTRIBUTE_ACCESSOR -> LayeredIcon.layeredIcon(() -> new Icon[]{RubyIcons.Ruby.Nodes.Variable, RubyIcons.Ruby.Reader, RubyIcons.Ruby.Writer});
            case RbsAttributeType.ATTRIBUTE_READER -> LayeredIcon.layeredIcon(() -> new Icon[]{RubyIcons.Ruby.Nodes.Variable, RubyIcons.Ruby.Reader});
            case RbsAttributeType.ATTRIBUTE_WRITER -> LayeredIcon.layeredIcon(() -> new Icon[]{RubyIcons.Ruby.Nodes.Variable, RubyIcons.Ruby.Writer});
        };
        return RbsIcons.createIconWithVisibility((Icon)icon, visibility);
    }

    @NotNull
    private static Icon createIconWithVisibility(@NotNull Icon baseIcon, @NotNull RbsVisibility visibility) {
        if (baseIcon == null) {
            RbsIcons.$$$reportNull$$$0(2);
        }
        if (visibility == null) {
            RbsIcons.$$$reportNull$$$0(3);
        }
        Icon visibilityIcon = visibility == RbsVisibility.PUBLIC_VISIBILITY ? AllIcons.Nodes.C_public : AllIcons.Nodes.C_private;
        Icon icon = IconLoader.createLazy(() -> IconManager.getInstance().createRowIcon(new Icon[]{baseIcon, visibilityIcon}));
        if (icon == null) {
            RbsIcons.$$$reportNull$$$0(4);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIcon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/rbs/common/RbsIcons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/rbs/common/RbsIcons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconWithVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeIconWithVisibility";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIconWithVisibility";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

