/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage.run;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.IOException;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.coverage.RCovBundle;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEnabledConfiguration;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageSuite;
import org.jetbrains.plugins.ruby.coverage.run.RubyCoverageRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;

public class RubyCoverageSuiteListener
implements CoverageSuiteListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(RubyCoverageSuiteListener.class);
    private final Project myProject;

    public RubyCoverageSuiteListener(@NotNull Project project) {
        if (project == null) {
            RubyCoverageSuiteListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance((Project)this.myProject);
        coverageDataManager.addSuiteListener((CoverageSuiteListener)this, (Disposable)this);
    }

    @RequiresBackgroundThread
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            RubyCoverageSuiteListener.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!(suite instanceof RubyCoverageSuite)) {
            LOG.debug("Suite isn't a RubyCoverageSuite: " + suite.getClass().getName());
            return;
        }
        RunConfigurationBase runConf = ((RubyCoverageSuite)suite).getConfiguration();
        if (!(runConf instanceof AbstractRubyRunConfiguration)) {
            LOG.debug("RunConfiguration isn't an AbstractRubyRunConfiguration: " + (runConf != null ? runConf.getClass().getName() : null));
            return;
        }
        AbstractRubyRunConfiguration rubyConf = (AbstractRubyRunConfiguration)runConf;
        Sdk sdk = rubyConf.getSdk();
        String coverageFilePath = (String)rubyConf.getCopyableUserData(RubyCoverageRunConfigurationExtension.SIMPLECOV_COVERAGE_PATH_KEY);
        RubyCoverageEnabledConfiguration covEnabledConf = RubyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)rubyConf);
        if (coverageFilePath == null || covEnabledConf == null) {
            LOG.warn("Temporary path or coverage enabled configuration is null! TmpPath: " + coverageFilePath + ", covEnabledConf: " + String.valueOf((Object)covEnabledConf));
            return;
        }
        String targetPath = covEnabledConf.getCoverageFilePath();
        if (StringUtil.isEmpty((String)targetPath)) {
            LOG.warn("Target path is not set: " + String.valueOf((Object)covEnabledConf));
            return;
        }
        String name = Paths.get(coverageFilePath, new String[0]).getFileName().toString();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            RubySdkTransfer transfer = RubySdkTransfer.from((Sdk)sdk);
            if (transfer == null) {
                LOG.warn("Could not create remote transfer for " + String.valueOf(sdk));
                return;
            }
            try {
                transfer.moveFileToLocalPath(coverageFilePath, PathUtil.getParentPath((String)targetPath), true, ProgressManager.getInstance().getProgressIndicator());
            }
            catch (IOException e) {
                new Notification("System Messages", RCovBundle.message("rcov.alert.title", new Object[0]), RCovBundle.message("rcov.error.cannot.transfer.coverage.report", new Object[0]), NotificationType.ERROR).notify(this.myProject);
                LOG.warn("Error while moving coverage report: ", (Throwable)e);
            }
        }, RBundle.message((String)"file.system.moving.file", (Object[])new Object[]{name}), false, this.myProject);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/run/RubyCoverageSuiteListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "coverageGathered";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

