/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage.run;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovBundle;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageEnabledConfiguration;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageUtil;
import org.jetbrains.plugins.ruby.coverage.run.RCovPattern;
import org.jetbrains.plugins.ruby.coverage.run.RubyCoverageSettingsEditor;
import org.jetbrains.plugins.ruby.coverage.run.RubyCoverageSuiteListener;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.ui.RubySdkRenderer;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingProjectCollector;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class RubyCoverageRunConfigurationExtension
extends RubyRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(RubyCoverageRunConfigurationExtension.class);
    private static final String ID = "RubyCoverageRunConfigurationExtension";
    private static final String SIMPLECOV_WRONG_CONFIG_MESSAGE_ENV = "SIMPLECOV_WRONG_CONFIG_MESSAGE";
    private static final String UNSUPPORTED_BRANCH_COVERAGE_WARNING_ENV = "UNSUPPORTED_BRANCH_COVERAGE_WARNING";
    private static final String UNSUPPORTED_FORKED_COVERAGE_WARNING_ENV = "UNSUPPORTED_FORKED_COVERAGE_WARNING";
    private static final String SIMPLECOV_ENABLE_BRANCH_COVERAGE_KEY = "ENABLE_BRANCH_COVERAGE";
    private static final String SIMPLECOV_ENABLE_FORKED_COVERAGE_KEY = "ENABLE_FORKED_COVERAGE";
    public static final String SIMPLECOV_GEM_NAME = "simplecov";
    private static final String SIMPLECOV_COVERAGE_PATH_ENV_VARIABLE = "RUBYMINE_SIMPLECOV_COVERAGE_PATH";
    static final Key<String> SIMPLECOV_COVERAGE_PATH_KEY = Key.create((String)"RUBYMINE_SIMPLECOV_COVERAGE_PATH");
    private static final String RSIMPLECOV_STARTER = "rb/simplecov_starter.rb";
    private static final String RUBY_COVERAGE_PARAMS_GROUP_ID = "ruby.rcov";
    public static final String RCOV_NOTIFICATION_GROUP = "RCov.Notification";

    @NotNull
    public String getSerializationId() {
        return ID;
    }

    public void attachToProcess(@NotNull AbstractRubyRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        CoverageHelper.attachToProcess((RunConfigurationBase)configuration, (ProcessHandler)handler, (RunnerSettings)runnerSettings);
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        CoverageHelper.doReadExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        CoverageHelper.doWriteExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected <T extends AbstractRubyRunConfiguration<?>> SettingsEditor<T> createEditor(@NotNull T configuration) {
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        return new RubyCoverageSettingsEditor(configuration.getProject());
    }

    protected String getEditorTitle() {
        return CoverageEngine.getEditorTitle();
    }

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        return !AbstractRubyRunConfiguration.isScratchRunConfiguration((AbstractRubyRunConfiguration)configuration) && this.isSupportedBySdk(configuration.getSdk());
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        return (runnerSettings == null || runnerSettings instanceof CoverageRunnerData) && this.isApplicableFor(applicableConfiguration);
    }

    protected boolean isSupportedBySdk(@Nullable Sdk sdk) {
        RubySdkConfigurator sdkConfigurator = RubySdkConfigurator.from((Sdk)sdk);
        return sdkConfigurator != null && sdkConfigurator.supportsGenericCoverageRunning();
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (cmdLine == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        if (runnerId == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (!(runnerSettings instanceof CoverageRunnerData)) {
            return;
        }
        if (!this.isApplicableFor(configuration)) {
            return;
        }
        RubyCoverageEnabledConfiguration covConfig = RubyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration);
        LOG.assertTrue(covConfig != null);
        Module module = configuration.getModule();
        if (configuration.shouldUseAlternativeSdk()) {
            LOG.assertTrue(module != null);
        }
        Map env = cmdLine.getEnvironment();
        Sdk sdk = configuration.getSdk();
        assert (sdk != null) : "Sdk must not be null here";
        if (JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            OSUtil.appendToEnvVariable((String)(JRubySdkUtil.isJRubyGreaterThan17((Sdk)sdk) ? "JRUBY_OPTS" : "RUBYOPT"), (String)"--debug", (Map)env, (String)" ");
        }
        SpringUtil.disableSpring((Map)env);
        Project project = configuration.getProject();
        if (RubyCoverageUtil.isSimplecovGemPresent(configuration, module, sdk)) {
            this.patchCmdlineForSimpleCov(sdk, project, module, covConfig, cmdLine);
        } else {
            this.handleSimpleCovNotFound(module, sdk);
        }
        project.getService(RubyCoverageSuiteListener.class);
    }

    protected boolean canInstallGem() {
        return true;
    }

    public void handleSimpleCovNotFound(@Nullable Module module, @NotNull Sdk sdk) throws ExecutionException {
        RFile gemfile;
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(12);
        }
        if ((gemfile = BundlerUtil.getGemfilePsiFile((Module)module)) != null) {
            if (!BundlerUtil.isGemMentioned((RFile)gemfile, (Sdk)sdk, (String)SIMPLECOV_GEM_NAME)) {
                this.showSimpleCovNotFoundInGemfileError(module, sdk, gemfile);
            } else if (BundlerGemInfrastructure.hasMissingGems((VirtualFile)gemfile.getVirtualFile())) {
                this.showSimpleCovNotFoundInModuleError(module, sdk);
            } else {
                this.showSimpleCovNotFoundInSdkError(module, sdk);
            }
        } else {
            this.showSimpleCovNotFoundInSdkError(module, sdk);
        }
        throw new CantRunException.CustomProcessedCantRunException();
    }

    private void showSimpleCovNotFoundInSdkError(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        DumbAwareAction action = this.canInstallGem() ? DumbAwareAction.create((String)RCovBundle.message("rcov.action.run.gem.install.simplecov.text", SIMPLECOV_GEM_NAME), e -> {
            try {
                if (module != null && module.isDisposed()) {
                    return;
                }
                HashMap errors = new HashMap();
                GemInstallUtil.installGemsInBackground((Sdk)sdk, (Module)module, (Collection)GemDependency.anyAsList((String)SIMPLECOV_GEM_NAME), (GemInstallCommandOptions)new GemInstallCommandOptions().withNoDocument(), (GemInstallProcessOptions)new GemInstallProcessOptions(errors).withShowingErrors());
                String errorsText = GemUiUtil.buildInstallErrorsText(errors);
                if (errorsText != null) {
                    LOG.warn(errorsText);
                }
            }
            finally {
                Notification.get((AnActionEvent)e).expire();
            }
        }) : null;
        String title = RCovBundle.message("rcov.notification.title.simplecov.not.found", new Object[0]);
        String message = RCovBundle.message("rcov.notification.content.simplecov.not.found.in.sdk", RubySdkRenderer.getSdkText((Sdk)sdk));
        this.showSimpleCovError(title, message, (AnAction)action);
    }

    private void showSimpleCovNotFoundInModuleError(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        DumbAwareAction action = this.canInstallGem() ? DumbAwareAction.create((String)RCovBundle.message("rcov.action.run.bundle.install.text", new Object[0]), e -> {
            try {
                if (module.isDisposed()) {
                    return;
                }
                RunBundlerInstallAction bundlerInstallAction = (RunBundlerInstallAction)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction"), RunBundlerInstallAction.class);
                if (bundlerInstallAction == null) {
                    LOG.warn("Bundler install action not found");
                    return;
                }
                bundlerInstallAction.setPostFlightAction(() -> {
                    RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, false);
                    RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
                });
                bundlerInstallAction.actionPerformed(e);
            }
            finally {
                Notification.get((AnActionEvent)e).expire();
            }
        }) : null;
        String title = RCovBundle.message("rcov.notification.title.simplecov.not.found", new Object[0]);
        String message = RCovBundle.message("rcov.notification.content.simplecov.not.found.in.module", module.getName());
        this.showSimpleCovError(title, message, (AnAction)action);
    }

    private void showSimpleCovNotFoundInGemfileError(@NotNull Module module, @NotNull Sdk sdk, @NotNull RFile gemfile) {
        if (module == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(17);
        }
        if (gemfile == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(18);
        }
        DumbAwareAction action = !RubyRemoteInterpreterManager.isRemoteSdk((Sdk)sdk) ? DumbAwareAction.create((String)RCovBundle.message("rcov.gemfile.add.simplecov.gem", SIMPLECOV_GEM_NAME), e -> {
            try {
                if (module.isDisposed()) {
                    return;
                }
                Project project = module.getProject();
                String command = RCovBundle.message("rcov.gemfile.add.simplecov.gem", SIMPLECOV_GEM_NAME);
                WriteCommandAction.runWriteCommandAction((Project)project, (String)command, null, () -> {
                    int offset = BundlerUtil.addGemToGemfile((RFile)gemfile, (String)SIMPLECOV_GEM_NAME, (String)"test", null);
                    VirtualFile gemfileVirtualFile = gemfile.getVirtualFile();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (gemfileVirtualFile != null) {
                            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, gemfileVirtualFile, offset), true);
                        }
                    });
                    GemRequirementsChangeWatcher.getInstance((Module)module).addFileScan(gemfileVirtualFile);
                }, (PsiFile[])new PsiFile[0]);
            }
            finally {
                Notification.get((AnActionEvent)e).expire();
            }
        }) : null;
        String title = RCovBundle.message("rcov.notification.title.simplecov.not.found", new Object[0]);
        String message = RCovBundle.message("rcov.notification.content.simplecov.missing.from.gemfile", new Object[0]);
        this.showSimpleCovError(title, message, (AnAction)action);
    }

    public void showSimpleCovError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @Nullable AnAction action) {
        if (title == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(19);
        }
        if (message == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(20);
        }
        Notification notification = new Notification(RCOV_NOTIFICATION_GROUP, title, message, NotificationType.ERROR);
        if (action != null) {
            notification.addAction(action);
        }
        Notifications.Bus.notify((Notification)notification);
    }

    private void patchCmdlineForSimpleCov(@NotNull Sdk sdk, @NotNull Project project, @Nullable Module module, @NotNull RubyCoverageEnabledConfiguration covConfig, @NotNull GeneralCommandLine cmdLine) {
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(21);
        }
        if (project == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(22);
        }
        if (covConfig == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(23);
        }
        if (cmdLine == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(24);
        }
        Map env = cmdLine.getEnvironment();
        RubyCoverageRunConfigurationExtension.addSimpleCovStarter(cmdLine, sdk, module);
        String path = this.getCoverageFilePath(covConfig);
        @Nullable RubySdkTransfer transfer = RubySdkTransfer.from((Sdk)sdk);
        Object coveragePath = transfer != null && path != null ? transfer.getTmpPath() + transfer.getFileSeparator() + new File(path).getName() : path;
        env.put(SIMPLECOV_COVERAGE_PATH_ENV_VARIABLE, coveragePath);
        covConfig.getConfiguration().putCopyableUserData(SIMPLECOV_COVERAGE_PATH_KEY, coveragePath);
        env.put(SIMPLECOV_WRONG_CONFIG_MESSAGE_ENV, RCovBundle.message("rcov.coverage.criterion.cant.be.set", new Object[0]));
        env.put(UNSUPPORTED_BRANCH_COVERAGE_WARNING_ENV, RCovBundle.message("rcov.coverage.branch.unsupported", new Object[0]));
        env.put(UNSUPPORTED_FORKED_COVERAGE_WARNING_ENV, RCovBundle.message("rcov.coverage.forked.unsupported", new Object[0]));
        GemInfo gem = null;
        if (module != null) {
            gem = RubyProjectGemSearchService.Companion.findGem(module, SIMPLECOV_GEM_NAME);
        }
        if (gem == null) {
            gem = RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)SIMPLECOV_GEM_NAME);
        }
        if (gem != null) {
            String version = gem.getVersion();
            if (covConfig.isEnableBranchCoverage() && VersionComparatorUtil.compare((String)version, (String)"0.18") >= 0) {
                env.put(SIMPLECOV_ENABLE_BRANCH_COVERAGE_KEY, String.valueOf(true));
            }
            if (covConfig.isEnableForkedCoverage() && VersionComparatorUtil.compare((String)version, (String)"0.19") >= 0) {
                env.put(SIMPLECOV_ENABLE_FORKED_COVERAGE_KEY, String.valueOf(true));
            }
        }
        boolean containsIncludePatterns = false;
        int i = 0;
        for (Pair<RCovPattern, Boolean> patternAndEnabled : covConfig.getAllPatterns()) {
            if (!((Boolean)patternAndEnabled.second).booleanValue()) continue;
            if (!((RCovPattern)patternAndEnabled.first).isIncluded()) {
                int j;
                String regexpsStr = ((RCovPattern)patternAndEnabled.first).getRegexps();
                String[] strings = regexpsStr.split(",");
                StringBuilder buff = new StringBuilder();
                ArrayList<String> regexps = new ArrayList<String>();
                int length = strings.length;
                for (j = 0; j < length; ++j) {
                    String str = strings[j];
                    buff.append(str);
                    if (j == length - 1) {
                        regexps.add(buff.toString().trim());
                        continue;
                    }
                    if (j + 1 < length) {
                        if (strings[j + 1].trim().startsWith("/") && !buff.isEmpty() && buff.toString().trim().endsWith("/")) {
                            regexps.add(buff.toString().trim());
                            buff.setLength(0);
                            continue;
                        }
                        buff.append(',');
                        continue;
                    }
                    regexps.add(str.trim());
                }
                int size = regexps.size();
                for (j = 0; j < size; ++j) {
                    env.put("RUBYMINE_SIMPLECOV_EXCLUDE_" + (i + j), (String)regexps.get(j));
                }
                ++i;
                continue;
            }
            containsIncludePatterns = true;
        }
        if (containsIncludePatterns) {
            String msg = RCovBundle.message("rcov.run.conf.extension.include.patterns.not.supported.simplecov", new Object[0]);
            String title = RCovBundle.message("rcov.run.conf.extension.simplecov.title", new Object[0]);
            Messages.showWarningDialog((Project)project, (String)msg, (String)title);
        }
    }

    private static void addSimpleCovStarter(@NotNull GeneralCommandLine cmdLine, @NotNull Sdk sdk, @Nullable Module module) {
        if (cmdLine == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(25);
        }
        if (sdk == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(26);
        }
        String starterFullPath = Objects.requireNonNull(RubyUtil.getScriptFullPath((String)RSIMPLECOV_STARTER), "Failed to locate starter script: rb/simplecov_starter.rb");
        cmdLine.getParametersList().addParamsGroupAt(0, RUBY_COVERAGE_PARAMS_GROUP_ID).addParameters(new String[]{"-r", RubySdkUtil.convertToRemote((Sdk)sdk, (Module)module, (String)starterFullPath)});
    }

    public void validateConfiguration(@NotNull AbstractRubyRunConfiguration configuration, boolean isExecution) throws RuntimeConfigurationError {
        RubyCoverageEnabledConfiguration covConfig;
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(27);
        }
        LOG.assertTrue((covConfig = RubyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration)) != null);
        RunConfigurationUtil.inspectSDK((AbstractRubyRunConfiguration)configuration);
    }

    protected void extendCreatedConfiguration(@NotNull AbstractRubyRunConfiguration configuration, @NotNull Location location) {
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(28);
        }
        if (location == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(29);
        }
    }

    protected void extendTemplateConfiguration(@NotNull AbstractRubyRunConfiguration configuration) {
        RubyCoverageEnabledConfiguration conf;
        if (configuration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(30);
        }
        LOG.assertTrue((conf = RubyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration)) != null);
        conf.setTrackTestFolders(true);
        conf.setEnableBranchCoverage(true);
        conf.setEnableForkedCoverage(true);
        if (SystemInfo.isUnix) {
            ArrayList<Pair<RCovPattern, Boolean>> patterns = new ArrayList<Pair<RCovPattern, Boolean>>();
            patterns.add(new Pair((Object)new RCovPattern("/.rvm/", false), (Object)true));
            conf.setAllPatterns(patterns);
        }
    }

    public void logConfigurationSettingsChange(@NotNull AbstractRubyRunConfiguration<?> oldRunConfiguration, @NotNull AbstractRubyRunConfiguration<?> newRunConfiguration) {
        if (oldRunConfiguration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(31);
        }
        if (newRunConfiguration == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(32);
        }
        if (oldRunConfiguration.getClass() == newRunConfiguration.getClass() && this.isApplicableFor(oldRunConfiguration) && this.isApplicableFor(newRunConfiguration)) {
            RubyCoverageEnabledConfiguration oldCodeCoverageSettings = RubyCoverageEnabledConfiguration.getFrom(oldRunConfiguration);
            RubyCoverageEnabledConfiguration newCodeCoverageSettings = RubyCoverageEnabledConfiguration.getFrom(newRunConfiguration);
            if (newCodeCoverageSettings != null && oldCodeCoverageSettings != null) {
                boolean newForkedProcessesCoverage;
                boolean oldForkedProcessesCoverage;
                boolean newBranchCoverage;
                boolean oldBranchCoverage;
                boolean newCoverageInTestFolder;
                boolean oldCoverageInTestFolder = oldCodeCoverageSettings.isTrackTestFolders();
                if (oldCoverageInTestFolder != (newCoverageInTestFolder = newCodeCoverageSettings.isTrackTestFolders())) {
                    RubyRunConfigurationSettingChangesCollector.logCoverageInTestFolderChange((ConfigurationType)oldRunConfiguration.getType(), (boolean)oldCoverageInTestFolder, (boolean)newCoverageInTestFolder);
                }
                if ((oldBranchCoverage = oldCodeCoverageSettings.isEnableBranchCoverage()) != (newBranchCoverage = newCodeCoverageSettings.isEnableBranchCoverage())) {
                    RubyRunConfigurationSettingChangesCollector.logBranchCoverageChange((ConfigurationType)oldRunConfiguration.getType(), (boolean)oldBranchCoverage, (boolean)newBranchCoverage);
                }
                if ((oldForkedProcessesCoverage = oldCodeCoverageSettings.isEnableForkedCoverage()) != (newForkedProcessesCoverage = newCodeCoverageSettings.isEnableForkedCoverage())) {
                    RubyRunConfigurationSettingChangesCollector.logForkedProcessesCoverageChange((ConfigurationType)oldRunConfiguration.getType(), (boolean)oldForkedProcessesCoverage, (boolean)newForkedProcessesCoverage);
                }
            }
        }
    }

    @NotNull
    public Set<MetricEvent> logConfigurationSettings(@NotNull List<AbstractRubyRunConfiguration<?>> runConfigurationList) {
        if (runConfigurationList == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(33);
        }
        ArrayList configuredCoverageInTestFolderData = new ArrayList();
        ArrayList configuredBranchCoverageData = new ArrayList();
        ArrayList configuredForkedProcessesCoverageData = new ArrayList();
        for (AbstractRubyRunConfiguration<?> configuration : runConfigurationList) {
            RubyCoverageEnabledConfiguration codeCoverageSettings;
            if (!this.isApplicableFor(configuration) || (codeCoverageSettings = RubyCoverageEnabledConfiguration.getFrom(configuration)) == null) continue;
            configuredCoverageInTestFolderData.add(new Pair((Object)configuration.getType().getClass(), (Object)codeCoverageSettings.isTrackTestFolders()));
            configuredBranchCoverageData.add(new Pair((Object)configuration.getType().getClass(), (Object)codeCoverageSettings.isEnableBranchCoverage()));
            configuredForkedProcessesCoverageData.add(new Pair((Object)configuration.getType().getClass(), (Object)codeCoverageSettings.isEnableForkedCoverage()));
        }
        Set<MetricEvent> set = Stream.of(RubyCoverageRunConfigurationExtension.collectBooleanSettingData(RubyRunConfigurationSettingProjectCollector.CONFIGURED_COVERAGE_IN_TEST_FOLDER_CHANGE, configuredCoverageInTestFolderData), RubyCoverageRunConfigurationExtension.collectBooleanSettingData(RubyRunConfigurationSettingProjectCollector.CONFIGURED_BRANCH_COVERAGE, configuredBranchCoverageData), RubyCoverageRunConfigurationExtension.collectBooleanSettingData(RubyRunConfigurationSettingProjectCollector.CONFIGURED_FORKED_PROCESSES_COVERAGE, configuredForkedProcessesCoverageData)).flatMap(Collection::stream).collect(Collectors.toSet());
        if (set == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private static Set<MetricEvent> collectBooleanSettingData(@NotNull EventId3<Integer, Class<?>, Boolean> eventId3, @NotNull ArrayList<Pair<Class<?>, Boolean>> covData) {
        if (eventId3 == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(35);
        }
        if (covData == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(36);
        }
        Set<MetricEvent> set = covData.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> eventId3.metric((Object)((Long)entry.getValue()).intValue(), (Object)((Class)((Pair)entry.getKey()).getFirst()), (Object)((Boolean)((Pair)entry.getKey()).getSecond()))).collect(Collectors.toSet());
        if (set == null) {
            RubyCoverageRunConfigurationExtension.$$$reportNull$$$0(37);
        }
        return set;
    }

    @Nullable
    protected String getCoverageFilePath(RubyCoverageEnabledConfiguration covConfig) {
        return covConfig.getCoverageFilePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemfile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covConfig";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRunConfiguration";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationList";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/run/RubyCoverageRunConfigurationExtension";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId3";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/run/RubyCoverageRunConfigurationExtension";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "logConfigurationSettings";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBooleanSettingData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleSimpleCovNotFound";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showSimpleCovNotFoundInSdkError";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showSimpleCovNotFoundInModuleError";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showSimpleCovNotFoundInGemfileError";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showSimpleCovError";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "patchCmdlineForSimpleCov";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleCovStarter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "validateConfiguration";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extendCreatedConfiguration";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extendTemplateConfiguration";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettingsChange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettings";
                break;
            }
            case 34: 
            case 37: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectBooleanSettingData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 37 -> new IllegalStateException(string);
        };
    }
}

