/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.yaml.snakeyaml.error.YAMLException;

public final class RubyCoverageUtil {
    private static final Logger LOG = Logger.getInstance(RubyCoverageUtil.class);
    private static final Pattern BLOCK_COMMENT_BEGIN = Pattern.compile("^=begin\\b");
    private static final Pattern BLOCK_COMMENT_END = Pattern.compile("^=end\\b");
    private static final Pattern FILE_END_DIRECTIVE = Pattern.compile("^__END__\\b");
    private static final Pattern LINE_COMMENT_OR_WS = Pattern.compile("^\\s*(#|$)");

    private RubyCoverageUtil() {
    }

    public static boolean[] determineSrcCodeLines(String[] lines, @Nullable List<RCovCoverageType> coverage) {
        SrcLineState state = SrcLineState.CODE;
        boolean[] srcLinesMapping = new boolean[lines.length];
        int linesNumber = lines.length;
        block4: for (int i = 0; i < linesNumber; ++i) {
            srcLinesMapping[i] = false;
            if (state == SrcLineState.FILE_END_DATA) continue;
            if (RubyCoverageUtil.isMostLikelySrcCode(i, coverage)) {
                srcLinesMapping[i] = true;
                continue;
            }
            String line = lines[i];
            if (LINE_COMMENT_OR_WS.matcher(line).find()) continue;
            switch (state.ordinal()) {
                case 0: {
                    if (BLOCK_COMMENT_BEGIN.matcher(line).find()) {
                        state = SrcLineState.COMMENT;
                        continue block4;
                    }
                    if (FILE_END_DIRECTIVE.matcher(line).find()) {
                        state = SrcLineState.FILE_END_DATA;
                        continue block4;
                    }
                    srcLinesMapping[i] = true;
                    continue block4;
                }
                case 1: {
                    if (!BLOCK_COMMENT_END.matcher(line).find()) continue block4;
                    state = SrcLineState.CODE;
                }
            }
        }
        return srcLinesMapping;
    }

    private static boolean isMostLikelySrcCode(int line, List<RCovCoverageType> coverage) {
        return coverage != null && line < coverage.size() && coverage.get(line) == RCovCoverageType.COVERED;
    }

    public static boolean @Nullable [] determineSrcCodeLines(@NotNull File file) {
        String text;
        if (file == null) {
            RubyCoverageUtil.$$$reportNull$$$0(0);
        }
        try {
            text = FileUtil.loadFile((File)file);
        }
        catch (IOException e) {
            text = null;
            LOG.warn("Unable to read content of : " + file.getPath());
        }
        if (text == null) {
            return null;
        }
        List lines = StringUtil.split((String)text, (String)"\n", (boolean)false);
        return RubyCoverageUtil.determineSrcCodeLines(ArrayUtilRt.toStringArray((Collection)lines), null);
    }

    public static boolean isMostLikelyNonSrcCode(int line, RCovRawFileData rawFileData) {
        RCovCoverageType lineCoverage = rawFileData.getCoverage(line);
        return !rawFileData.isSourceCode(line) && (lineCoverage == RCovCoverageType.INFERRED || lineCoverage == RCovCoverageType.NOT_COVERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadYaml(String serializedDataPath, Logger log) {
        Map yamlContent;
        File file = new File(serializedDataPath);
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(file);){
            yamlContent = RubyUtil.loadYaml((InputStream)in);
        }
        catch (YAMLException e) {
            log.error("Cannot parse yaml report: " + serializedDataPath, (Throwable)e);
            yamlContent = null;
        }
        catch (Exception e) {
            log.error("Cannot parse yaml report: non-yaml error " + serializedDataPath, (Throwable)e);
            yamlContent = null;
        }
        return yamlContent;
    }

    public static boolean isSimplecovGemPresent(@Nullable AbstractRubyRunConfiguration<?> config, @Nullable Module module, @Nullable Sdk sdk) {
        if (config != null && sdk != null && config.shouldUseAlternativeSdk()) {
            RFile gemfile = BundlerUtil.getGemfilePsiFile((Module)module);
            return ContainerUtil.getFirstItem((List)RubyGemSearchService.getInstance().findGems(sdk, "simplecov")) != null && (gemfile == null || BundlerUtil.isGemMentioned((RFile)gemfile, (Sdk)sdk, (String)"simplecov"));
        }
        if (BundlerUtil.hasGemfile((Module)module)) {
            return RubyProjectGemSearchService.Companion.findGem(module, "simplecov") != null;
        }
        return RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)"simplecov") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/coverage/RubyCoverageUtil", "determineSrcCodeLines"));
    }

    private static enum SrcLineState {
        CODE,
        COMMENT,
        FILE_END_DATA;

    }
}

