/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.DummyCoverageLoadErrorReporter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationProvider;

public class RubyCoverageDeserializationService {
    private static final Logger LOG = Logger.getInstance(RubyCoverageDeserializationService.class);

    public static RubyCoverageDeserializationService getInstance() {
        return (RubyCoverageDeserializationService)ApplicationManager.getApplication().getService(RubyCoverageDeserializationService.class);
    }

    @Nullable
    public List<RCovRawFileData> deserialize(@NotNull String filePath) {
        if (filePath == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(0);
        }
        return this.deserialize(filePath, (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter());
    }

    @Nullable
    public List<RCovRawFileData> deserialize(@NotNull String filePath, @NotNull CoverageLoadErrorReporter reporter) {
        RubyCoverageDeserializationProvider provider;
        if (filePath == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(2);
        }
        if ((provider = this.determineCoverageDataProvider(filePath, reporter)) == null) {
            return null;
        }
        try {
            return provider.deserialize(filePath);
        }
        catch (Exception e) {
            LOG.error("Unable to parse coverage data from " + filePath, (Throwable)e);
            reporter.reportError(e);
            return null;
        }
    }

    @Nullable
    public RubyCoverageDeserializationProvider determineCoverageDataProvider(@NotNull String filePath) {
        if (filePath == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(3);
        }
        return this.determineCoverageDataProvider(filePath, (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RubyCoverageDeserializationProvider determineCoverageDataProvider(@NotNull String filePath, @NotNull CoverageLoadErrorReporter reporter) {
        if (filePath == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(4);
        }
        if (reporter == null) {
            RubyCoverageDeserializationService.$$$reportNull$$$0(5);
        }
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(filePath, "r");
            String firstLine = file.readLine();
            if (firstLine == null) {
                LOG.warn("Empty coverage file: " + filePath);
                reporter.reportWarning("Empty coverage file: " + filePath, null);
                RubyCoverageDeserializationProvider rubyCoverageDeserializationProvider = null;
                return rubyCoverageDeserializationProvider;
            }
            for (RubyCoverageDeserializationProvider provider : RubyCoverageDeserializationProvider.EP_NAME.getExtensionList()) {
                if (!provider.acceptsFormat(filePath, firstLine)) continue;
                RubyCoverageDeserializationProvider rubyCoverageDeserializationProvider = provider;
                return rubyCoverageDeserializationProvider;
            }
            String message = "Could not determine coverage deserializer for file: " + filePath;
            LOG.warn(message);
            reporter.reportError(message);
        }
        catch (IOException e) {
            LOG.error("Unable to determine coverage deserializer from " + filePath, (Throwable)e);
            reporter.reportError((Exception)e);
            Iterator iterator = null;
            return iterator;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    LOG.error("Error closing coverage file stream");
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/RubyCoverageDeserializationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "determineCoverageDataProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

