/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.epp.ide.editor;

import com.intellij.lang.puppet.ruby.epp.elementTypes.EppElementType;
import com.intellij.lang.puppet.ruby.epp.elementTypes.EppElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EppSmartKeysUtil {
    EppSmartKeysUtil() {
    }

    @NotNull
    static TokenInfo getPrevEppTokenInfo(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(0);
        }
        return EppSmartKeysUtil.getRelativeTokenInfo(editor, offset, (Consumer<? super HighlighterIterator>)((Consumer)iterator -> iterator.retreat()));
    }

    @NotNull
    static TokenInfo getNextEppTokenInfo(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(1);
        }
        return EppSmartKeysUtil.getRelativeTokenInfo(editor, offset, (Consumer<? super HighlighterIterator>)((Consumer)iterator -> iterator.advance()));
    }

    @NotNull
    static TokenInfo getRelativeTokenInfo(@NotNull Editor editor, int offset, Consumer<? super HighlighterIterator> highlighterMutator) {
        if (editor == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(2);
        }
        if (offset < 0) {
            TokenInfo tokenInfo = TokenInfo.EMPTY_TOKEN_INFO;
            if (tokenInfo == null) {
                EppSmartKeysUtil.$$$reportNull$$$0(3);
            }
            return tokenInfo;
        }
        HighlighterIterator iterator = EppSmartKeysUtil.getHighlighterIterator(editor, offset);
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType != EppElementTypes.EPP_TEMPLATE_BLOCK && tokenType instanceof EppElementType) {
                TokenInfo tokenInfo = TokenInfo.create(iterator);
                if (tokenInfo == null) {
                    EppSmartKeysUtil.$$$reportNull$$$0(4);
                }
                return tokenInfo;
            }
            highlighterMutator.consume((Object)iterator);
        }
        TokenInfo tokenInfo = TokenInfo.EMPTY_TOKEN_INFO;
        if (tokenInfo == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(5);
        }
        return tokenInfo;
    }

    static boolean charIs(@NotNull CharSequence sequence, int offset, char c) {
        if (sequence == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(6);
        }
        return sequence.length() > offset && sequence.charAt(offset) == c;
    }

    static boolean textIs(@NotNull CharSequence sequence, int offset, CharSequence subsequence) {
        if (sequence == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(7);
        }
        int endOffset = offset + subsequence.length();
        return sequence.length() > endOffset && StringUtil.equals((CharSequence)sequence.subSequence(offset, endOffset), (CharSequence)subsequence);
    }

    @NotNull
    static HighlighterIterator getHighlighterIterator(@NotNull Editor editor, int offset) {
        EditorHighlighter highlighter;
        if (editor == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(8);
        }
        HighlighterIterator highlighterIterator = (highlighter = editor.getHighlighter()) instanceof LayeredLexerEditorHighlighter ? ((LayeredLexerEditorHighlighter)highlighter).createBaseIterator(offset) : highlighter.createIterator(offset);
        if (highlighterIterator == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(9);
        }
        return highlighterIterator;
    }

    @NotNull
    static TokenInfo getTokenInfo(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(10);
        }
        TokenInfo tokenInfo = TokenInfo.create(EppSmartKeysUtil.getHighlighterIterator(editor, offset));
        if (tokenInfo == null) {
            EppSmartKeysUtil.$$$reportNull$$$0(11);
        }
        return tokenInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppSmartKeysUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppSmartKeysUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeTokenInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighterIterator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrevEppTokenInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNextEppTokenInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeTokenInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "charIs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "textIs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighterIterator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTokenInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9, 11 -> new IllegalStateException(string);
        };
    }

    static class TokenInfo {
        static TokenInfo EMPTY_TOKEN_INFO = new TokenInfo();
        IElementType tokenType;
        int startOffset;
        int endOffset;

        TokenInfo() {
        }

        public boolean isEmpty() {
            return this.tokenType == null;
        }

        public void deleteFrom(@NotNull Document document) {
            if (document == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            document.deleteString(this.startOffset, this.endOffset);
        }

        @NotNull
        public static TokenInfo create(@NotNull IElementType elementType, int startOffset, int endOffset) {
            if (elementType == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            TokenInfo info = new TokenInfo();
            info.tokenType = elementType;
            info.startOffset = startOffset;
            info.endOffset = endOffset;
            TokenInfo tokenInfo = info;
            if (tokenInfo == null) {
                TokenInfo.$$$reportNull$$$0(2);
            }
            return tokenInfo;
        }

        @NotNull
        public static TokenInfo create(@Nullable HighlighterIterator iterator) {
            if (iterator == null) {
                TokenInfo tokenInfo = EMPTY_TOKEN_INFO;
                if (tokenInfo == null) {
                    TokenInfo.$$$reportNull$$$0(3);
                }
                return tokenInfo;
            }
            IElementType type = iterator.getTokenType();
            return type == null ? EMPTY_TOKEN_INFO : TokenInfo.create(type, iterator.getStart(), iterator.getEnd());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppSmartKeysUtil$TokenInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppSmartKeysUtil$TokenInfo";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

